/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.ConfigFluentImpl;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$;
import org.apache.spark.util.ThreadUtils$;
import org.spark_project.guava.base.Charsets;
import org.spark_project.guava.io.Files;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;

public final class SparkKubernetesClientFactory$ {
    public static SparkKubernetesClientFactory$ MODULE$;

    static {
        new SparkKubernetesClientFactory$();
    }

    public KubernetesClient createKubernetesClient(String master, Option<String> namespace, String kubernetesAuthConfPrefix, SparkConf sparkConf, Option<File> defaultServiceAccountToken, Option<File> defaultServiceAccountCaCert) {
        String oauthTokenFileConf = new StringBuilder(1).append(kubernetesAuthConfPrefix).append(".").append(Config$.MODULE$.OAUTH_TOKEN_FILE_CONF_SUFFIX()).toString();
        String oauthTokenConf = new StringBuilder(1).append(kubernetesAuthConfPrefix).append(".").append(Config$.MODULE$.OAUTH_TOKEN_CONF_SUFFIX()).toString();
        Option oauthTokenFile = sparkConf.getOption(oauthTokenFileConf).map((Function1 & Serializable & scala.Serializable)x$1 -> new File((String)x$1)).orElse((Function0 & Serializable & scala.Serializable)() -> defaultServiceAccountToken);
        Option oauthTokenValue = sparkConf.getOption(oauthTokenConf);
        KubernetesUtils$.MODULE$.requireNandDefined(oauthTokenFile, oauthTokenValue, new StringBuilder(54).append("Cannot specify OAuth token through both a file ").append(oauthTokenFileConf).append(" and a ").append(new StringBuilder(7).append("value ").append(oauthTokenConf).append(".").toString()).toString());
        Option caCertFile = sparkConf.getOption(new StringBuilder(1).append(kubernetesAuthConfPrefix).append(".").append(Config$.MODULE$.CA_CERT_FILE_CONF_SUFFIX()).toString()).orElse((Function0 & Serializable & scala.Serializable)() -> defaultServiceAccountCaCert.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getAbsolutePath()));
        Option clientKeyFile = sparkConf.getOption(new StringBuilder(1).append(kubernetesAuthConfPrefix).append(".").append(Config$.MODULE$.CLIENT_KEY_FILE_CONF_SUFFIX()).toString());
        Option clientCertFile = sparkConf.getOption(new StringBuilder(1).append(kubernetesAuthConfPrefix).append(".").append(Config$.MODULE$.CLIENT_CERT_FILE_CONF_SUFFIX()).toString());
        Dispatcher dispatcher = new Dispatcher((ExecutorService)ThreadUtils$.MODULE$.newDaemonCachedThreadPool("kubernetes-dispatcher"));
        Config config = SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder(SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder(SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder(SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder(SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder(SparkKubernetesClientFactory$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder((ConfigBuilder)((ConfigFluentImpl)((ConfigFluentImpl)new ConfigBuilder().withApiVersion("v1")).withMasterUrl(master)).withWebsocketPingInterval(0L)), oauthTokenValue, (Function2 & Serializable & scala.Serializable)(token, configBuilder) -> (ConfigBuilder)configBuilder.withOauthToken(token))), oauthTokenFile, (Function2 & Serializable & scala.Serializable)(file, configBuilder) -> (ConfigBuilder)configBuilder.withOauthToken(Files.toString((File)file, (Charset)Charsets.UTF_8)))), caCertFile, (Function2 & Serializable & scala.Serializable)(file, configBuilder) -> (ConfigBuilder)configBuilder.withCaCertFile(file))), clientKeyFile, (Function2 & Serializable & scala.Serializable)(file, configBuilder) -> (ConfigBuilder)configBuilder.withClientKeyFile(file))), clientCertFile, (Function2 & Serializable & scala.Serializable)(file, configBuilder) -> (ConfigBuilder)configBuilder.withClientCertFile(file))), namespace, (Function2 & Serializable & scala.Serializable)(ns, configBuilder) -> (ConfigBuilder)configBuilder.withNamespace(ns)).build();
        OkHttpClient baseHttpClient = HttpClientUtils.createHttpClient((Config)config);
        OkHttpClient httpClientWithCustomDispatcher = baseHttpClient.newBuilder().dispatcher(dispatcher).build();
        return new DefaultKubernetesClient(httpClientWithCustomDispatcher, config);
    }

    private ConfigBuilder OptionConfigurableConfigBuilder(ConfigBuilder configBuilder) {
        return configBuilder;
    }

    private SparkKubernetesClientFactory$() {
        MODULE$ = this;
    }
}

