/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jline.console.ConsoleReader;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.cli.CliDriver;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.cli.OptionsProcessor;
import org.apache.hadoop.hive.common.HiveInterruptUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.util.SQLKeywordUtils$;
import org.apache.spark.sql.hive.client.HiveClientImpl$;
import org.apache.spark.sql.hive.security.HiveDelegationTokenProvider;
import org.apache.spark.sql.hive.thriftserver.ReflectionUtils$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver;
import org.apache.spark.sql.hive.thriftserver.SparkSQLEnv$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.SessionResourceLoader;
import org.apache.spark.sql.internal.SharedState$;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.SparkExitCode$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

public final class SparkSQLCLIDriver$
implements Logging {
    public static final SparkSQLCLIDriver$ MODULE$ = new SparkSQLCLIDriver$();
    private static final String prompt;
    private static final String continuedPrompt;
    private static int exitCode;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        prompt = "spark-sql";
        continuedPrompt = StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(""), MODULE$.prompt().length(), ' ');
        exitCode = 0;
        MODULE$.initializeLogIfNecessary(true);
        MODULE$.installSignalHandler();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String prompt() {
        return prompt;
    }

    private String continuedPrompt() {
        return continuedPrompt;
    }

    private final String SPARK_HADOOP_PROP_PREFIX() {
        return "spark.hadoop.";
    }

    private int exitCode() {
        return exitCode;
    }

    private void exitCode_$eq(int x$1) {
        exitCode = x$1;
    }

    public void installSignalHandler() {
        HiveInterruptUtils.add(() -> {
            if (SparkSQLEnv$.MODULE$.sparkContext() != null) {
                SparkSQLEnv$.MODULE$.sparkContext().cancelAllJobs();
                return;
            }
        });
    }

    public void exit(int code) {
        this.exitCode_$eq(code);
        System.exit(this.exitCode());
    }

    public void main(String[] args) {
        OptionsProcessor oproc = new OptionsProcessor();
        if (!oproc.process_stage1(args)) {
            System.exit(SparkExitCode$.MODULE$.EXIT_FAILURE());
        }
        SparkConf sparkConf = new SparkConf(true);
        Configuration hadoopConf = SparkHadoopUtil$.MODULE$.get().newConfiguration(sparkConf);
        HiveConf cliConf = HiveClientImpl$.MODULE$.newHiveConf(sparkConf, (Iterable)hadoopConf, HiveClientImpl$.MODULE$.newHiveConf$default$3(), HiveClientImpl$.MODULE$.newHiveConf$default$4());
        CliSessionState sessionState = new CliSessionState(cliConf);
        sessionState.in = System.in;
        try {
            sessionState.out = new PrintStream((OutputStream)System.out, true, StandardCharsets.UTF_8.name());
            sessionState.info = new PrintStream((OutputStream)System.err, true, StandardCharsets.UTF_8.name());
            sessionState.err = new PrintStream((OutputStream)System.err, true, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$closeHiveSessionStateIfStarted((SessionState)sessionState);
            this.exit(SparkExitCode$.MODULE$.ERROR_PATH_NOT_FOUND());
        }
        if (!oproc.process_stage2(sessionState)) {
            this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$closeHiveSessionStateIfStarted((SessionState)sessionState);
            this.exit(SparkExitCode$.MODULE$.ERROR_MISUSE_SHELL_BUILTIN());
        }
        HiveConf conf = sessionState.getConf();
        conf.setClassLoader(Thread.currentThread().getContextClassLoader());
        CollectionConverters$.MODULE$.SetHasAsScala(sessionState.cmdProperties.entrySet()).asScala().foreach((Function1 & Serializable)item -> {
            String key = item.getKey().toString();
            String value = item.getValue().toString();
            String string = key;
            String string2 = "javax.jdo.option.ConnectionURL";
            if (string == null ? string2 != null : !string.equals(string2)) {
                conf.set(key, value);
                return sessionState.getOverriddenConfigurations().put(key, value);
            }
            return BoxedUnit.UNIT;
        });
        HiveDelegationTokenProvider tokenProvider = new HiveDelegationTokenProvider();
        if (tokenProvider.delegationTokensRequired(sparkConf, hadoopConf)) {
            Credentials credentials = new Credentials();
            tokenProvider.obtainDelegationTokens(hadoopConf, sparkConf, credentials);
            UserGroupInformation.getCurrentUser().addCredentials(credentials);
        }
        String warehousePath = SharedState$.MODULE$.resolveWarehousePath(sparkConf, (Configuration)conf, SharedState$.MODULE$.resolveWarehousePath$default$3());
        String qualified = SharedState$.MODULE$.qualifyWarehousePath((Configuration)conf, warehousePath);
        SharedState$.MODULE$.setWarehousePathConf(sparkConf, (Configuration)conf, qualified);
        SessionState.setCurrentSessionState((SessionState)sessionState);
        ShutdownHookManager$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$closeHiveSessionStateIfStarted((SessionState)sessionState);
            SparkSQLEnv$.MODULE$.stop(MODULE$.exitCode());
        });
        Set hiveConfFromCmd = CollectionConverters$.MODULE$.SetHasAsScala(sessionState.getOverriddenConfigurations().entrySet()).asScala();
        Set newHiveConf = (Set)hiveConfFromCmd.map((Function1 & Serializable)kv -> {
            String k = (String)kv.getKey();
            String v = (String)package$.MODULE$.props().getOrElseUpdate((Object)("spark.hadoop." + k), (Function0 & Serializable)() -> (String)kv.getValue());
            return new Tuple2((Object)k, (Object)v);
        });
        SparkSQLCLIDriver cli = new SparkSQLCLIDriver();
        cli.setHiveVariables(oproc.getHiveVariables());
        String auxJars = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.getConfVars((String)"hive.aux.jars.path"));
        if (StringUtils.isNotBlank((CharSequence)auxJars)) {
            SessionResourceLoader resourceLoader = SparkSQLEnv$.MODULE$.sparkSession().sessionState().resourceLoader();
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])StringUtils.split((String)auxJars, (String)",")), (Function1 & Serializable)x$1 -> {
                resourceLoader.addJar(x$1);
                return BoxedUnit.UNIT;
            });
        }
        sessionState.getConf().setClassLoader((ClassLoader)SparkSQLEnv$.MODULE$.sparkSession().sharedState().jarClassLoader());
        sessionState.in = System.in;
        try {
            sessionState.out = new PrintStream((OutputStream)System.out, true, StandardCharsets.UTF_8.name());
            sessionState.info = new PrintStream((OutputStream)System.err, true, StandardCharsets.UTF_8.name());
            sessionState.err = new PrintStream((OutputStream)System.err, true, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            this.exit(SparkExitCode$.MODULE$.ERROR_PATH_NOT_FOUND());
        }
        newHiveConf.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SparkSQLCLIDriver$.$anonfun$main$6(check$ifrefutable$1))).withFilter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SparkSQLCLIDriver$.$anonfun$main$7(x$2))).foreach((Function1 & Serializable)x$3 -> {
            SparkSQLCLIDriver$.$anonfun$main$8(x$3);
            return BoxedUnit.UNIT;
        });
        Object object = sessionState.database != null ? SparkSQLEnv$.MODULE$.sparkSession().sql("USE " + sessionState.database) : BoxedUnit.UNIT;
        cli.processInitFiles(sessionState);
        cli.printMasterAndAppId();
        if (sessionState.execString != null) {
            this.exit(cli.processLine(sessionState.execString));
        }
        try {
            if (sessionState.fileName != null) {
                this.exit(cli.processFile(sessionState.fileName));
            }
        }
        catch (FileNotFoundException e) {
            this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Could not open input file for reading. (", ")"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.ERROR$.MODULE$, (Object)e.getMessage())}))));
            this.exit(SparkExitCode$.MODULE$.ERROR_PATH_NOT_FOUND());
        }
        ConsoleReader reader = new ConsoleReader();
        reader.setBellEnabled(false);
        reader.setExpandEvents(false);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.getCommandCompleter()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)reader.addCompleter(x$1)));
        String historyDirectory = System.getProperty("user.home");
        try {
            if (new File(historyDirectory).exists()) {
                String historyFile = historyDirectory + File.separator + ".hivehistory";
                reader.setHistory((History)new FileHistory(new File(historyFile)));
            } else {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Directory for Hive history file: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.HISTORY_DIR$.MODULE$, (Object)historyDirectory)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" does not exist. History will not be available during this session."}))).log((Seq)Nil$.MODULE$))));
            }
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Encountered an error while trying to initialize Hive's history file. History will not be available during this session.", (Throwable)e);
        }
        ShutdownHookManager$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            History history = reader.getHistory();
            if (history instanceof FileHistory) {
                BoxedUnit boxedUnit;
                FileHistory fileHistory = (FileHistory)history;
                try {
                    fileHistory.flush();
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (IOException e) {
                    MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to write command history file: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.ERROR$.MODULE$, (Object)e.getMessage())}))));
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
        });
        int ret = 0;
        Object prefix = "";
        String currentPrompt = this.promptWithCurrentDB$1(conf, sessionState);
        Object line = reader.readLine(currentPrompt + "> ");
        while (line != null) {
            if (!((String)line).startsWith("--")) {
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)prefix))) {
                    prefix = (String)prefix + '\n';
                }
                if (((String)line).trim().endsWith(";") && !((String)line).trim().endsWith("\\;")) {
                    line = (String)prefix + (String)line;
                    ret = cli.processLine((String)line, true);
                    prefix = "";
                    currentPrompt = this.promptWithCurrentDB$1(conf, sessionState);
                } else {
                    prefix = (String)prefix + (String)line;
                    currentPrompt = this.continuedPromptWithDBSpaces$1(conf, sessionState);
                }
            }
            line = reader.readLine(currentPrompt + "> ");
        }
        this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$closeHiveSessionStateIfStarted((SessionState)sessionState);
        this.exit(ret);
    }

    public void printUsage() {
        OptionsProcessor processor = new OptionsProcessor();
        ReflectionUtils$.MODULE$.invoke(OptionsProcessor.class, processor, "printUsage", (Seq<Tuple2<Class<?>, Object>>)Nil$.MODULE$);
    }

    public void org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$closeHiveSessionStateIfStarted(SessionState state) {
        if (BoxesRunTime.unboxToBoolean(ReflectionUtils$.MODULE$.getSuperField(state, "isStarted"))) {
            state.close();
            return;
        }
    }

    private Completer[] getCommandCompleter() {
        ArrayList candidateStrings = new ArrayList();
        ((IterableOnceOps)FunctionRegistry$.MODULE$.builtin().listFunction().map((Function1 & Serializable)x$4 -> x$4.funcName())).foreach((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)SparkSQLCLIDriver$.$anonfun$getCommandCompleter$2(candidateStrings, s)));
        SQLKeywordUtils$.MODULE$.keywords().foreach((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)SparkSQLCLIDriver$.$anonfun$getCommandCompleter$3(candidateStrings, s)));
        StringsCompleter strCompleter = new StringsCompleter(candidateStrings);
        ArgumentCompleter.AbstractArgumentDelimiter delim = new ArgumentCompleter.AbstractArgumentDelimiter(){

            public boolean isDelimiterChar(CharSequence buffer, int pos) {
                char c = buffer.charAt(pos);
                return Character.isWhitespace(c) || c == '(' || c == ')' || c == '[' || c == ']';
            }
        };
        ArgumentCompleter argCompleter = new ArgumentCompleter((ArgumentCompleter.ArgumentDelimiter)delim, new Completer[]{strCompleter});
        argCompleter.setStrict(false);
        Completer customCompleter = new Completer(argCompleter){
            private final ArgumentCompleter argCompleter$1;

            public int complete(String buffer, int offset, List<CharSequence> completions) {
                List<CharSequence> comp = completions;
                int ret = this.argCompleter$1.complete(buffer, offset, completions);
                Object object = completions.size() == 1 && ((String)comp.get(0)).endsWith("( ") ? comp.set(0, ((String)comp.get(0)).trim()) : BoxedUnit.UNIT;
                return ret;
            }
            {
                this.argCompleter$1 = argCompleter$1;
            }
        };
        StringsCompleter confCompleter = new StringsCompleter(){

            public int complete(String buffer, int cursor, List<CharSequence> clist) {
                return super.complete(buffer, cursor, clist);
            }
        };
        StringsCompleter setCompleter = new StringsCompleter(){

            public int complete(String buffer, int cursor, List<CharSequence> clist) {
                if (buffer != null && buffer.equalsIgnoreCase("set")) {
                    return super.complete(buffer, cursor, clist);
                }
                return -1;
            }
        };
        ArgumentCompleter propCompleter = new ArgumentCompleter(setCompleter, confCompleter){

            public int complete(String buffer, int offset, List<CharSequence> completions) {
                int ret = super.complete(buffer, offset, completions);
                Object object = completions.size() == 1 ? completions.set(0, ((String)completions.get(0)).trim()) : BoxedUnit.UNIT;
                return ret;
            }
        };
        return (Completer[])((Object[])new Completer[]{propCompleter, customCompleter});
    }

    public static final /* synthetic */ boolean $anonfun$main$6(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$main$7(Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 != null) {
            String k;
            String string = k = (String)tuple2._1();
            String string2 = "hive.metastore.warehouse.dir";
            return string == null ? string2 != null : !string.equals(string2);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$main$8(Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            SparkSQLEnv$.MODULE$.sparkSession().conf().set(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final Object currentDB$1(HiveConf conf$1, CliSessionState sessionState$1) {
        if (!BoxesRunTime.unboxToBoolean((Object)SparkSQLEnv$.MODULE$.sparkSession().sessionState().conf().getConf(SQLConf$.MODULE$.LEGACY_EMPTY_CURRENT_DB_IN_CLI()))) {
            return " (" + SparkSQLEnv$.MODULE$.sparkSession().catalog().currentDatabase() + ")";
        }
        return ReflectionUtils$.MODULE$.invokeStatic(CliDriver.class, "getFormattedDb", (Seq<Tuple2<Class<?>, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(HiveConf.class), (Object)conf$1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(CliSessionState.class), (Object)sessionState$1)}));
    }

    private final String promptWithCurrentDB$1(HiveConf conf$1, CliSessionState sessionState$1) {
        return this.prompt() + SparkSQLCLIDriver$.currentDB$1(conf$1, sessionState$1);
    }

    private final String continuedPromptWithDBSpaces$1(HiveConf conf$1, CliSessionState sessionState$1) {
        return this.continuedPrompt() + ReflectionUtils$.MODULE$.invokeStatic(CliDriver.class, "spacesForString", (Seq<Tuple2<Class<?>, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(String.class), SparkSQLCLIDriver$.currentDB$1(conf$1, sessionState$1))}));
    }

    public static final /* synthetic */ boolean $anonfun$getCommandCompleter$2(ArrayList candidateStrings$1, String s) {
        if (s.matches("[a-z_]+")) {
            return candidateStrings$1.add(s + "(");
        }
        return candidateStrings$1.add(s);
    }

    public static final /* synthetic */ boolean $anonfun$getCommandCompleter$3(ArrayList candidateStrings$1, String s) {
        candidateStrings$1.add(s);
        return candidateStrings$1.add(s.toLowerCase(Locale.ROOT));
    }

    private SparkSQLCLIDriver$() {
    }
}

