/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObjectUtils;
import org.apache.hive.service.cli.CLIServiceUtils;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.operation.GetTablesOperation;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2$;
import org.apache.spark.sql.hive.thriftserver.SparkOperation;
import org.apache.spark.sql.internal.NonClosableMutableURLClassLoader;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005A4Qa\u0003\u0007\u0001\u001daA\u0001B\f\u0001\u0003\u0006\u0004%\t\u0001\r\u0005\tk\u0001\u0011\t\u0011)A\u0005c!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0011!Q\u0005A!A!\u0002\u0013i\u0004\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u00111\u0003!\u0011!Q\u0001\n5CQ!\u0016\u0001\u0005\u0002YCQA\u0018\u0001\u0005B}CQ\u0001\u001a\u0001\u0005\n\u0015\u0014qc\u00159be.<U\r\u001e+bE2,7o\u00149fe\u0006$\u0018n\u001c8\u000b\u00055q\u0011\u0001\u0004;ie&4Go]3sm\u0016\u0014(BA\b\u0011\u0003\u0011A\u0017N^3\u000b\u0005E\u0011\u0012aA:rY*\u00111\u0003F\u0001\u0006gB\f'o\u001b\u0006\u0003+Y\ta!\u00199bG\",'\"A\f\u0002\u0007=\u0014xm\u0005\u0003\u00013\u0011B\u0003C\u0001\u000e#\u001b\u0005Y\"B\u0001\u000f\u001e\u0003%y\u0007/\u001a:bi&|gN\u0003\u0002\u001f?\u0005\u00191\r\\5\u000b\u0005\u0001\n\u0013aB:feZL7-\u001a\u0006\u0003\u001fQI!aI\u000e\u0003%\u001d+G\u000fV1cY\u0016\u001cx\n]3sCRLwN\u001c\t\u0003K\u0019j\u0011\u0001D\u0005\u0003O1\u0011ab\u00159be.|\u0005/\u001a:bi&|g\u000e\u0005\u0002*Y5\t!F\u0003\u0002,%\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002.U\t9Aj\\4hS:<\u0017aB:fgNLwN\\\u0002\u0001+\u0005\t\u0004C\u0001\u001a4\u001b\u0005\u0001\u0012B\u0001\u001b\u0011\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003!\u0019Xm]:j_:\u0004\u0013!\u00049be\u0016tGoU3tg&|g\u000e\u0005\u00029u5\t\u0011H\u0003\u0002/;%\u00111(\u000f\u0002\f\u0011&4XmU3tg&|g.A\u0006dCR\fGn\\4OC6,\u0007C\u0001 H\u001d\tyT\t\u0005\u0002A\u00076\t\u0011I\u0003\u0002C_\u00051AH]8pizR\u0011\u0001R\u0001\u0006g\u000e\fG.Y\u0005\u0003\r\u000e\u000ba\u0001\u0015:fI\u00164\u0017B\u0001%J\u0005\u0019\u0019FO]5oO*\u0011aiQ\u0001\u000bg\u000eDW-\\1OC6,\u0017!\u0003;bE2,g*Y7f\u0003)!\u0018M\u00197f)f\u0004Xm\u001d\t\u0004\u001dNkT\"A(\u000b\u0005A\u000b\u0016\u0001B;uS2T\u0011AU\u0001\u0005U\u00064\u0018-\u0003\u0002U\u001f\n!A*[:u\u0003\u0019a\u0014N\\5u}Q9q\u000bW-[7rk\u0006CA\u0013\u0001\u0011\u0015q\u0003\u00021\u00012\u0011\u00151\u0004\u00021\u00018\u0011\u0015a\u0004\u00021\u0001>\u0011\u0015Q\u0005\u00021\u0001>\u0011\u0015Y\u0005\u00021\u0001>\u0011\u0015a\u0005\u00021\u0001N\u0003-\u0011XO\\%oi\u0016\u0014h.\u00197\u0015\u0003\u0001\u0004\"!\u00192\u000e\u0003\rK!aY\"\u0003\tUs\u0017\u000e^\u0001\fC\u0012$Gk\u001c*poN+G\u000fF\u0003aM\"L7\u000eC\u0003h\u0015\u0001\u0007Q(\u0001\u0004eE:\u000bW.\u001a\u0005\u0006\u0017*\u0001\r!\u0010\u0005\u0006U*\u0001\r!P\u0001\ni\u0006\u0014G.\u001a+za\u0016DQ\u0001\u001c\u0006A\u00025\fqaY8n[\u0016tG\u000fE\u0002b]vJ!a\\\"\u0003\r=\u0003H/[8o\u0001")
public class SparkGetTablesOperation
extends GetTablesOperation
implements SparkOperation {
    private final SparkSession session;
    private final HiveSession parentSession;
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final List<String> tableTypes;
    private String statementId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$run() {
        super.run();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$close() {
        super.close();
    }

    @Override
    public /* synthetic */ OperationState org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$setState(OperationState newState) {
        return super.setState(newState);
    }

    @Override
    public void cleanup() {
        SparkOperation.cleanup$(this);
    }

    @Override
    public void run() {
        SparkOperation.run$(this);
    }

    @Override
    public void close() {
        SparkOperation.close$(this);
    }

    @Override
    public <T> T withLocalProperties(Function0<T> f) {
        return (T)SparkOperation.withLocalProperties$(this, f);
    }

    @Override
    public String tableTypeString(CatalogTableType tableType) {
        return SparkOperation.tableTypeString$(this, tableType);
    }

    @Override
    public PartialFunction<Throwable, BoxedUnit> onError() {
        return SparkOperation.onError$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public String statementId() {
        return this.statementId;
    }

    @Override
    public void statementId_$eq(String x$1) {
        this.statementId = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public SparkSession session() {
        return this.session;
    }

    @Override
    public void runInternal() {
        Object object;
        String cmdStr = "catalog : " + this.catalogName + ", schemaPattern : " + this.schemaName;
        String tableTypesStr = this.tableTypes == null ? "null" : CollectionConverters$.MODULE$.ListHasAsScala(this.tableTypes).asScala().mkString(",");
        String logMsg = "Listing tables '" + cmdStr + ", tableTypes : " + tableTypesStr + ", tableName : " + this.tableName + "'";
        String catalogNameStr = this.catalogName == null ? "null" : this.catalogName;
        String schemaNameStr = this.schemaName == null ? "null" : this.schemaName;
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Listing tables 'catalog: ", ", "}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CATALOG_NAME$.MODULE$, (Object)catalogNameStr)})).$plus(this.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"schemaPattern: ", ", "}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DATABASE_NAME$.MODULE$, (Object)schemaNameStr)}))).$plus(this.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tableTypes: ", ", "}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.TABLE_TYPES$.MODULE$, (Object)tableTypesStr)}))).$plus(this.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tableName: ", "' "}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.TABLE_NAME$.MODULE$, (Object)$this.tableName)}))).$plus(this.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"with ", ""}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.STATEMENT_ID$.MODULE$, (Object)this.statementId())})))));
        this.setState(OperationState.RUNNING);
        NonClosableMutableURLClassLoader executionHiveClassLoader = this.session().sharedState().jarClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)executionHiveClassLoader);
        SessionCatalog catalog = this.session().sessionState().catalog();
        String schemaPattern = this.convertSchemaPattern(this.schemaName);
        String tablePattern = this.convertIdentifierPattern(this.tableName, true);
        scala.collection.immutable.Seq matchingDbs = catalog.listDatabases(schemaPattern);
        if (this.isAuthV2Enabled()) {
            List privObjs = HivePrivilegeObjectUtils.getHivePrivDbObjects((List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)matchingDbs).asJava());
            this.authorizeMetaGets(HiveOperationType.GET_TABLES, privObjs, cmdStr);
        }
        HiveThriftServer2$.MODULE$.eventManager().onStatementStart(this.statementId(), this.parentSession.getSessionHandle().getSessionId().toString(), logMsg, this.statementId(), this.parentSession.getUsername());
        try {
            matchingDbs.foreach((Function1 & Serializable)dbName -> {
                SparkGetTablesOperation.$anonfun$runInternal$2(this, catalog, tablePattern, dbName);
                return BoxedUnit.UNIT;
            });
            if (this.tableTypes == null || this.tableTypes.isEmpty() || this.tableTypes.contains(CatalogTableType$.MODULE$.VIEW().name())) {
                String globalTempViewDb = catalog.globalTempDatabase();
                Pattern databasePattern = Pattern.compile(CLIServiceUtils.patternToRegex(this.schemaName));
                scala.collection.immutable.Seq tempViews = databasePattern.matcher(globalTempViewDb).matches() ? catalog.listTables(globalTempViewDb, tablePattern, true) : catalog.listLocalTempViews(tablePattern);
                tempViews.foreach((Function1 & Serializable)view -> {
                    this.addToRowSet((String)view.database().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), view.table(), CatalogTableType$.MODULE$.VIEW().name(), (Option<String>)None$.MODULE$);
                    return BoxedUnit.UNIT;
                });
            }
            object = this.setState(OperationState.FINISHED);
        }
        catch (Throwable x$1) {
            PartialFunction<Throwable, BoxedUnit> catchExpr$1 = this.onError();
            if (catchExpr$1.isDefinedAt((Object)x$1)) {
                object = catchExpr$1.apply((Object)x$1);
            }
            throw x$1;
        }
        HiveThriftServer2$.MODULE$.eventManager().onStatementFinish(this.statementId());
    }

    private void addToRowSet(String dbName, String tableName, String tableType, Option<String> comment) {
        Object[] rowData = new Object[]{"", dbName, tableName, tableType, comment.getOrElse((Function0 & Serializable)() -> "")};
        this.rowSet.addRow((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(rowData), Array$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null, null, null, null, null}), ClassTag$.MODULE$.Null()), ClassTag$.MODULE$.AnyRef()));
    }

    public static final /* synthetic */ void $anonfun$runInternal$3(SparkGetTablesOperation $this, CatalogTable table) {
        String tableType = $this.tableTypeString(table.tableType());
        if ($this.tableTypes == null || $this.tableTypes.isEmpty() || $this.tableTypes.contains(tableType)) {
            $this.addToRowSet(table.database(), table.identifier().table(), tableType, (Option<String>)table.comment());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$runInternal$2(SparkGetTablesOperation $this, SessionCatalog catalog$1, String tablePattern$1, String dbName) {
        scala.collection.immutable.Seq tables = catalog$1.listTables(dbName, tablePattern$1, false);
        catalog$1.getTablesByName(tables).foreach((Function1 & Serializable)table -> {
            SparkGetTablesOperation.$anonfun$runInternal$3($this, table);
            return BoxedUnit.UNIT;
        });
    }

    public SparkGetTablesOperation(SparkSession session, HiveSession parentSession, String catalogName, String schemaName, String tableName, List<String> tableTypes) {
        this.session = session;
        this.parentSession = parentSession;
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.tableTypes = tableTypes;
        super(parentSession, catalogName, schemaName, tableName, tableTypes);
        Logging.$init$((Logging)this);
        SparkOperation.$init$(this);
    }
}

