/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.cli.CliDriver;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.common.HiveInterruptUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.processors.AddResourceProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.processors.DeleteResourceProcessor;
import org.apache.hadoop.hive.ql.processors.ListResourceProcessor;
import org.apache.hadoop.hive.ql.processors.ResetProcessor;
import org.apache.hadoop.hive.ql.processors.SetProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;
import org.apache.spark.ErrorMessageFormat$;
import org.apache.spark.SparkThrowable;
import org.apache.spark.SparkThrowableHelper$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLDriver;
import org.apache.spark.sql.hive.thriftserver.SparkSQLDriver$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLEnv$;
import org.apache.spark.util.SparkExitCode$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import sun.misc.Signal;
import sun.misc.SignalHandler;

@ScalaSignature(bytes="\u0006\u0005\u0005-xAB\u0014)\u0011\u0003QCG\u0002\u00047Q!\u0005!f\u000e\u0005\u0006\t\u0006!\tA\u0012\u0005\b\u000f\u0006\u0011\r\u0011\"\u0003I\u0011\u0019\t\u0016\u0001)A\u0005\u0013\"9!+\u0001b\u0001\n\u0013\u0019\u0006B\u00020\u0002A\u0003%A\u000bC\u0005`\u0003\u0001\u0007\t\u0019!C\u0005A\"I\u0001.\u0001a\u0001\u0002\u0004%I!\u001b\u0005\n_\u0006\u0001\r\u0011!Q!\n\u0005Dq\u0001]\u0001C\u0002\u00135\u0011\u000f\u0003\u0004v\u0003\u0001\u0006iA\u001d\u0005\bm\u0006\u0001\r\u0011\"\u0003x\u0011\u001dY\u0018\u00011A\u0005\nqDaA`\u0001!B\u0013A\bBB@\u0002\t\u0003\t\t\u0001C\u0004\u0002\u0004\u0005!\t!!\u0002\t\u000f\u0005-\u0011\u0001\"\u0001\u0002\u000e!9\u0011\u0011D\u0001\u0005\u0002\u0005m\u0001bBA\u001d\u0003\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003w\tA\u0011BA\u001f\u0011\u001d\t\t&\u0001C\u0005\u0003'2aA\u000e\u0015\u0001U\u0005-\u0004B\u0002#\u0017\t\u0003\t\u0019\bC\u0005\u0002xY\u0011\r\u0011\"\u0003\u0002z!A\u00111\u0010\f!\u0002\u0013\t9\u0003C\u0005\u0002~Y\u0011\r\u0011\"\u0003\u0002\u0000!A\u0011Q\u0012\f!\u0002\u0013\t\t\tC\u0005\u0002bY\u0011\r\u0011\"\u0003\u0002\u0010\"A\u0011q\u0014\f!\u0002\u0013\t\t\nC\u0005\u0002\u001aY\u0011\r\u0011\"\u0003\u0002\"\"A\u00111\u0015\f!\u0002\u0013\ti\u0002C\u0005\u0002&Z\u0011\r\u0011\"\u0003\u0002(\"A\u00111\u0017\f!\u0002\u0013\tI\u000bC\u0004\u00026Z!\t%a.\t\u000f\u0005%g\u0003\"\u0001\u0002\u0002!9\u00111\u001a\f\u0005B\u00055\u0007bBAj-\u0011\u0005\u0013Q\u001b\u0005\t\u0003?4B\u0011\u0001\u0016\u0002b\u0006\t2\u000b]1sWN\u000bFj\u0011'J\tJLg/\u001a:\u000b\u0005%R\u0013\u0001\u0004;ie&4Go]3sm\u0016\u0014(BA\u0016-\u0003\u0011A\u0017N^3\u000b\u00055r\u0013aA:rY*\u0011q\u0006M\u0001\u0006gB\f'o\u001b\u0006\u0003cI\na!\u00199bG\",'\"A\u001a\u0002\u0007=\u0014x\r\u0005\u00026\u00035\t\u0001FA\tTa\u0006\u00148nU)M\u00072KEI]5wKJ\u001c2!\u0001\u001d?!\tID(D\u0001;\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f;\u0005\u0019\te.\u001f*fMB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011IL\u0001\tS:$XM\u001d8bY&\u00111\t\u0011\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\u001b\u0002\rA\u0014x.\u001c9u+\u0005I\u0005C\u0001&P\u001b\u0005Y%B\u0001'N\u0003\u0011a\u0017M\\4\u000b\u00039\u000bAA[1wC&\u0011\u0001k\u0013\u0002\u0007'R\u0014\u0018N\\4\u0002\u000fA\u0014x.\u001c9uA\u0005y1m\u001c8uS:,X\r\u001a)s_6\u0004H/F\u0001U!\t)FL\u0004\u0002W5B\u0011qKO\u0007\u00021*\u0011\u0011,R\u0001\u0007yI|w\u000e\u001e \n\u0005mS\u0014A\u0002)sK\u0012,g-\u0003\u0002Q;*\u00111LO\u0001\u0011G>tG/\u001b8vK\u0012\u0004&o\\7qi\u0002\n\u0011\u0002\u001e:b]N\u0004xN\u001d;\u0016\u0003\u0005\u0004\"A\u00194\u000e\u0003\rT!a\u00183\u000b\u0005\u0015\u0004\u0014A\u0002;ie&4G/\u0003\u0002hG\n9AkU8dW\u0016$\u0018!\u0004;sC:\u001c\bo\u001c:u?\u0012*\u0017\u000f\u0006\u0002k[B\u0011\u0011h[\u0005\u0003Yj\u0012A!\u00168ji\"9a\u000eCA\u0001\u0002\u0004\t\u0017a\u0001=%c\u0005QAO]1ogB|'\u000f\u001e\u0011\u00021M\u0003\u0016IU&`\u0011\u0006#uj\u0014)`!J{\u0005k\u0018)S\u000b\u001aK\u0005,F\u0001s\u001f\u0005\u0019\u0018%\u0001;\u0002\u001bM\u0004\u0018M]6/Q\u0006$wn\u001c9/\u0003e\u0019\u0006+\u0011*L?\"\u000bEiT(Q?B\u0013v\nU0Q%\u00163\u0015\n\u0017\u0011\u0002\u0011\u0015D\u0018\u000e^\"pI\u0016,\u0012\u0001\u001f\t\u0003seL!A\u001f\u001e\u0003\u0007%sG/\u0001\u0007fq&$8i\u001c3f?\u0012*\u0017\u000f\u0006\u0002k{\"9a.DA\u0001\u0002\u0004A\u0018!C3ySR\u001cu\u000eZ3!\u0003QIgn\u001d;bY2\u001c\u0016n\u001a8bY\"\u000bg\u000e\u001a7feR\t!.\u0001\u0003fq&$Hc\u00016\u0002\b!1\u0011\u0011\u0002\tA\u0002a\fAaY8eK\u0006!Q.Y5o)\rQ\u0017q\u0002\u0005\b\u0003#\t\u0002\u0019AA\n\u0003\u0011\t'oZ:\u0011\te\n)\u0002V\u0005\u0004\u0003/Q$!B!se\u0006L\u0018\u0001D5t%\u0016lw\u000e^3N_\u0012,G\u0003BA\u000f\u0003G\u00012!OA\u0010\u0013\r\t\tC\u000f\u0002\b\u0005>|G.Z1o\u0011\u001d\t)C\u0005a\u0001\u0003O\tQa\u001d;bi\u0016\u0004B!!\u000b\u000265\u0011\u00111\u0006\u0006\u0005\u0003[\ty#A\u0002dY&T1aKA\u0019\u0015\r\t\u0019\u0004M\u0001\u0007Q\u0006$wn\u001c9\n\t\u0005]\u00121\u0006\u0002\u0010\u00072L7+Z:tS>t7\u000b^1uK\u0006Q\u0001O]5oiV\u001b\u0018mZ3\u0002=\rdwn]3ISZ,7+Z:tS>t7\u000b^1uK&37\u000b^1si\u0016$Gc\u00016\u0002@!9\u0011Q\u0005\u000bA\u0002\u0005\u0005\u0003\u0003BA\"\u0003\u001bj!!!\u0012\u000b\t\u0005\u001d\u0013\u0011J\u0001\bg\u0016\u001c8/[8o\u0015\u0011\tY%a\f\u0002\u0005Ed\u0017\u0002BA(\u0003\u000b\u0012AbU3tg&|gn\u0015;bi\u0016\f1cZ3u\u0007>lW.\u00198e\u0007>l\u0007\u000f\\3uKJ$\"!!\u0016\u0011\u000be\n)\"a\u0016\u0011\t\u0005e\u0013qM\u0007\u0003\u00037RA!!\u0018\u0002`\u0005I1m\\7qY\u0016$XM\u001d\u0006\u0005\u0003C\n\u0019'A\u0004d_:\u001cx\u000e\\3\u000b\u0005\u0005\u0015\u0014!\u00026mS:,\u0017\u0002BA5\u00037\u0012\u0011bQ8na2,G/\u001a:\u0014\tY\tiG\u0010\t\u0005\u0003S\ty'\u0003\u0003\u0002r\u0005-\"!C\"mS\u0012\u0013\u0018N^3s)\t\t)\b\u0005\u00026-\u0005a1/Z:tS>t7\u000b^1uKV\u0011\u0011qE\u0001\u000eg\u0016\u001c8/[8o'R\fG/\u001a\u0011\u0002\u00071{u)\u0006\u0002\u0002\u0002B!\u00111QAE\u001b\t\t)IC\u0002\u0002\bJ\nQa\u001d7gi)LA!a#\u0002\u0006\n1Aj\\4hKJ\fA\u0001T(HAU\u0011\u0011\u0011\u0013\t\u0005\u0003'\u000bIJ\u0004\u0003\u0002D\u0005U\u0015\u0002BAL\u0003\u000b\nAbU3tg&|gn\u0015;bi\u0016LA!a'\u0002\u001e\nIAj\\4IK2\u0004XM\u001d\u0006\u0005\u0003/\u000b)%\u0001\u0005d_:\u001cx\u000e\\3!+\t\ti\"A\u0007jgJ+Wn\u001c;f\u001b>$W\rI\u0001\u0005G>tg-\u0006\u0002\u0002*B!\u00111VAX\u001b\t\tiK\u0003\u0003\u0002&\u0006E\u0012\u0002BAY\u0003[\u0013QbQ8oM&<WO]1uS>t\u0017!B2p]\u001a\u0004\u0013\u0001E:fi\"Kg/\u001a,be&\f'\r\\3t)\rQ\u0017\u0011\u0018\u0005\b\u0003w\u0013\u0003\u0019AA_\u00035A\u0017N^3WCJL\u0017M\u00197fgB1\u0011qXAc)Rk!!!1\u000b\u0007\u0005\rW*\u0001\u0003vi&d\u0017\u0002BAd\u0003\u0003\u00141!T1q\u0003M\u0001(/\u001b8u\u001b\u0006\u001cH/\u001a:B]\u0012\f\u0005\u000f]%e\u0003)\u0001(o\\2fgN\u001cU\u000e\u001a\u000b\u0004q\u0006=\u0007BBAiI\u0001\u0007A+A\u0002d[\u0012\f1\u0002\u001d:pG\u0016\u001c8\u000fT5oKR)\u00010a6\u0002\\\"1\u0011\u0011\\\u0013A\u0002Q\u000bA\u0001\\5oK\"9\u0011Q\\\u0013A\u0002\u0005u\u0011!E1mY><\u0018J\u001c;feJ,\b\u000f^5oO\u0006q1\u000f\u001d7jiN+W.[\"pY>tG\u0003BAr\u0003S\u0004R!a0\u0002fRKA!a:\u0002B\n!A*[:u\u0011\u0019\tIN\na\u0001)\u0002")
public class SparkSQLCLIDriver
extends CliDriver
implements Logging {
    private final CliSessionState sessionState;
    private final Logger LOG;
    private final SessionState.LogHelper org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console;
    private final boolean isRemoteMode;
    private final Configuration conf;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void printUsage() {
        SparkSQLCLIDriver$.MODULE$.printUsage();
    }

    public static void main(String[] args) {
        SparkSQLCLIDriver$.MODULE$.main(args);
    }

    public static void exit(int code) {
        SparkSQLCLIDriver$.MODULE$.exit(code);
    }

    public static void installSignalHandler() {
        SparkSQLCLIDriver$.MODULE$.installSignalHandler();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private CliSessionState sessionState() {
        return this.sessionState;
    }

    private Logger LOG() {
        return this.LOG;
    }

    public SessionState.LogHelper org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console() {
        return this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console;
    }

    private boolean isRemoteMode() {
        return this.isRemoteMode;
    }

    private Configuration conf() {
        return this.conf;
    }

    public void setHiveVariables(Map<String, String> hiveVariables) {
        ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(hiveVariables).asScala()).foreach((Function1 & Serializable)kv -> {
            SparkSQLCLIDriver.$anonfun$setHiveVariables$1(kv);
            return BoxedUnit.UNIT;
        });
    }

    public void printMasterAndAppId() {
        String master = SparkSQLEnv$.MODULE$.sparkContext().master();
        String appId = SparkSQLEnv$.MODULE$.sparkContext().applicationId();
        SparkSQLEnv$.MODULE$.sparkContext().uiWebUrl().foreach((Function1 & Serializable)webUrl -> {
            SparkSQLCLIDriver.$anonfun$printMasterAndAppId$1(this, webUrl);
            return BoxedUnit.UNIT;
        });
        this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo(new StringBuilder(32).append("Spark master: ").append(master).append(", Application Id: ").append(appId).toString());
    }

    public int processCmd(String cmd) {
        int n;
        String cmd_trimmed = cmd.trim();
        String cmd_lower = cmd_trimmed.toLowerCase(Locale.ROOT);
        String[] tokens = cmd_trimmed.split("\\s+");
        String cmd_1 = cmd_trimmed.substring(tokens[0].length()).trim();
        if (cmd_lower.equals("quit") || cmd_lower.equals("exit")) {
            SparkSQLCLIDriver$.MODULE$.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$closeHiveSessionStateIfStarted((SessionState)this.sessionState());
            SparkSQLCLIDriver$.MODULE$.exit(SparkExitCode$.MODULE$.EXIT_SUCCESS());
        }
        if (tokens[0].toLowerCase(Locale.ROOT).equals("source") || cmd_trimmed.startsWith("!") || this.isRemoteMode()) {
            long startTimeNs = System.nanoTime();
            super.processCmd(cmd);
            long endTimeNs = System.nanoTime();
            double timeTaken = (double)TimeUnit.NANOSECONDS.toMillis(endTimeNs - startTimeNs) / 1000.0;
            this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo(new StringBuilder(20).append("Time taken: ").append(timeTaken).append(" seconds").toString());
            n = 0;
        } else {
            int ret = 0;
            HiveConf hconf = (HiveConf)this.conf();
            CommandProcessor proc = CommandProcessorFactory.get((String[])tokens, (HiveConf)hconf);
            if (proc != null) {
                if (proc instanceof Driver || proc instanceof SetProcessor || proc instanceof AddResourceProcessor || proc instanceof ListResourceProcessor || proc instanceof DeleteResourceProcessor || proc instanceof ResetProcessor) {
                    SparkSQLDriver driver = new SparkSQLDriver(SparkSQLDriver$.MODULE$.$lessinit$greater$default$1());
                    driver.init();
                    PrintStream out = this.sessionState().out;
                    PrintStream err = this.sessionState().err;
                    long startTimeNs = System.nanoTime();
                    if (this.sessionState().getIsVerbose()) {
                        out.println(cmd);
                    }
                    CommandProcessorResponse rc = driver.run(cmd);
                    long endTimeNs = System.nanoTime();
                    double timeTaken = (double)TimeUnit.NANOSECONDS.toMillis(endTimeNs - startTimeNs) / 1000.0;
                    ret = rc.getResponseCode();
                    if (ret != 0) {
                        String string;
                        Enumeration.Value format = SparkSQLEnv$.MODULE$.sqlContext().conf().errorMessageFormat();
                        Throwable e = rc.getException();
                        Throwable throwable = e;
                        if (throwable instanceof SparkThrowable) {
                            Throwable throwable2 = throwable;
                            string = SparkThrowableHelper$.MODULE$.getMessage(throwable2, format);
                        } else {
                            string = e.getMessage();
                        }
                        String msg = string;
                        err.println(msg);
                        Enumeration.Value value = format;
                        Enumeration.Value value2 = ErrorMessageFormat$.MODULE$.PRETTY();
                        if (!(value != null ? !value.equals(value2) : value2 != null)) {
                            if (!(this.sessionState().getIsSilent() || e instanceof AnalysisException && e.getCause() == null)) {
                                e.printStackTrace(err);
                            }
                        }
                        driver.close();
                        return ret;
                    }
                    ArrayList res = new ArrayList();
                    if (HiveConf.getBoolVar((Configuration)this.conf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CLI_PRINT_HEADER) || SparkSQLEnv$.MODULE$.sqlContext().conf().cliPrintHeader()) {
                        Option$.MODULE$.apply((Object)driver.getSchema().getFieldSchemas()).foreach((Function1 & Serializable)fields -> {
                            out.println(((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(fields).asScala()).map((Function1 & Serializable)x$7 -> x$7.getName())).mkString("\t"));
                            return BoxedUnit.UNIT;
                        });
                    }
                    IntRef counter = IntRef.create((int)0);
                    try {
                        while (!out.checkError() && driver.getResults(res)) {
                            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(res).asScala()).foreach((Function1 & Serializable)l -> {
                                SparkSQLCLIDriver.$anonfun$processCmd$3(counter, out, l);
                                return BoxedUnit.UNIT;
                            });
                            res.clear();
                        }
                    }
                    catch (IOException e) {
                        this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printError(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(63).append("Failed with exception ").append(e.getClass().getName()).append(": ").append(e.getMessage()).append("\n                   |").append(StringUtils.stringifyException((Throwable)e)).append("\n                 ").toString())));
                        ret = 1;
                    }
                    int cret = driver.close();
                    if (ret == 0) {
                        ret = cret;
                    }
                    String responseMsg = new StringBuilder(20).append("Time taken: ").append(timeTaken).append(" seconds").toString();
                    if (counter.elem != 0) {
                        responseMsg = new StringBuilder(0).append(responseMsg).append(new StringBuilder(17).append(", Fetched ").append(counter.elem).append(" row(s)").toString()).toString();
                    }
                    this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo(responseMsg, null);
                    driver.destroy();
                } else {
                    if (this.sessionState().getIsVerbose()) {
                        this.sessionState().out.println(new StringBuilder(1).append(tokens[0]).append(" ").append(cmd_1).toString());
                    }
                    ret = proc.run(cmd_1).getResponseCode();
                }
            }
            n = ret;
        }
        return n;
    }

    public int processLine(String line, boolean allowInterrupting) {
        int n;
        Object object = new Object();
        try {
            SignalHandler oldSignal = null;
            Signal interruptSignal = null;
            if (allowInterrupting) {
                interruptSignal = new Signal("INT");
                oldSignal = Signal.handle(interruptSignal, new SignalHandler(this){
                    private boolean interruptRequested;
                    private final /* synthetic */ SparkSQLCLIDriver $outer;

                    private boolean interruptRequested() {
                        return this.interruptRequested;
                    }

                    private void interruptRequested_$eq(boolean x$1) {
                        this.interruptRequested = x$1;
                    }

                    public void handle(Signal signal) {
                        boolean initialRequest = !this.interruptRequested();
                        this.interruptRequested_$eq(true);
                        if (!initialRequest) {
                            this.$outer.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo("Exiting the JVM");
                            SparkSQLCLIDriver$.MODULE$.exit(SparkExitCode$.MODULE$.ERROR_COMMAND_NOT_FOUND());
                        }
                        this.$outer.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo("Interrupting... Be patient, this might take some time.");
                        this.$outer.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo("Press Ctrl+C again to kill JVM");
                        HiveInterruptUtils.interrupt();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.interruptRequested = false;
                    }
                });
            }
            try {
                IntRef lastRet = IntRef.create((int)0);
                Buffer commands = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.splitSemiColon(line)).asScala();
                ObjectRef command = ObjectRef.create((Object)"");
                commands.foreach((Function1 & Serializable)oneCmd -> {
                    SparkSQLCLIDriver.$anonfun$processLine$1(this, command, lastRet, object, oneCmd);
                    return BoxedUnit.UNIT;
                });
                CommandProcessorFactory.clean((HiveConf)((HiveConf)this.conf()));
                n = lastRet.elem;
            }
            catch (Throwable throwable) {
                if (oldSignal != null && interruptSignal != null) {
                    Signal.handle(interruptSignal, oldSignal);
                }
                throw throwable;
            }
            if (oldSignal != null && interruptSignal != null) {
                Signal.handle(interruptSignal, oldSignal);
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                n = ex.value$mcI$sp();
            }
            throw ex;
        }
        return n;
    }

    public List<String> splitSemiColon(String line) {
        BooleanRef insideSingleQuote = BooleanRef.create((boolean)false);
        BooleanRef insideDoubleQuote = BooleanRef.create((boolean)false);
        BooleanRef insideSimpleComment = BooleanRef.create((boolean)false);
        IntRef bracketedCommentLevel = IntRef.create((int)0);
        BooleanRef escape = BooleanRef.create((boolean)false);
        IntRef beginIndex = IntRef.create((int)0);
        BooleanRef leavingBracketedComment = BooleanRef.create((boolean)false);
        BooleanRef isStatement = BooleanRef.create((boolean)false);
        ArrayList<String> ret = new ArrayList<String>();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), line.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
            if (leavingBracketedComment$1.elem) {
                --bracketedCommentLevel$1.elem;
                leavingBracketedComment$1.elem = false;
            }
            if (line.charAt(index) == '\'' && !SparkSQLCLIDriver.insideComment$1(insideSimpleComment, bracketedCommentLevel)) {
                if (!escape$1.elem && !insideDoubleQuote$1.elem) {
                    insideSingleQuote$1.elem = !insideSingleQuote$1.elem;
                }
            } else if (line.charAt(index) == '\"' && !SparkSQLCLIDriver.insideComment$1(insideSimpleComment, bracketedCommentLevel)) {
                if (!escape$1.elem && !insideSingleQuote$1.elem) {
                    insideDoubleQuote$1.elem = !insideDoubleQuote$1.elem;
                }
            } else if (line.charAt(index) == '-') {
                boolean hasNext;
                boolean bl = hasNext = index + 1 < line.length();
                if (!insideDoubleQuote$1.elem && !insideSingleQuote$1.elem && !SparkSQLCLIDriver.insideComment$1(insideSimpleComment, bracketedCommentLevel) && hasNext && line.charAt(index + 1) == '-') {
                    insideSimpleComment$1.elem = true;
                }
            } else if (line.charAt(index) == ';') {
                if (!(insideSingleQuote$1.elem || insideDoubleQuote$1.elem || SparkSQLCLIDriver.insideComment$1(insideSimpleComment, bracketedCommentLevel))) {
                    Object object = isStatement$1.elem ? BoxesRunTime.boxToBoolean((boolean)ret.add(line.substring(beginIndex$1.elem, index))) : BoxedUnit.UNIT;
                    beginIndex$1.elem = index + 1;
                    isStatement$1.elem = false;
                }
            } else if (line.charAt(index) == '\n') {
                if (!escape$1.elem) {
                    insideSimpleComment$1.elem = false;
                }
            } else if (line.charAt(index) == '/' && !insideSimpleComment$1.elem) {
                boolean hasNext;
                boolean bl = hasNext = index + 1 < line.length();
                if (!insideSingleQuote$1.elem && !insideDoubleQuote$1.elem) {
                    if (SparkSQLCLIDriver.insideBracketedComment$1(bracketedCommentLevel) && line.charAt(index - 1) == '*') {
                        leavingBracketedComment$1.elem = true;
                    } else if (hasNext && line.charAt(index + 1) == '*') {
                        ++bracketedCommentLevel$1.elem;
                    }
                }
            }
            if (escape$1.elem) {
                escape$1.elem = false;
            } else if (line.charAt(index) == '\\') {
                escape$1.elem = true;
            }
            isStatement$1.elem = SparkSQLCLIDriver.statementInProgress$1(index, isStatement, beginIndex, line, insideSimpleComment, bracketedCommentLevel);
        });
        boolean endOfBracketedComment = leavingBracketedComment.elem && bracketedCommentLevel.elem == 1;
        Object object = !endOfBracketedComment && (isStatement.elem || SparkSQLCLIDriver.insideBracketedComment$1(bracketedCommentLevel)) ? BoxesRunTime.boxToBoolean((boolean)ret.add(line.substring(beginIndex.elem))) : BoxedUnit.UNIT;
        return ret;
    }

    public static final /* synthetic */ void $anonfun$setHiveVariables$1(Tuple2 kv) {
        SparkSQLEnv$.MODULE$.sqlContext().conf().setConfString((String)kv._1(), (String)kv._2());
    }

    public static final /* synthetic */ void $anonfun$printMasterAndAppId$1(SparkSQLCLIDriver $this, String webUrl) {
        $this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo(new StringBuilder(26).append("Spark Web UI available at ").append(webUrl).toString());
    }

    public static final /* synthetic */ void $anonfun$processCmd$3(IntRef counter$1, PrintStream out$1, String l) {
        ++counter$1.elem;
        out$1.println(l);
    }

    public static final /* synthetic */ void $anonfun$processLine$1(SparkSQLCLIDriver $this, ObjectRef command$1, IntRef lastRet$1, Object nonLocalReturnKey1$1, String oneCmd) {
        if (org.apache.commons.lang3.StringUtils.endsWith((CharSequence)oneCmd, (CharSequence)"\\")) {
            command$1.elem = new StringBuilder(1).append((String)command$1.elem).append(org.apache.commons.lang3.StringUtils.chop((String)oneCmd)).append(";").toString();
        } else {
            command$1.elem = new StringBuilder(0).append((String)command$1.elem).append(oneCmd).toString();
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((String)command$1.elem))) {
                int ret = $this.processCmd((String)command$1.elem);
                command$1.elem = "";
                lastRet$1.elem = ret;
                boolean ignoreErrors = HiveConf.getBoolVar((Configuration)$this.conf(), (HiveConf.ConfVars)HiveConf.ConfVars.CLIIGNOREERRORS);
                if (ret != 0 && !ignoreErrors) {
                    CommandProcessorFactory.clean((HiveConf)((HiveConf)$this.conf()));
                    throw new NonLocalReturnControl.mcI.sp(nonLocalReturnKey1$1, ret);
                }
            }
        }
    }

    private static final boolean insideBracketedComment$1(IntRef bracketedCommentLevel$1) {
        return bracketedCommentLevel$1.elem > 0;
    }

    private static final boolean insideComment$1(BooleanRef insideSimpleComment$1, IntRef bracketedCommentLevel$1) {
        return insideSimpleComment$1.elem || SparkSQLCLIDriver.insideBracketedComment$1(bracketedCommentLevel$1);
    }

    private static final boolean statementInProgress$1(int index, BooleanRef isStatement$1, IntRef beginIndex$1, String line$1, BooleanRef insideSimpleComment$1, IntRef bracketedCommentLevel$1) {
        return isStatement$1.elem || !SparkSQLCLIDriver.insideComment$1(insideSimpleComment$1, bracketedCommentLevel$1) && index > beginIndex$1.elem && !String.valueOf(BoxesRunTime.boxToCharacter((char)line$1.charAt(index))).trim().isEmpty();
    }

    public SparkSQLCLIDriver() {
        Logging.$init$((Logging)this);
        this.sessionState = (CliSessionState)SessionState.get();
        this.LOG = LoggerFactory.getLogger(SparkSQLCLIDriver.class);
        this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console = new SessionState.LogHelper(this.LOG());
        this.isRemoteMode = SparkSQLCLIDriver$.MODULE$.isRemoteMode(this.sessionState());
        Object object = this.conf = this.sessionState() != null ? this.sessionState().getConf() : new Configuration();
        if (!this.isRemoteMode()) {
            SparkSQLEnv$.MODULE$.init();
            if (this.sessionState().getIsSilent()) {
                SparkSQLEnv$.MODULE$.sparkContext().setLogLevel("warn");
            }
        } else {
            throw QueryExecutionErrors$.MODULE$.remoteOperationsUnsupportedError();
        }
    }
}

