/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.internal.io.cloud;

import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.FileAlreadyExistsException;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.execution.streaming.checkpointing.AbstractFileContextBasedCheckpointFileManager;
import org.apache.spark.sql.execution.streaming.checkpointing.CheckpointFileManager;
import scala.Function0;
import scala.StringContext;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rc\u0001\u0002\n\u0014\u0001\u0001B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tu\u0001\u0011\t\u0011)A\u0005w!)\u0011\t\u0001C\u0001\u0005\u001a!q\t\u0001\u0001I\u0011%\tGA!A!\u0002\u0013\u0011W\r\u0003\u0005h\t\t\u0005\t\u0015!\u0003i\u0011!\tDA!A!\u0002\u0013\u0011\u0004\u0002C6\u0005\u0005\u0003\u0005\u000b\u0011\u00027\t\u000b\u0005#A\u0011\u0001:\t\u000fe$\u0001\u0019!C\u0005u\"91\u0010\u0002a\u0001\n\u0013a\bbBA\u0003\t\u0001\u0006K\u0001\u001c\u0005\b\u0003\u001f!A\u0011IA\t\u0011\u001d\t\u0019\u0002\u0002C!\u0003#Aq!!\u0006\u0005\t\u0003\n9\u0002C\u0007\u0002*\u0011\u0001\n1!A\u0001\n\u0013\tY#\u001a\u0005\b\u0003w\u0001A\u0011IA\u001f\u0005%\n%m\u001c:uC\ndWm\u0015;sK\u0006l')Y:fI\u000eCWmY6q_&tGOR5mK6\u000bg.Y4fe*\u0011A#F\u0001\u0006G2|W\u000f\u001a\u0006\u0003-]\t!![8\u000b\u0005aI\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005iY\u0012!B:qCJ\\'B\u0001\u000f\u001e\u0003\u0019\t\u0007/Y2iK*\ta$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001C5\u0002\"AI\u0016\u000e\u0003\rR!\u0001J\u0013\u0002\u001b\rDWmY6q_&tG/\u001b8h\u0015\t1s%A\u0005tiJ,\u0017-\\5oO*\u0011\u0001&K\u0001\nKb,7-\u001e;j_:T!AK\r\u0002\u0007M\fH.\u0003\u0002-G\ti\u0013IY:ue\u0006\u001cGOR5mK\u000e{g\u000e^3yi\n\u000b7/\u001a3DQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3NC:\fw-\u001a:\u0011\u00059zS\"A\f\n\u0005A:\"a\u0002'pO\u001eLgnZ\u0001\u0005a\u0006$\b\u000e\u0005\u00024q5\tAG\u0003\u00026m\u0005\u0011am\u001d\u0006\u0003om\ta\u0001[1e_>\u0004\u0018BA\u001d5\u0005\u0011\u0001\u0016\r\u001e5\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0002=\u007f5\tQH\u0003\u0002?m\u0005!1m\u001c8g\u0013\t\u0001UHA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\r+e\t\u0005\u0002E\u00015\t1\u0003C\u00032\u0007\u0001\u0007!\u0007C\u0003;\u0007\u0001\u00071H\u0001\u0014BE>\u0014H/\u00192mKN#(/Z1n\u0005\u0006\u001cX\r\u001a$T\t\u0006$\u0018mT;uaV$8\u000b\u001e:fC6\u001c\"\u0001B%\u0011\u0005)sfBA&]\u001d\ta5L\u0004\u0002N5:\u0011a*\u0017\b\u0003\u001fbs!\u0001U,\u000f\u0005E3fB\u0001*V\u001b\u0005\u0019&B\u0001+ \u0003\u0019a$o\\8u}%\ta$\u0003\u0002\u001d;%\u0011!dG\u0005\u0003UeI!\u0001K\u0015\n\u0005\u0019:\u0013B\u0001\u0013&\u0013\ti6%A\u000bDQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3NC:\fw-\u001a:\n\u0005}\u0003'!H\"b]\u000e,G\u000e\\1cY\u001645\u000bR1uC>+H\u000f];u'R\u0014X-Y7\u000b\u0005u\u001b\u0013A\u00054t\t\u0006$\u0018mT;uaV$8\u000b\u001e:fC6\u0004\"aM2\n\u0005\u0011$$A\u0005$T\t\u0006$\u0018mT;uaV$8\u000b\u001e:fC6L!A\u001a0\u0002!UtG-\u001a:ms&twm\u0015;sK\u0006l\u0017A\u00014d!\t\u0019\u0014.\u0003\u0002ki\tYa)\u001b7f\u0007>tG/\u001a=u\u0003Myg/\u001a:xe&$X-\u00134Q_N\u001c\u0018N\u00197f!\ti\u0007/D\u0001o\u0015\u0005y\u0017!B:dC2\f\u0017BA9o\u0005\u001d\u0011un\u001c7fC:$Ra];wob\u0004\"\u0001\u001e\u0003\u000e\u0003\u0001AQ!Y\u0005A\u0002\tDQaZ\u0005A\u0002!DQ!M\u0005A\u0002IBQa[\u0005A\u00021\f!\u0002^3s[&t\u0017\r^3e+\u0005a\u0017A\u0004;fe6Lg.\u0019;fI~#S-\u001d\u000b\u0004{\u0006\u0005\u0001CA7\u007f\u0013\tyhN\u0001\u0003V]&$\b\u0002CA\u0002\u0017\u0005\u0005\t\u0019\u00017\u0002\u0007a$\u0013'A\u0006uKJl\u0017N\\1uK\u0012\u0004\u0003f\u0001\u0007\u0002\nA\u0019Q.a\u0003\n\u0007\u00055aN\u0001\u0005w_2\fG/\u001b7f\u0003\u0019\u0019\u0017M\\2fYR\tQ0A\u0003dY>\u001cX-\u0001\u0005u_N#(/\u001b8h)\t\tI\u0002\u0005\u0003\u0002\u001c\u0005\rb\u0002BA\u000f\u0003?\u0001\"A\u00158\n\u0007\u0005\u0005b.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003K\t9C\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003Cq\u0017AF:va\u0016\u0014H%\u001e8eKJd\u00170\u001b8h'R\u0014X-Y7\u0016\u0005\u00055\u0002\u0003BA\u0018\u0003oi!!!\r\u000b\u0007Y\t\u0019D\u0003\u0002\u00026\u0005!!.\u0019<b\u0013\u0011\tI$!\r\u0003\u0019=+H\u000f];u'R\u0014X-Y7\u0002\u0019\r\u0014X-\u0019;f\u0003R|W.[2\u0015\u000b%\u000by$!\u0011\t\u000bE\n\u0002\u0019\u0001\u001a\t\u000b-\f\u0002\u0019\u00017")
public class AbortableStreamBasedCheckpointFileManager
extends AbstractFileContextBasedCheckpointFileManager {
    private final Path path;

    public CheckpointFileManager.CancellableFSDataOutputStream createAtomic(Path path, boolean overwriteIfPossible) {
        EnumSet<CreateFlag> createFlag = overwriteIfPossible ? EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE) : EnumSet.of(CreateFlag.CREATE);
        return new AbortableStreamBasedFSDataOutputStream(this, this.fc().create(path, createFlag, new Options.CreateOpts[0]), this.fc(), path, overwriteIfPossible);
    }

    public AbortableStreamBasedCheckpointFileManager(Path path, Configuration hadoopConf) {
        this.path = path;
        super(path, hadoopConf);
        if (!this.fc().hasPathCapability(path, "fs.capability.outputstream.abortable")) {
            throw new UnsupportedFileSystemException("AbortableStreamBasedCheckpointFileManager requires an fs (path: " + path + ") with abortable stream support");
        }
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Writing atomically to ", " based on abortable stream"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.PATH, $this.path)}))));
    }

    public class AbortableStreamBasedFSDataOutputStream
    extends CheckpointFileManager.CancellableFSDataOutputStream {
        private final FileContext fc;
        private final Path path;
        private final boolean overwriteIfPossible;
        private volatile boolean terminated;
        public final /* synthetic */ AbortableStreamBasedCheckpointFileManager $outer;

        private /* synthetic */ OutputStream super$underlyingStream() {
            return super.underlyingStream();
        }

        private boolean terminated() {
            return this.terminated;
        }

        private void terminated_$eq(boolean x$1) {
            this.terminated = x$1;
        }

        public synchronized void cancel() {
            block7: {
                if (this.terminated()) {
                    return;
                }
                try {
                    try {
                        ((FSDataOutputStream)super.underlyingStream()).abort();
                        ((FSDataOutputStream)super.underlyingStream()).close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable throwable3 = throwable;
                        if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                            this.org$apache$spark$internal$io$cloud$AbortableStreamBasedCheckpointFileManager$AbortableStreamBasedFSDataOutputStream$$$outer().logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.org$apache$spark$internal$io$cloud$AbortableStreamBasedCheckpointFileManager$AbortableStreamBasedFSDataOutputStream$$$outer().LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error cancelling write to ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.org$apache$spark$internal$io$cloud$AbortableStreamBasedCheckpointFileManager$AbortableStreamBasedFSDataOutputStream$$$outer().MDC((LogKey)LogKeys.PATH, $this.path)})).$plus(this.org$apache$spark$internal$io$cloud$AbortableStreamBasedCheckpointFileManager$AbortableStreamBasedFSDataOutputStream$$$outer().LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(stream: ", ")"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.org$apache$spark$internal$io$cloud$AbortableStreamBasedCheckpointFileManager$AbortableStreamBasedFSDataOutputStream$$$outer().MDC((LogKey)LogKeys.FS_DATA_OUTPUT_STREAM, (FSDataOutputStream)this.super$underlyingStream())})))), throwable2);
                            break block7;
                        }
                        throw throwable;
                    }
                }
                finally {
                    this.terminated_$eq(true);
                }
            }
        }

        public synchronized void close() {
            block8: {
                if (this.terminated()) {
                    return;
                }
                try {
                    try {
                        if (!this.overwriteIfPossible && this.fc.util().exists(this.path)) {
                            ((FSDataOutputStream)super.underlyingStream()).abort();
                            throw new FileAlreadyExistsException("Failed to close atomic stream " + this.path + " (stream: " + (FSDataOutputStream)super.underlyingStream() + ") as destination already exists");
                        }
                        ((FSDataOutputStream)super.underlyingStream()).close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable throwable3 = throwable;
                        if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                            this.org$apache$spark$internal$io$cloud$AbortableStreamBasedCheckpointFileManager$AbortableStreamBasedFSDataOutputStream$$$outer().logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.org$apache$spark$internal$io$cloud$AbortableStreamBasedCheckpointFileManager$AbortableStreamBasedFSDataOutputStream$$$outer().LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error closing ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.org$apache$spark$internal$io$cloud$AbortableStreamBasedCheckpointFileManager$AbortableStreamBasedFSDataOutputStream$$$outer().MDC((LogKey)LogKeys.PATH, $this.path)})).$plus(this.org$apache$spark$internal$io$cloud$AbortableStreamBasedCheckpointFileManager$AbortableStreamBasedFSDataOutputStream$$$outer().LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(stream: ", ")"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.org$apache$spark$internal$io$cloud$AbortableStreamBasedCheckpointFileManager$AbortableStreamBasedFSDataOutputStream$$$outer().MDC((LogKey)LogKeys.FS_DATA_OUTPUT_STREAM, (FSDataOutputStream)this.super$underlyingStream())})))), throwable2);
                            break block8;
                        }
                        throw throwable;
                    }
                }
                finally {
                    this.terminated_$eq(true);
                }
            }
        }

        public String toString() {
            return ((FSDataOutputStream)super.underlyingStream()).toString();
        }

        public /* synthetic */ AbortableStreamBasedCheckpointFileManager org$apache$spark$internal$io$cloud$AbortableStreamBasedCheckpointFileManager$AbortableStreamBasedFSDataOutputStream$$$outer() {
            return this.$outer;
        }

        public AbortableStreamBasedFSDataOutputStream(AbortableStreamBasedCheckpointFileManager $outer, FSDataOutputStream fsDataOutputStream, FileContext fc, Path path, boolean overwriteIfPossible) {
            this.fc = fc;
            this.path = path;
            this.overwriteIfPossible = overwriteIfPossible;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super((OutputStream)fsDataOutputStream);
            this.terminated = false;
        }
    }
}

