/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.utils;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.api.python.PythonException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.service.ExecuteEventsManager;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.sql.connect.utils.ErrorUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.jackson.JsonMethods$;
import org.slf4j.Logger;
import org.sparkproject.connect.google_protos.rpc.ErrorInfo;
import org.sparkproject.connect.google_protos.rpc.Status;
import org.sparkproject.connect.grpc.protobuf.StatusProto;
import org.sparkproject.connect.grpc.stub.StreamObserver;
import org.sparkproject.connect.protobuf.Any;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.util.control.NonFatal$;

public final class ErrorUtils$
implements Logging {
    public static final ErrorUtils$ MODULE$ = new ErrorUtils$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Seq<Class<?>> allClasses(Class<?> cl) {
        ArrayBuffer classes = ArrayBuffer$.MODULE$.empty();
        Object object = cl != null && !cl.equals(Object.class) ? classes.append(cl) : BoxedUnit.UNIT;
        this.appendSuperClasses$1(cl, classes);
        return classes.toSeq();
    }

    public Status org$apache$spark$sql$connect$utils$ErrorUtils$$buildStatusFromThrowable(Throwable st, boolean stackTraceEnabled) {
        ErrorInfo.Builder builder;
        LazyRef stackTrace$lzy = new LazyRef();
        JsonAST.JArray x$12 = JsonDSL$.MODULE$.seq2jvalue((Iterable)this.allClasses(st.getClass()).map((Function1 & Serializable)x$1 -> x$1.getName()), (Function1 & Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x));
        Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$12);
        ErrorInfo.Builder errorInfo = ErrorInfo.newBuilder().setReason(st.getClass().getName()).setDomain("org.apache.spark").putMetadata("classes", JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$12, x$2)));
        if (stackTraceEnabled && ErrorUtils$.stackTrace$1(stackTrace$lzy, st).nonEmpty()) {
            int maxSize = BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_JVM_STACK_TRACE_MAX_SIZE()));
            builder = errorInfo.putMetadata("stackTrace", StringUtils.abbreviate((String)((String)ErrorUtils$.stackTrace$1(stackTrace$lzy, st).get()), (int)maxSize));
        } else {
            builder = errorInfo;
        }
        ErrorInfo.Builder withStackTrace = builder;
        return Status.newBuilder().setCode(13).addDetails(Any.pack(withStackTrace.build())).setMessage(SparkConnectService$.MODULE$.extractErrorMessage(st)).build();
    }

    public boolean org$apache$spark$sql$connect$utils$ErrorUtils$$isPythonExecutionException(SparkException se) {
        return se.getCause() != null && se.getCause() instanceof PythonException && ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])se.getCause().getStackTrace()), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ErrorUtils$.$anonfun$isPythonExecutionException$1(x$2)));
    }

    public <V> PartialFunction<Throwable, BoxedUnit> handleError(String opType, StreamObserver<V> observer, String userId, String sessionId, Option<ExecuteEventsManager> events, boolean isInterrupted) {
        SparkSession session = SparkConnectService$.MODULE$.getOrCreateIsolatedSession(userId, sessionId).session();
        boolean stackTraceEnabled = BoxesRunTime.unboxToBoolean((Object)session.conf().get(SQLConf$.MODULE$.PYSPARK_JVM_STACKTRACE_ENABLED()));
        Serializable partial = new Serializable(stackTraceEnabled){
            private static final long serialVersionUID = 0L;
            private final boolean stackTraceEnabled$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                Object object;
                SparkException sparkException;
                A1 A12 = x1;
                if (A12 instanceof SparkException && ErrorUtils$.MODULE$.org$apache$spark$sql$connect$utils$ErrorUtils$$isPythonExecutionException(sparkException = (SparkException)A12)) {
                    object = new Tuple2((Object)sparkException, (Object)StatusProto.toStatusRuntimeException(ErrorUtils$.MODULE$.org$apache$spark$sql$connect$utils$ErrorUtils$$buildStatusFromThrowable(sparkException.getCause(), this.stackTraceEnabled$1)));
                } else if (A12 != null && ((A1 = A12) instanceof SparkThrowable || NonFatal$.MODULE$.apply(A1))) {
                    object = new Tuple2(A1, (Object)StatusProto.toStatusRuntimeException(ErrorUtils$.MODULE$.org$apache$spark$sql$connect$utils$ErrorUtils$$buildStatusFromThrowable(A1, this.stackTraceEnabled$1)));
                } else if (A12 != null) {
                    A1 A13 = A12;
                    object = new Tuple2(A13, (Object)org.sparkproject.connect.grpc.Status.UNKNOWN.withCause(A13).withDescription(StringUtils.abbreviate((String)A13.getMessage(), (int)2048)).asRuntimeException());
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable;
                SparkException sparkException;
                Throwable throwable2 = x1;
                boolean bl = throwable2 instanceof SparkException && ErrorUtils$.MODULE$.org$apache$spark$sql$connect$utils$ErrorUtils$$isPythonExecutionException(sparkException = (SparkException)throwable2) ? true : (throwable2 != null && ((throwable = throwable2) instanceof SparkThrowable || NonFatal$.MODULE$.apply(throwable)) ? true : throwable2 != null);
                return bl;
            }
            {
                this.stackTraceEnabled$1 = stackTraceEnabled$1;
            }
        };
        return partial.andThen((PartialFunction)new Serializable(events, opType, userId, sessionId, isInterrupted, observer){
            private static final long serialVersionUID = 0L;
            private final Option events$1;
            private final String opType$1;
            private final String userId$1;
            private final String sessionId$1;
            private final boolean isInterrupted$1;
            private final StreamObserver observer$1;

            public final <A1 extends Tuple2<Throwable, Throwable>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    Throwable original = (Throwable)A1._1();
                    Throwable wrapped = (Throwable)A1._2();
                    if (this.events$1.isDefined()) {
                        ErrorUtils$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Spark Connect error ").append(new StringBuilder(32).append("during: ").append($this.opType$1).append(". UserId: ").append($this.userId$1).append(". SessionId: ").append($this.sessionId$1).append(".").toString()).toString(), original);
                    } else {
                        ErrorUtils$.MODULE$.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Spark Connect RPC error ").append(new StringBuilder(32).append("during: ").append($this.opType$1).append(". UserId: ").append($this.userId$1).append(". SessionId: ").append($this.sessionId$1).append(".").toString()).toString(), original);
                    }
                    this.events$1.foreach((Function1 & Serializable)executeEventsManager -> {
                        anonfun.handleError.1.$anonfun$applyOrElse$3(this, wrapped, executeEventsManager);
                        return BoxedUnit.UNIT;
                    });
                    this.observer$1.onError(wrapped);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Throwable, Throwable> x2) {
                Tuple2<Throwable, Throwable> tuple2 = x2;
                boolean bl = tuple2 != null;
                return bl;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$3(anonfun.handleError.1 $this, Throwable wrapped$1, ExecuteEventsManager executeEventsManager) {
                if ($this.isInterrupted$1) {
                    executeEventsManager.postCanceled();
                } else {
                    executeEventsManager.postFailed(wrapped$1.getMessage());
                }
            }
            {
                this.events$1 = events$1;
                this.opType$1 = opType$1;
                this.userId$1 = userId$1;
                this.sessionId$1 = sessionId$1;
                this.isInterrupted$1 = isInterrupted$1;
                this.observer$1 = observer$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.connect.utils.ErrorUtils$$anonfun$handleError$1 ), $anonfun$applyOrElse$2(org.apache.spark.sql.connect.utils.ErrorUtils$$anonfun$handleError$1 ), $anonfun$applyOrElse$3$adapted(org.apache.spark.sql.connect.utils.ErrorUtils$$anonfun$handleError$1 java.lang.Throwable org.apache.spark.sql.connect.service.ExecuteEventsManager )}, serializedLambda);
            }
        });
    }

    public <V> Option<ExecuteEventsManager> handleError$default$5() {
        return None$.MODULE$;
    }

    public <V> boolean handleError$default$6() {
        return false;
    }

    private final void appendSuperClasses$1(Class clazz, ArrayBuffer classes$1) {
        while (clazz != null && !clazz.equals(Object.class)) {
            classes$1.append(clazz.getSuperclass());
            clazz = clazz.getSuperclass();
        }
        return;
    }

    private static final /* synthetic */ Option stackTrace$lzycompute$1(LazyRef stackTrace$lzy$1, Throwable st$1) {
        Option option;
        LazyRef lazyRef = stackTrace$lzy$1;
        synchronized (lazyRef) {
            option = stackTrace$lzy$1.initialized() ? (Option)stackTrace$lzy$1.value() : (Option)stackTrace$lzy$1.initialize((Object)Option$.MODULE$.apply((Object)ExceptionUtils.getStackTrace((Throwable)st$1)));
        }
        return option;
    }

    private static final Option stackTrace$1(LazyRef stackTrace$lzy$1, Throwable st$1) {
        return stackTrace$lzy$1.initialized() ? (Option)stackTrace$lzy$1.value() : ErrorUtils$.stackTrace$lzycompute$1(stackTrace$lzy$1, st$1);
    }

    public static final /* synthetic */ boolean $anonfun$isPythonExecutionException$1(StackTraceElement x$2) {
        return x$2.toString().contains("org.apache.spark.sql.execution.python");
    }

    private ErrorUtils$() {
    }
}

