/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkSQLException;
import org.apache.spark.connect.proto.ExecutePlanRequest;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.service.ExecuteHolder;
import org.apache.spark.sql.connect.service.ExecuteInfo;
import org.apache.spark.sql.connect.service.ExecuteKey;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.slf4j.Logger;
import org.sparkproject.connect.guava.cache.Cache;
import org.sparkproject.connect.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001de!\u0002\u000e\u001c\u0001u9\u0003\"\u0002\u001b\u0001\t\u00031\u0004bB\u001d\u0001\u0005\u0004%IA\u000f\u0005\u0007\u0013\u0002\u0001\u000b\u0011B\u001e\t\u000f)\u0003!\u0019!C\u0005\u0017\"1A\u000b\u0001Q\u0001\n1Cq!\u0016\u0001C\u0002\u0013%a\u000b\u0003\u0004g\u0001\u0001\u0006Ia\u0016\u0005\bO\u0002\u0001\r\u0011\"\u0003i\u0011\u001dy\u0007\u00011A\u0005\nADaA\u001e\u0001!B\u0013I\u0007bB<\u0001\u0001\u0004%I\u0001\u001f\u0005\n\u0003\u000b\u0001\u0001\u0019!C\u0005\u0003\u000fAq!a\u0003\u0001A\u0003&\u0011\u0010\u0003\u0005\u0002\u000e\u0001!\t!HA\b\u0011!\t\u0019\u0003\u0001C\u0001;\u0005\u0015\u0002\u0002CA\u0016\u0001\u0011\u0005Q$!\f\t\u0011\u0005M\u0002\u0001\"\u0001\u001e\u0003kAq!a\u000f\u0001\t\u0003\ti\u0004C\u0004\u0002^\u0001!\t!a\u0018\t\u0011\u0005\u0005\u0004\u0001\"\u0001\u001e\u0003GBq!!\u001a\u0001\t\u0013\t\u0019\u0007\u0003\u0005\u0002h\u0001!\t!HA5\u0011!\ty\u0007\u0001C\u0001;\u0005E\u0004\u0002CA<\u0001\u0011\u0005Q$a\u0019\t\u0011\u0005e\u0004\u0001\"\u0001\u001e\u0003w\u0012Ad\u00159be.\u001cuN\u001c8fGR,\u00050Z2vi&|g.T1oC\u001e,'O\u0003\u0002\u001d;\u000591/\u001a:wS\u000e,'B\u0001\u0010 \u0003\u001d\u0019wN\u001c8fGRT!\u0001I\u0011\u0002\u0007M\fHN\u0003\u0002#G\u0005)1\u000f]1sW*\u0011A%J\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\n1a\u001c:h'\r\u0001\u0001F\f\t\u0003S1j\u0011A\u000b\u0006\u0002W\u0005)1oY1mC&\u0011QF\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\n\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005M\u0002$a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tq\u0007\u0005\u00029\u00015\t1$\u0001\u0006fq\u0016\u001cW\u000f^5p]N,\u0012a\u000f\t\u0005y\u0005\u001be)D\u0001>\u0015\tqt(A\u0004nkR\f'\r\\3\u000b\u0005\u0001S\u0013AC2pY2,7\r^5p]&\u0011!)\u0010\u0002\b\u0011\u0006\u001c\b.T1q!\tAD)\u0003\u0002F7\tQQ\t_3dkR,7*Z=\u0011\u0005a:\u0015B\u0001%\u001c\u00055)\u00050Z2vi\u0016Du\u000e\u001c3fe\u0006YQ\r_3dkRLwN\\:!\u00039)\u00070Z2vi&|gn\u001d'pG.,\u0012\u0001\u0014\t\u0003\u001bJk\u0011A\u0014\u0006\u0003\u001fB\u000bA\u0001\\1oO*\t\u0011+\u0001\u0003kCZ\f\u0017BA*O\u0005\u0019y%M[3di\u0006yQ\r_3dkRLwN\\:M_\u000e\\\u0007%A\nbE\u0006tGm\u001c8fIR{WNY:u_:,7/F\u0001X!\u0011A\u0016mQ2\u000e\u0003eS!AW.\u0002\u000b\r\f7\r[3\u000b\u0005qk\u0016AB2p[6|gN\u0003\u0002_?\u00061qm\\8hY\u0016T\u0011\u0001Y\u0001\u0004G>l\u0017B\u00012Z\u0005\u0015\u0019\u0015m\u00195f!\tAD-\u0003\u0002f7\tYQ\t_3dkR,\u0017J\u001c4p\u0003Q\t'-\u00198e_:,G\rV8nEN$xN\\3tA\u0005\tB.Y:u\u000bb,7-\u001e;j_:$\u0016.\\3\u0016\u0003%\u00042!\u000b6m\u0013\tY'F\u0001\u0004PaRLwN\u001c\t\u0003S5L!A\u001c\u0016\u0003\t1{gnZ\u0001\u0016Y\u0006\u001cH/\u0012=fGV$\u0018n\u001c8US6,w\fJ3r)\t\tH\u000f\u0005\u0002*e&\u00111O\u000b\u0002\u0005+:LG\u000fC\u0004v\u0013\u0005\u0005\t\u0019A5\u0002\u0007a$\u0013'\u0001\nmCN$X\t_3dkRLwN\u001c+j[\u0016\u0004\u0013!E:dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peV\t\u0011\u0010E\u0002*Uj\u00042a_A\u0001\u001b\u0005a(BA?\u007f\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u007fB\u000bA!\u001e;jY&\u0019\u00111\u0001?\u00031M\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW-A\u000btG\",G-\u001e7fI\u0016CXmY;u_J|F%Z9\u0015\u0007E\fI\u0001C\u0004v\u0019\u0005\u0005\t\u0019A=\u0002%M\u001c\u0007.\u001a3vY\u0016$W\t_3dkR|'\u000fI\u0001\u0014GJ,\u0017\r^3Fq\u0016\u001cW\u000f^3I_2$WM\u001d\u000b\u0004\r\u0006E\u0001bBA\n\u001d\u0001\u0007\u0011QC\u0001\be\u0016\fX/Z:u!\u0011\t9\"a\b\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\tQ\u0001\u001d:pi>T!AH\u0011\n\t\u0005\u0005\u0012\u0011\u0004\u0002\u0013\u000bb,7-\u001e;f!2\fgNU3rk\u0016\u001cH/A\nsK6|g/Z#yK\u000e,H/\u001a%pY\u0012,'\u000fF\u0002r\u0003OAa!!\u000b\u0010\u0001\u0004\u0019\u0015aA6fs\u0006\u0001r-\u001a;Fq\u0016\u001cW\u000f^3I_2$WM\u001d\u000b\u0005\u0003_\t\t\u0004E\u0002*U\u001aCa!!\u000b\u0011\u0001\u0004\u0019\u0015!F4fi\u0006\u0013\u0017M\u001c3p]\u0016$Gk\\7cgR|g.\u001a\u000b\u0005\u0003o\tI\u0004E\u0002*U\u000eDa!!\u000b\u0012\u0001\u0004\u0019\u0015\u0001\u00067jgR\f5\r^5wK\u0016CXmY;uS>t7/\u0006\u0002\u0002@A9\u0011\u0011IA)Y\u0006]c\u0002BA\"\u0003\u001brA!!\u0012\u0002L5\u0011\u0011q\t\u0006\u0004\u0003\u0013*\u0014A\u0002\u001fs_>$h(C\u0001,\u0013\r\tyEK\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019&!\u0016\u0003\r\u0015KG\u000f[3s\u0015\r\tyE\u000b\t\u0006\u0003\u0003\nIfY\u0005\u0005\u00037\n)FA\u0002TKF\fq\u0003\\5ti\u0006\u0013\u0017M\u001c3p]\u0016$W\t_3dkRLwN\\:\u0016\u0005\u0005]\u0013\u0001C:ikR$wn\u001e8\u0015\u0003E\fac]2iK\u0012,H.\u001a)fe&|G-[2DQ\u0016\u001c7n]\u0001\u0014a\u0016\u0014\u0018n\u001c3jG6\u000b\u0017N\u001c;f]\u0006t7-\u001a\u000b\u0004c\u0006-\u0004BBA7-\u0001\u0007A.A\u0004uS6,w.\u001e;\u0002%M,G/\u00117m%B\u001b5\u000fR3bI2Lg.\u001a\u000b\u0004c\u0006M\u0004BBA;/\u0001\u0007A.\u0001\u0006eK\u0006$G.\u001b8f\u001bN\f\u0001#\u001b8uKJ\u0014X\u000f\u001d;BY2\u0014\u0006kQ:\u0002%1L7\u000f^#yK\u000e,H/\u001a%pY\u0012,'o]\u000b\u0003\u0003{\u0002R!a \u0002\u0006\u001ak!!!!\u000b\u0007\u0005\ru(A\u0005j[6,H/\u00192mK&!\u00111LAA\u0001")
public class SparkConnectExecutionManager
implements Logging {
    private final HashMap<ExecuteKey, ExecuteHolder> executions;
    private final Object executionsLock;
    private final Cache<ExecuteKey, ExecuteInfo> abandonedTombstones;
    private Option<Object> lastExecutionTime;
    private Option<ScheduledExecutorService> scheduledExecutor;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private HashMap<ExecuteKey, ExecuteHolder> executions() {
        return this.executions;
    }

    private Object executionsLock() {
        return this.executionsLock;
    }

    private Cache<ExecuteKey, ExecuteInfo> abandonedTombstones() {
        return this.abandonedTombstones;
    }

    private Option<Object> lastExecutionTime() {
        return this.lastExecutionTime;
    }

    private void lastExecutionTime_$eq(Option<Object> x$1) {
        this.lastExecutionTime = x$1;
    }

    private Option<ScheduledExecutorService> scheduledExecutor() {
        return this.scheduledExecutor;
    }

    private void scheduledExecutor_$eq(Option<ScheduledExecutorService> x$1) {
        this.scheduledExecutor = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public ExecuteHolder createExecuteHolder(ExecutePlanRequest request) {
        void var3_3;
        SessionHolder sessionHolder = SparkConnectService$.MODULE$.getOrCreateIsolatedSession(request.getUserContext().getUserId(), request.getSessionId());
        ExecuteHolder executeHolder = new ExecuteHolder(request, sessionHolder);
        Object object = this.executionsLock();
        synchronized (object) {
            if (this.executions().get((Object)executeHolder.key()).isDefined()) {
                throw new SparkSQLException("INVALID_HANDLE.OPERATION_ALREADY_EXISTS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)executeHolder.operationId())})));
            }
            if (this.getAbandonedTombstone(executeHolder.key()).isDefined()) {
                throw new SparkSQLException("INVALID_HANDLE.OPERATION_ABANDONED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)executeHolder.operationId())})));
            }
            sessionHolder.addExecuteHolder(executeHolder);
            this.executions().put((Object)executeHolder.key(), (Object)executeHolder);
            this.lastExecutionTime_$eq((Option<Object>)None$.MODULE$);
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("ExecuteHolder ").append(executeHolder.key()).append(" is created.").toString());
        }
        this.schedulePeriodicChecks();
        return var3_3;
    }

    public void removeExecuteHolder(ExecuteKey key) {
        None$ executeHolder = None$.MODULE$;
        Object object = this.executionsLock();
        synchronized (object) {
            executeHolder = this.executions().remove((Object)key);
            executeHolder.foreach((Function1 & Serializable)e -> {
                SparkConnectExecutionManager.$anonfun$removeExecuteHolder$1(e);
                return BoxedUnit.UNIT;
            });
            if (this.executions().isEmpty()) {
                this.lastExecutionTime_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
            }
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("ExecuteHolder ").append(key).append(" is removed.").toString());
        }
        executeHolder.foreach((Function1 & Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
    }

    public Option<ExecuteHolder> getExecuteHolder(ExecuteKey key) {
        Option option;
        Object object = this.executionsLock();
        synchronized (object) {
            option = this.executions().get((Object)key);
        }
        return option;
    }

    public Option<ExecuteInfo> getAbandonedTombstone(ExecuteKey key) {
        return Option$.MODULE$.apply((Object)this.abandonedTombstones().getIfPresent(key));
    }

    public Either<Object, Seq<ExecuteInfo>> listActiveExecutions() {
        Left left;
        Object object = this.executionsLock();
        synchronized (object) {
            left = this.executions().isEmpty() ? package$.MODULE$.Left().apply(this.lastExecutionTime().get()) : package$.MODULE$.Right().apply((Object)((IterableOnceOps)this.executions().values().map((Function1 & Serializable)x$2 -> x$2.getExecuteInfo())).toBuffer().toSeq());
        }
        return left;
    }

    public Seq<ExecuteInfo> listAbandonedExecutions() {
        return ((MapOps)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.abandonedTombstones().asMap()).asScala()).values().toBuffer().toSeq();
    }

    public void shutdown() {
        Object object = this.executionsLock();
        synchronized (object) {
            this.scheduledExecutor().foreach((Function1 & Serializable)executor -> BoxesRunTime.boxToBoolean((boolean)SparkConnectExecutionManager.$anonfun$shutdown$1(executor)));
            this.scheduledExecutor_$eq((Option<ScheduledExecutorService>)None$.MODULE$);
            this.executions().clear();
            this.abandonedTombstones().invalidateAll();
            if (!this.lastExecutionTime().isDefined()) {
                this.lastExecutionTime_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
            }
        }
    }

    private void schedulePeriodicChecks() {
        Object object = this.executionsLock();
        synchronized (object) {
            Object object2;
            long interval = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXECUTE_MANAGER_MAINTENANCE_INTERVAL()));
            long timeout = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXECUTE_MANAGER_DETACHED_TIMEOUT()));
            Option<ScheduledExecutorService> option = this.scheduledExecutor();
            if (option instanceof Some) {
                object2 = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Starting thread for cleanup of abandoned executions every ").append(interval).append(" ms").toString());
                this.scheduledExecutor_$eq((Option<ScheduledExecutorService>)new Some((Object)Executors.newSingleThreadScheduledExecutor()));
                object2 = ((ScheduledExecutorService)this.scheduledExecutor().get()).scheduleAtFixedRate(() -> {
                    try {
                        this.periodicMaintenance(timeout);
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable ex = (Throwable)option.get();
                            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Unexpected exception in periodic task", ex);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        throw throwable;
                    }
                }, interval, interval, TimeUnit.MILLISECONDS);
            } else {
                throw new MatchError(option);
            }
        }
    }

    public void periodicMaintenance(long timeout) {
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Started periodic run of SparkConnectExecutionManager maintenance.");
        ArrayBuffer toRemove = new ArrayBuffer();
        Object object = this.executionsLock();
        synchronized (object) {
            long nowMs = System.currentTimeMillis();
            this.executions().values().foreach((Function1 & Serializable)executeHolder -> {
                Some some;
                long detached;
                Option<Object> option = executeHolder.lastAttachedRpcTime();
                Object object = option instanceof Some ? ((detached = BoxesRunTime.unboxToLong((Object)(some = (Some)option).value())) + timeout <= nowMs ? toRemove.$plus$eq(executeHolder) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
                return object;
            });
        }
        if (!toRemove.isEmpty()) {
            toRemove.foreach((Function1 & Serializable)executeHolder -> {
                SparkConnectExecutionManager.$anonfun$periodicMaintenance$3(this, executeHolder);
                return BoxedUnit.UNIT;
            });
        }
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Finished periodic run of SparkConnectExecutionManager maintenance.");
    }

    public void setAllRPCsDeadline(long deadlineMs) {
        Object object = this.executionsLock();
        synchronized (object) {
            this.executions().values().foreach((Function1 & Serializable)x$3 -> {
                x$3.setGrpcResponseSendersDeadline(deadlineMs);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void interruptAllRPCs() {
        Object object = this.executionsLock();
        synchronized (object) {
            this.executions().values().foreach((Function1 & Serializable)x$4 -> {
                x$4.interruptGrpcResponseSenders();
                return BoxedUnit.UNIT;
            });
        }
    }

    public Seq<ExecuteHolder> listExecuteHolders() {
        Seq seq;
        Object object = this.executionsLock();
        synchronized (object) {
            seq = this.executions().values().toBuffer().toSeq();
        }
        return seq;
    }

    public static final /* synthetic */ void $anonfun$removeExecuteHolder$1(ExecuteHolder e) {
        e.sessionHolder().removeExecuteHolder(e.operationId());
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$1(ScheduledExecutorService executor) {
        executor.shutdown();
        return executor.awaitTermination(1L, TimeUnit.MINUTES);
    }

    public static final /* synthetic */ void $anonfun$periodicMaintenance$3(SparkConnectExecutionManager $this, ExecuteHolder executeHolder) {
        ExecuteInfo info = executeHolder.getExecuteInfo();
        $this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("Found execution ").append(info).append(" that was abandoned and expired and will be removed.").toString());
        $this.removeExecuteHolder(executeHolder.key());
        $this.abandonedTombstones().put(executeHolder.key(), info);
    }

    public SparkConnectExecutionManager() {
        Logging.$init$((Logging)this);
        this.executions = new HashMap();
        this.executionsLock = new Object();
        this.abandonedTombstones = CacheBuilder.newBuilder().maximumSize(BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXECUTE_MANAGER_ABANDONED_TOMBSTONES_SIZE()))).build();
        this.lastExecutionTime = new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis()));
        this.scheduledExecutor = None$.MODULE$;
    }
}

