/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.grpc.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import org.sparkproject.connect.grpc.ChannelCredentials;
import org.sparkproject.connect.grpc.Internal;
import org.sparkproject.connect.grpc.ManagedChannelProvider;
import org.sparkproject.connect.grpc.netty.NettyChannelBuilder;
import org.sparkproject.connect.grpc.netty.ProtocolNegotiators;

@Internal
public final class NettyChannelProvider
extends ManagedChannelProvider {
    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int priority() {
        return 5;
    }

    public NettyChannelBuilder builderForAddress(String name, int port) {
        return NettyChannelBuilder.forAddress(name, port);
    }

    public NettyChannelBuilder builderForTarget(String target) {
        return NettyChannelBuilder.forTarget(target);
    }

    @Override
    public ManagedChannelProvider.NewChannelBuilderResult newChannelBuilder(String target, ChannelCredentials creds) {
        ProtocolNegotiators.FromChannelCredentialsResult result = ProtocolNegotiators.from(creds);
        if (result.error != null) {
            return ManagedChannelProvider.NewChannelBuilderResult.error(result.error);
        }
        return ManagedChannelProvider.NewChannelBuilderResult.channelBuilder(new NettyChannelBuilder(target, creds, result.callCredentials, result.negotiator));
    }

    @Override
    protected Collection<Class<? extends SocketAddress>> getSupportedSocketAddressTypes() {
        return Collections.singleton(InetSocketAddress.class);
    }
}

