/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.grpc.internal;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.sparkproject.connect.grpc.InternalServiceProviders;
import org.sparkproject.connect.grpc.NameResolver;
import org.sparkproject.connect.grpc.NameResolverProvider;
import org.sparkproject.connect.grpc.internal.BackoffPolicyRetryScheduler;
import org.sparkproject.connect.grpc.internal.DnsNameResolver;
import org.sparkproject.connect.grpc.internal.ExponentialBackoffPolicy;
import org.sparkproject.connect.grpc.internal.GrpcUtil;
import org.sparkproject.connect.grpc.internal.RetryingNameResolver;
import org.sparkproject.connect.guava.base.Preconditions;
import org.sparkproject.connect.guava.base.Stopwatch;

public final class DnsNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "dns";

    @Override
    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (SCHEME.equals(targetUri.getScheme())) {
            String targetPath = Preconditions.checkNotNull(targetUri.getPath(), "targetPath");
            Preconditions.checkArgument(targetPath.startsWith("/"), "the path component (%s) of the target (%s) must start with '/'", (Object)targetPath, (Object)targetUri);
            String name = targetPath.substring(1);
            return new RetryingNameResolver(new DnsNameResolver(targetUri.getAuthority(), name, args, GrpcUtil.SHARED_CHANNEL_EXECUTOR, Stopwatch.createUnstarted(), InternalServiceProviders.isAndroid(this.getClass().getClassLoader())), new BackoffPolicyRetryScheduler(new ExponentialBackoffPolicy.Provider(), args.getScheduledExecutorService(), args.getSynchronizationContext()), args.getSynchronizationContext());
        }
        return null;
    }

    @Override
    public String getDefaultScheme() {
        return SCHEME;
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    public int priority() {
        return 5;
    }

    @Override
    protected Collection<Class<? extends SocketAddress>> getProducedSocketAddressTypes() {
        return Collections.singleton(InetSocketAddress.class);
    }
}

