/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.artifact;

import java.io.Serializable;
import java.nio.file.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connect.artifact.util.ArtifactUtils$;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.runtime.BoxedUnit;

public final class SparkConnectArtifactManager$
implements Logging {
    public static final SparkConnectArtifactManager$ MODULE$ = new SparkConnectArtifactManager$();
    private static Path artifactRootPath;
    private static final String forwardToFSPrefix;
    private static String currentArtifactRootUri;
    private static SparkContext lastKnownSparkContextInstance;
    private static final String ARTIFACT_DIRECTORY_PREFIX;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
        forwardToFSPrefix = "forward_to_fs";
        ARTIFACT_DIRECTORY_PREFIX = "artifacts";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String forwardToFSPrefix() {
        return forwardToFSPrefix;
    }

    private String currentArtifactRootUri() {
        return currentArtifactRootUri;
    }

    private void currentArtifactRootUri_$eq(String x$1) {
        currentArtifactRootUri = x$1;
    }

    private SparkContext lastKnownSparkContextInstance() {
        return lastKnownSparkContextInstance;
    }

    private void lastKnownSparkContextInstance_$eq(SparkContext x$1) {
        lastKnownSparkContextInstance = x$1;
    }

    private String ARTIFACT_DIRECTORY_PREFIX() {
        return ARTIFACT_DIRECTORY_PREFIX;
    }

    private Path artifactRootPath$lzycompute() {
        SparkConnectArtifactManager$ sparkConnectArtifactManager$ = this;
        synchronized (sparkConnectArtifactManager$) {
            if (!bitmap$0) {
                artifactRootPath = Utils$.MODULE$.createTempDir(this.ARTIFACT_DIRECTORY_PREFIX(), Utils$.MODULE$.createTempDir$default$2()).toPath();
                bitmap$0 = true;
            }
        }
        return artifactRootPath;
    }

    public Path artifactRootPath() {
        return !bitmap$0 ? this.artifactRootPath$lzycompute() : artifactRootPath;
    }

    public Tuple2<Path, String> getArtifactDirectoryAndUriForSession(SparkSession session) {
        return new Tuple2((Object)ArtifactUtils$.MODULE$.concatenatePaths(this.artifactRootPath(), session.sessionUUID()), (Object)new StringBuilder(1).append(this.artifactRootURI()).append("/").append(session.sessionUUID()).toString());
    }

    public Tuple2<Path, String> getArtifactDirectoryAndUriForSession(SessionHolder sessionHolder) {
        return this.getArtifactDirectoryAndUriForSession(sessionHolder.session());
    }

    public Tuple2<Path, String> getClassfileDirectoryAndUriForSession(SparkSession session) {
        Tuple2<Path, String> tuple2 = this.getArtifactDirectoryAndUriForSession(session);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Path artDir = (Path)tuple2._1();
        String artUri = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)artDir, (Object)artUri);
        Tuple2 tuple23 = tuple22;
        Path artDir2 = (Path)tuple23._1();
        String artUri2 = (String)tuple23._2();
        return new Tuple2((Object)ArtifactUtils$.MODULE$.concatenatePaths(artDir2, "classes"), (Object)new StringBuilder(9).append(artUri2).append("/classes/").toString());
    }

    public Tuple2<Path, String> getClassfileDirectoryAndUriForSession(SessionHolder sessionHolder) {
        return this.getClassfileDirectoryAndUriForSession(sessionHolder.session());
    }

    private synchronized void refreshArtifactUri(SparkContext sc) {
        if (sc == this.lastKnownSparkContextInstance()) {
            return;
        }
        String oldArtifactUri = this.currentArtifactRootUri();
        this.currentArtifactRootUri_$eq(SparkEnv$.MODULE$.get().rpcEnv().fileServer().addDirectoryIfAbsent(this.ARTIFACT_DIRECTORY_PREFIX(), this.artifactRootPath().toFile()));
        this.lastKnownSparkContextInstance_$eq(sc);
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Artifact URI updated from ").append(oldArtifactUri).append(" to ").append(MODULE$.currentArtifactRootUri()).toString());
    }

    private void updateUriIfRequired() {
        SparkContext$.MODULE$.getActive().foreach((Function1 & Serializable)sc -> {
            SparkConnectArtifactManager$.$anonfun$updateUriIfRequired$1(sc);
            return BoxedUnit.UNIT;
        });
    }

    public String artifactRootURI() {
        this.updateUriIfRequired();
        Predef$.MODULE$.require(this.currentArtifactRootUri() != null);
        return this.currentArtifactRootUri();
    }

    public static final /* synthetic */ void $anonfun$updateUriIfRequired$1(SparkContext sc) {
        block0: {
            if (MODULE$.lastKnownSparkContextInstance() != null && sc == MODULE$.lastKnownSparkContextInstance()) break block0;
            MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "Refreshing artifact URI due to SparkContext (re)initialisation!");
            MODULE$.refreshArtifactUri(sc);
        }
    }

    private SparkConnectArtifactManager$() {
    }
}

