/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client;

import com.google.protobuf.ByteString;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkException;
import org.apache.spark.connect.proto.AddArtifactsRequest;
import org.apache.spark.connect.proto.AddArtifactsResponse;
import org.apache.spark.connect.proto.ArtifactStatusesRequest;
import org.apache.spark.connect.proto.ArtifactStatusesResponse;
import org.apache.spark.sql.Artifact;
import org.apache.spark.sql.Artifact$;
import org.apache.spark.sql.connect.client.ClassFinder;
import org.apache.spark.sql.connect.client.CustomSparkConnectBlockingStub;
import org.apache.spark.sql.connect.client.CustomSparkConnectStub;
import org.apache.spark.sql.connect.client.SparkConnectClient;
import org.apache.spark.sql.connect.client.SparkConnectStubState;
import org.apache.spark.util.SparkFileUtils$;
import org.apache.spark.util.SparkThreadUtils$;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Builder;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001\u0002\u000e\u001c\u0001!B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u001d\u0019\u0006A1A\u0005\nQCa\u0001\u0017\u0001!\u0002\u0013)\u0006BB-\u0001A\u0003%!\f\u0003\u0004h\u0001\u0001\u0006I\u0001\u001b\u0005\u0006W\u0002!\t\u0001\u001c\u0005\u0006e\u0002!\ta\u001d\u0005\u0006m\u0002!Ia\u001e\u0005\u0007e\u0002!\t!a\u0007\t\rI\u0004A\u0011AA\u0010\u0011\u0019\u0011\b\u0001\"\u0001\u00026!9\u0011Q\b\u0001\u0005\u0002\u0005}\u0002\u0002CA$\u0001\u0011\u00051$!\u0013\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X!A\u0011Q\f\u0001\u0005\u0002m\ty\u0006\u0003\u0005\u0002b\u0001!\taHA2\u0011!\ti\u0004\u0001C\u00017\u0005e\u0004\u0002CAC\u0001\u0011\u00051$a\"\t\u000f\u0005-\u0005\u0001\"\u0003\u0002\u000e\"9\u0011Q\u0017\u0001\u0005\n\u0005]\u0006bBAn\u0001\u0011%\u0011Q\u001c\u0002\u0010\u0003J$\u0018NZ1di6\u000bg.Y4fe*\u0011A$H\u0001\u0007G2LWM\u001c;\u000b\u0005yy\u0012aB2p]:,7\r\u001e\u0006\u0003A\u0005\n1a]9m\u0015\t\u00113%A\u0003ta\u0006\u00148N\u0003\u0002%K\u00051\u0011\r]1dQ\u0016T\u0011AJ\u0001\u0004_J<7\u0001A\n\u0003\u0001%\u0002\"AK\u0017\u000e\u0003-R\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]-\u0012a!\u00118z%\u00164\u0017\u0001D2mS\u0016tGoQ8oM&<\u0007CA\u00196\u001d\t\u00114'D\u0001\u001c\u0013\t!4$\u0001\nTa\u0006\u00148nQ8o]\u0016\u001cGo\u00117jK:$\u0018B\u0001\u001c8\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]*\u0011AgG\u0001\ng\u0016\u001c8/[8o\u0013\u0012\u0004\"AO!\u000f\u0005mz\u0004C\u0001\u001f,\u001b\u0005i$B\u0001 (\u0003\u0019a$o\\8u}%\u0011\u0001iK\u0001\u0007!J,G-\u001a4\n\u0005\t\u001b%AB*ue&twM\u0003\u0002AW\u0005)!m\u001d;vEB\u0011!GR\u0005\u0003\u000fn\u0011adQ;ti>l7\u000b]1sW\u000e{gN\\3di\ncwnY6j]\u001e\u001cF/\u001e2\u0002\tM$XO\u0019\t\u0003e)K!aS\u000e\u0003-\r+8\u000f^8n'B\f'o[\"p]:,7\r^*uk\n\fa\u0001P5oSRtD#\u0002(P!F\u0013\u0006C\u0001\u001a\u0001\u0011\u0015yS\u00011\u00011\u0011\u0015AT\u00011\u0001:\u0011\u0015!U\u00011\u0001F\u0011\u0015AU\u00011\u0001J\u0003)\u0019\u0005*\u0016(L?NK%,R\u000b\u0002+B\u0011!FV\u0005\u0003/.\u00121!\u00138u\u0003-\u0019\u0005*\u0016(L?NK%,\u0012\u0011\u0002\u0019\rd\u0017m]:GS:$WM]:\u0011\u0007m\u0013G-D\u0001]\u0015\tif,\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u00181\u0002\tU$\u0018\u000e\u001c\u0006\u0002C\u0006!!.\u0019<b\u0013\t\u0019GL\u0001\u000bD_BLxJ\\,sSR,\u0017I\u001d:bs2K7\u000f\u001e\t\u0003e\u0015L!AZ\u000e\u0003\u0017\rc\u0017m]:GS:$WM]\u0001\ngR,(m\u0015;bi\u0016\u0004\"AM5\n\u0005)\\\"!F*qCJ\\7i\u001c8oK\u000e$8\u000b^;c'R\fG/Z\u0001\u0014e\u0016<\u0017n\u001d;fe\u000ec\u0017m]:GS:$WM\u001d\u000b\u0003[B\u0004\"A\u000b8\n\u0005=\\#\u0001B+oSRDQ!\u001d\u0006A\u0002\u0011\faAZ5oI\u0016\u0014\u0018aC1eI\u0006\u0013H/\u001b4bGR$\"!\u001c;\t\u000bU\\\u0001\u0019A\u001d\u0002\tA\fG\u000f[\u0001\u000fa\u0006\u00148/Z!si&4\u0017m\u0019;t)\rA\u00181\u0002\t\u0005sz\f\u0019A\u0004\u0002{y:\u0011Ah_\u0005\u0002Y%\u0011QpK\u0001\ba\u0006\u001c7.Y4f\u0013\ry\u0018\u0011\u0001\u0002\u0004'\u0016\f(BA?,!\u0011\t)!a\u0002\u000e\u0003}I1!!\u0003 \u0005!\t%\u000f^5gC\u000e$\bbBA\u0007\u0019\u0001\u0007\u0011qB\u0001\u0004kJL\u0007\u0003BA\t\u0003/i!!a\u0005\u000b\u0007\u0005U\u0001-A\u0002oKRLA!!\u0007\u0002\u0014\t\u0019QKU%\u0015\u00075\fi\u0002C\u0004\u0002\u000e5\u0001\r!a\u0004\u0015\u000b5\f\t#!\r\t\u000f\u0005\rb\u00021\u0001\u0002&\u0005)!-\u001f;fgB)!&a\n\u0002,%\u0019\u0011\u0011F\u0016\u0003\u000b\u0005\u0013(/Y=\u0011\u0007)\ni#C\u0002\u00020-\u0012AAQ=uK\"1\u00111\u0007\bA\u0002e\na\u0001^1sO\u0016$H#B7\u00028\u0005m\u0002BBA\u001d\u001f\u0001\u0007\u0011(\u0001\u0004t_V\u00148-\u001a\u0005\u0007\u0003gy\u0001\u0019A\u001d\u0002\u0019\u0005$G-\u0011:uS\u001a\f7\r^:\u0015\u00075\f\t\u0005C\u0004\u0002DA\u0001\r!!\u0012\u0002\tU\u0014\u0018n\u001d\t\u0005sz\fy!\u0001\tjg\u000e\u000b7\r[3e\u0003J$\u0018NZ1diR!\u00111JA)!\rQ\u0013QJ\u0005\u0004\u0003\u001fZ#a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003'\n\u0002\u0019A\u001d\u0002\t!\f7\u000f[\u0001\u000eG\u0006\u001c\u0007.Z!si&4\u0017m\u0019;\u0015\u0007e\nI\u0006C\u0004\u0002\\I\u0001\r!!\n\u0002\t\tdwNY\u0001\u001ckBdw.\u00193BY2\u001cE.Y:t\r&dW-\u0011:uS\u001a\f7\r^:\u0015\u00035\f1\"\u00193e\u00072\f7o\u001d#jeR\u0019Q.!\u001a\t\u000f\u0005\u001dD\u00031\u0001\u0002j\u0005!!-Y:f!\u0011\tY'!\u001e\u000e\u0005\u00055$\u0002BA8\u0003c\nAAZ5mK*\u0019\u00111\u000f1\u0002\u00079Lw.\u0003\u0003\u0002x\u00055$\u0001\u0002)bi\"$2!\\A>\u0011\u001d\ti(\u0006a\u0001\u0003\u007f\n\u0011\"\u0019:uS\u001a\f7\r^:\u0011\u000be\f\t)a\u0001\n\t\u0005\r\u0015\u0011\u0001\u0002\t\u0013R,'/\u00192mK\u0006\u0001\u0012\r\u001a3BeRLg-Y2ug&k\u0007\u000f\u001c\u000b\u0004[\u0006%\u0005bBA?-\u0001\u0007\u0011qP\u0001\u0014C\u0012$')\u0019;dQ\u0016$\u0017I\u001d;jM\u0006\u001cGo\u001d\u000b\u0006[\u0006=\u0015\u0011\u0013\u0005\u0007\u0003{:\u0002\u0019\u0001=\t\u000f\u0005Mu\u00031\u0001\u0002\u0016\u000611\u000f\u001e:fC6\u0004b!a&\u0002$\u0006\u001dVBAAM\u0015\rA\u00151\u0014\u0006\u0005\u0003;\u000by*\u0001\u0003heB\u001c'BAAQ\u0003\tIw.\u0003\u0003\u0002&\u0006e%AD*ue\u0016\fWn\u00142tKJ4XM\u001d\t\u0005\u0003S\u000b\t,\u0004\u0002\u0002,*!\u0011QVAX\u0003\u0015\u0001(o\u001c;p\u0015\tq\u0012%\u0003\u0003\u00024\u0006-&aE!eI\u0006\u0013H/\u001b4bGR\u001c(+Z9vKN$\u0018!\u0004:fC\u0012tU\r\u001f;DQVt7\u000e\u0006\u0003\u0002:\u00065\u0007\u0003BA^\u0003\u0013l!!!0\u000b\t\u0005}\u0016\u0011Y\u0001\taJ|Go\u001c2vM*!\u00111YAc\u0003\u00199wn\\4mK*\u0011\u0011qY\u0001\u0004G>l\u0017\u0002BAf\u0003{\u0013!BQ=uKN#(/\u001b8h\u0011\u001d\ty\r\u0007a\u0001\u0003#\f!!\u001b8\u0011\t\u0005M\u0017q[\u0007\u0003\u0003+T1!!)a\u0013\u0011\tI.!6\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\\\u0001\u0013C\u0012$7\t[;oW\u0016$\u0017I\u001d;jM\u0006\u001cG\u000fF\u0003n\u0003?\f\u0019\u000fC\u0004\u0002bf\u0001\r!a\u0001\u0002\u0011\u0005\u0014H/\u001b4bGRDq!a%\u001a\u0001\u0004\t)\n")
public class ArtifactManager {
    private final SparkConnectClient.Configuration clientConfig;
    public final String org$apache$spark$sql$connect$client$ArtifactManager$$sessionId;
    private final CustomSparkConnectBlockingStub bstub;
    private final CustomSparkConnectStub stub;
    private final int CHUNK_SIZE;
    private final CopyOnWriteArrayList<ClassFinder> classFinders;
    private final SparkConnectStubState stubState;

    private int CHUNK_SIZE() {
        return this.CHUNK_SIZE;
    }

    public void registerClassFinder(ClassFinder finder) {
        this.classFinders.add(finder);
    }

    public void addArtifact(String path) {
        this.addArtifact(SparkFileUtils$.MODULE$.resolveURI(path));
    }

    private Seq<Artifact> parseArtifacts(URI uri) {
        String string = uri.getScheme();
        switch (string == null ? 0 : string.hashCode()) {
            case 104684: {
                if (!"ivy".equals(string)) break;
                return Artifact$.MODULE$.newIvyArtifacts(uri);
            }
            case 3143036: {
                if (!"file".equals(string)) break;
                Path path = Paths.get(uri);
                Artifact artifact = Artifact$.MODULE$.newArtifactFromExtension(((Object)path.getFileName()).toString(), path.getFileName(), (Artifact.LocalData)new Artifact.LocalFile(path));
                return new .colon.colon((Object)artifact, (List)Nil$.MODULE$);
            }
        }
        throw new UnsupportedOperationException("Unsupported scheme: " + string);
    }

    public void addArtifact(URI uri) {
        this.addArtifacts((Iterable<Artifact>)this.parseArtifacts(uri));
    }

    public void addArtifact(byte[] bytes, String target) {
        Artifact artifact;
        Path targetPath = Paths.get(target, new String[0]);
        Artifact artifact2 = artifact = Artifact$.MODULE$.newArtifactFromExtension(((Object)targetPath.getFileName()).toString(), targetPath, (Artifact.LocalData)new Artifact.InMemory(bytes));
        this.addArtifacts((Iterable<Artifact>)Nil$.MODULE$.$colon$colon((Object)artifact2));
    }

    public void addArtifact(String source, String target) {
        Artifact artifact;
        Path targetPath = Paths.get(target, new String[0]);
        Artifact artifact2 = artifact = Artifact$.MODULE$.newArtifactFromExtension(((Object)targetPath.getFileName()).toString(), targetPath, (Artifact.LocalData)new Artifact.LocalFile(Paths.get(source, new String[0])));
        this.addArtifacts((Iterable<Artifact>)Nil$.MODULE$.$colon$colon((Object)artifact2));
    }

    public void addArtifacts(Seq<URI> uris) {
        this.addArtifacts((Iterable<Artifact>)((Iterable)uris.flatMap((Function1 & Serializable)uri -> this.parseArtifacts((URI)uri))));
    }

    public boolean isCachedArtifact(String hash) {
        Map<String, ArtifactStatusesResponse.ArtifactStatus> statuses;
        String artifactName = Artifact$.MODULE$.CACHE_PREFIX() + "/" + hash;
        ArtifactStatusesRequest request = ArtifactStatusesRequest.newBuilder().setUserContext(this.clientConfig.userContext()).setClientType(this.clientConfig.userAgent()).setSessionId(this.org$apache$spark$sql$connect$client$ArtifactManager$$sessionId).addAllNames(Arrays.asList((Object[])new String[]{artifactName})).build();
        ArtifactStatusesResponse response = this.bstub.artifactStatus(request);
        if (StringUtils.isNotEmpty((CharSequence)response.getSessionId())) {
            String string = response.getSessionId();
            String string2 = this.org$apache$spark$sql$connect$client$ArtifactManager$$sessionId;
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new IllegalStateException("Session ID mismatch: " + this.org$apache$spark$sql$connect$client$ArtifactManager$$sessionId + " != " + response.getSessionId());
            }
        }
        if ((statuses = response.getStatusesMap()).containsKey(artifactName)) {
            return statuses.get(artifactName).getExists();
        }
        return false;
    }

    public String cacheArtifact(byte[] blob) {
        String hash;
        block0: {
            hash = DigestUtils.sha256Hex((byte[])blob);
            if (this.isCachedArtifact(hash)) break block0;
            Artifact artifact = Artifact$.MODULE$.newCacheArtifact(hash, (Artifact.LocalData)new Artifact.InMemory(blob));
            this.addArtifacts((Iterable<Artifact>)Nil$.MODULE$.$colon$colon((Object)artifact));
        }
        return hash;
    }

    public void uploadAllClassFileArtifacts() {
        this.addArtifacts((Iterable<Artifact>)((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(this.classFinders).asScala().flatMap((Function1 & Serializable)x$1 -> x$1.findClasses())));
    }

    public void addClassDir(Path base) {
        if (!Files.isDirectory(base, new LinkOption[0])) {
            return;
        }
        Builder builder = package$.MODULE$.Seq().newBuilder();
        try (Stream<Path> stream = Files.walk(base, new FileVisitOption[0]);){
            stream.forEach(path -> {
                if (Files.isRegularFile(path, new LinkOption[0]) && ((Object)path).toString().endsWith(".class")) {
                    builder.$plus$eq((Object)Artifact$.MODULE$.newClassArtifact(base.relativize((Path)path), (Artifact.LocalData)new Artifact.LocalFile(path)));
                    return;
                }
            });
        }
        this.addArtifacts((Iterable<Artifact>)((Iterable)builder.result()));
    }

    public void addArtifacts(Iterable<Artifact> artifacts) {
        if (artifacts.isEmpty()) {
            return;
        }
        try {
            this.stubState.retryHandler().retry((JFunction0.mcV.sp & Serializable)() -> this.addArtifactsImpl(artifacts));
        }
        catch (StatusRuntimeException ex) {
            throw new SparkException(ex.toString(), ex.getCause());
        }
    }

    public void addArtifactsImpl(Iterable<Artifact> artifacts) {
        Promise promise = Promise$.MODULE$.apply();
        StreamObserver<AddArtifactsResponse> responseHandler = new StreamObserver<AddArtifactsResponse>(this, promise){
            private final Buffer<AddArtifactsResponse.ArtifactSummary> summaries;
            private final /* synthetic */ ArtifactManager $outer;
            private final Promise promise$1;

            private Buffer<AddArtifactsResponse.ArtifactSummary> summaries() {
                return this.summaries;
            }

            public void onNext(AddArtifactsResponse v) {
                if (StringUtils.isNotEmpty((CharSequence)v.getSessionId())) {
                    String string = v.getSessionId();
                    String string2 = this.$outer.org$apache$spark$sql$connect$client$ArtifactManager$$sessionId;
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        throw new IllegalStateException("Session ID mismatch: " + this.$outer.org$apache$spark$sql$connect$client$ArtifactManager$$sessionId + " != " + v.getSessionId());
                    }
                }
                v.getArtifactsList().forEach(summary -> this.summaries().$plus$eq(summary));
            }

            public void onError(Throwable throwable) {
                this.promise$1.failure(throwable);
            }

            public void onCompleted() {
                this.promise$1.success((Object)this.summaries().toSeq());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.promise$1 = promise$1;
                this.summaries = (Buffer)Buffer$.MODULE$.empty();
            }
        };
        StreamObserver<AddArtifactsRequest> stream = this.stub.addArtifacts(responseHandler);
        Buffer currentBatch = (Buffer)Buffer$.MODULE$.empty();
        LongRef currentBatchSize = LongRef.create((long)0L);
        artifacts.iterator().foreach((Function1 & Serializable)artifact -> {
            ArtifactManager.$anonfun$addArtifactsImpl$1(this, currentBatch, stream, currentBatchSize, artifact);
            return BoxedUnit.UNIT;
        });
        if (currentBatch.nonEmpty()) {
            this.writeBatch$1(currentBatch, stream, currentBatchSize);
        }
        stream.onCompleted();
        SparkThreadUtils$.MODULE$.awaitResultNoSparkExceptionConversion((Awaitable)promise.future(), (Duration)Duration$.MODULE$.Inf());
    }

    private void addBatchedArtifacts(Seq<Artifact> artifacts, StreamObserver<AddArtifactsRequest> stream) {
        AddArtifactsRequest.Builder builder = AddArtifactsRequest.newBuilder().setUserContext(this.clientConfig.userContext()).setClientType(this.clientConfig.userAgent()).setSessionId(this.org$apache$spark$sql$connect$client$ArtifactManager$$sessionId);
        artifacts.foreach((Function1 & Serializable)artifact -> {
            AddArtifactsRequest.SingleChunkArtifact singleChunkArtifact;
            try (CheckedInputStream in = new CheckedInputStream(artifact.storage().stream(), new CRC32());){
                try {
                    AddArtifactsRequest.ArtifactChunk.Builder data = AddArtifactsRequest.ArtifactChunk.newBuilder().setData(ByteString.readFrom((InputStream)in)).setCrc(in.getChecksum().getValue());
                    singleChunkArtifact = builder.getBatchBuilder().addArtifactsBuilder().setName(((Object)artifact.path()).toString()).setData(data).build();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        stream.onError(throwable2);
                        throw throwable2;
                    }
                    throw throwable;
                }
            }
            return singleChunkArtifact;
        });
        stream.onNext((Object)builder.build());
    }

    private ByteString readNextChunk(InputStream in) {
        byte[] buf = new byte[this.CHUNK_SIZE()];
        int bytesRead = 0;
        int count = 0;
        while (count != -1 && bytesRead < this.CHUNK_SIZE()) {
            count = in.read(buf, bytesRead, this.CHUNK_SIZE() - bytesRead);
            if (count == -1) continue;
            bytesRead += count;
        }
        if (bytesRead == 0) {
            return ByteString.empty();
        }
        return ByteString.copyFrom((byte[])buf, (int)0, (int)bytesRead);
    }

    private void addChunkedArtifact(Artifact artifact, StreamObserver<AddArtifactsRequest> stream) {
        AddArtifactsRequest.Builder builder = AddArtifactsRequest.newBuilder().setUserContext(this.clientConfig.userContext()).setClientType(this.clientConfig.userAgent()).setSessionId(this.org$apache$spark$sql$connect$client$ArtifactManager$$sessionId);
        try (CheckedInputStream in = new CheckedInputStream(artifact.storage().stream(), new CRC32());){
            try {
                AddArtifactsRequest.ArtifactChunk.Builder artifactChunkBuilder = AddArtifactsRequest.ArtifactChunk.newBuilder();
                ByteString dataChunk = this.readNextChunk(in);
                builder.getBeginChunkBuilder().setName(((Object)artifact.path()).toString()).setTotalBytes(artifact.size()).setNumChunks(this.getNumChunks$1(artifact.size())).setInitialChunk(artifactChunkBuilder.setData(dataChunk).setCrc(in.getChecksum().getValue()));
                stream.onNext((Object)builder.build());
                in.getChecksum().reset();
                builder.clearBeginChunk();
                dataChunk = this.readNextChunk(in);
                while (!dataChunk.isEmpty()) {
                    artifactChunkBuilder.setData(dataChunk).setCrc(in.getChecksum().getValue());
                    builder.setChunk(artifactChunkBuilder.build());
                    stream.onNext((Object)builder.build());
                    in.getChecksum().reset();
                    builder.clearChunk();
                    dataChunk = this.readNextChunk(in);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    stream.onError(throwable2);
                    throw throwable2;
                }
                throw throwable;
            }
        }
    }

    private static final void addToBatch$1(Artifact dep, long size, Buffer currentBatch$1, LongRef currentBatchSize$1) {
        currentBatch$1.$plus$eq((Object)dep);
        currentBatchSize$1.elem += size;
    }

    private final void writeBatch$1(Buffer currentBatch$1, StreamObserver stream$1, LongRef currentBatchSize$1) {
        this.addBatchedArtifacts((Seq<Artifact>)currentBatch$1.toSeq(), (StreamObserver<AddArtifactsRequest>)stream$1);
        currentBatch$1.clear();
        currentBatchSize$1.elem = 0L;
    }

    public static final /* synthetic */ void $anonfun$addArtifactsImpl$1(ArtifactManager $this, Buffer currentBatch$1, StreamObserver stream$1, LongRef currentBatchSize$1, Artifact artifact) {
        Artifact.LocalData data = artifact.storage();
        long size = data.size();
        if (size > (long)$this.CHUNK_SIZE()) {
            if (currentBatch$1.nonEmpty()) {
                $this.writeBatch$1(currentBatch$1, stream$1, currentBatchSize$1);
            }
            $this.addChunkedArtifact(artifact, (StreamObserver<AddArtifactsRequest>)stream$1);
            return;
        }
        if (currentBatchSize$1.elem + size > (long)$this.CHUNK_SIZE()) {
            $this.writeBatch$1(currentBatch$1, stream$1, currentBatchSize$1);
        }
        ArtifactManager.addToBatch$1(artifact, size, currentBatch$1, currentBatchSize$1);
    }

    private final long getNumChunks$1(long size) {
        return (size + (long)(this.CHUNK_SIZE() - 1)) / (long)this.CHUNK_SIZE();
    }

    public ArtifactManager(SparkConnectClient.Configuration clientConfig, String sessionId, CustomSparkConnectBlockingStub bstub, CustomSparkConnectStub stub) {
        this.clientConfig = clientConfig;
        this.org$apache$spark$sql$connect$client$ArtifactManager$$sessionId = sessionId;
        this.bstub = bstub;
        this.stub = stub;
        this.CHUNK_SIZE = 32768;
        this.classFinders = new CopyOnWriteArrayList();
        this.stubState = stub.stubState();
    }
}

