/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.common;

import java.io.Serializable;
import org.apache.spark.connect.proto.DataType;
import org.apache.spark.sql.catalyst.util.CollationFactory;
import org.apache.spark.sql.connect.common.InvalidPlanInput;
import org.apache.spark.sql.connect.common.InvalidPlanInput$;
import org.apache.spark.sql.connect.common.ProtoDataTypes$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.PythonUserDefinedType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.SparkClassUtils$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.ArraySeq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;

public final class DataTypeProtoConverter$ {
    public static final DataTypeProtoConverter$ MODULE$ = new DataTypeProtoConverter$();

    public DataType toCatalystType(org.apache.spark.connect.proto.DataType t) {
        DataType.KindCase kindCase = t.getKindCase();
        if (((Object)((Object)DataType.KindCase.NULL)).equals((Object)kindCase)) {
            return NullType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.BINARY)).equals((Object)kindCase)) {
            return BinaryType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.BOOLEAN)).equals((Object)kindCase)) {
            return BooleanType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.BYTE)).equals((Object)kindCase)) {
            return ByteType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.SHORT)).equals((Object)kindCase)) {
            return ShortType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.INTEGER)).equals((Object)kindCase)) {
            return IntegerType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.LONG)).equals((Object)kindCase)) {
            return LongType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.FLOAT)).equals((Object)kindCase)) {
            return FloatType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.DOUBLE)).equals((Object)kindCase)) {
            return DoubleType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.DECIMAL)).equals((Object)kindCase)) {
            return this.toCatalystDecimalType(t.getDecimal());
        }
        if (((Object)((Object)DataType.KindCase.STRING)).equals((Object)kindCase)) {
            return this.toCatalystStringType(t.getString());
        }
        if (((Object)((Object)DataType.KindCase.CHAR)).equals((Object)kindCase)) {
            return new CharType(t.getChar().getLength());
        }
        if (((Object)((Object)DataType.KindCase.VAR_CHAR)).equals((Object)kindCase)) {
            return new VarcharType(t.getVarChar().getLength());
        }
        if (((Object)((Object)DataType.KindCase.DATE)).equals((Object)kindCase)) {
            return DateType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.TIMESTAMP)).equals((Object)kindCase)) {
            return TimestampType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.TIMESTAMP_NTZ)).equals((Object)kindCase)) {
            return TimestampNTZType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.CALENDAR_INTERVAL)).equals((Object)kindCase)) {
            return CalendarIntervalType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.YEAR_MONTH_INTERVAL)).equals((Object)kindCase)) {
            return this.toCatalystYearMonthIntervalType(t.getYearMonthInterval());
        }
        if (((Object)((Object)DataType.KindCase.DAY_TIME_INTERVAL)).equals((Object)kindCase)) {
            return this.toCatalystDayTimeIntervalType(t.getDayTimeInterval());
        }
        if (((Object)((Object)DataType.KindCase.ARRAY)).equals((Object)kindCase)) {
            return this.toCatalystArrayType(t.getArray());
        }
        if (((Object)((Object)DataType.KindCase.STRUCT)).equals((Object)kindCase)) {
            return this.toCatalystStructType(t.getStruct());
        }
        if (((Object)((Object)DataType.KindCase.MAP)).equals((Object)kindCase)) {
            return this.toCatalystMapType(t.getMap());
        }
        if (((Object)((Object)DataType.KindCase.VARIANT)).equals((Object)kindCase)) {
            return VariantType$.MODULE$;
        }
        if (((Object)((Object)DataType.KindCase.UDT)).equals((Object)kindCase)) {
            return this.toCatalystUDT(t.getUdt());
        }
        throw new InvalidPlanInput("Does not support convert " + t.getKindCase() + " to catalyst types.", InvalidPlanInput$.MODULE$.apply$default$2());
    }

    private DecimalType toCatalystDecimalType(DataType.Decimal t) {
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(t.hasPrecision(), t.hasScale());
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && bl2) {
                return new DecimalType(t.getPrecision(), t.getScale());
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl && !bl3) {
                return new DecimalType(t.getPrecision());
            }
        }
        return new DecimalType();
    }

    private StringType toCatalystStringType(DataType.String t) {
        return StringType$.MODULE$.apply(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(t.getCollation())) ? t.getCollation() : "UTF8_BINARY");
    }

    private YearMonthIntervalType toCatalystYearMonthIntervalType(DataType.YearMonthInterval t) {
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(t.hasStartField(), t.hasEndField());
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && bl2) {
                return new YearMonthIntervalType((byte)t.getStartField(), (byte)t.getEndField());
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl && !bl3) {
                return YearMonthIntervalType$.MODULE$.apply((byte)t.getStartField());
            }
        }
        return YearMonthIntervalType$.MODULE$.apply();
    }

    private DayTimeIntervalType toCatalystDayTimeIntervalType(DataType.DayTimeInterval t) {
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(t.hasStartField(), t.hasEndField());
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && bl2) {
                return new DayTimeIntervalType((byte)t.getStartField(), (byte)t.getEndField());
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl && !bl3) {
                return DayTimeIntervalType$.MODULE$.apply((byte)t.getStartField());
            }
        }
        return DayTimeIntervalType$.MODULE$.apply();
    }

    private ArrayType toCatalystArrayType(DataType.Array t) {
        return new ArrayType(this.toCatalystType(t.getElementType()), t.getContainsNull());
    }

    private StructType toCatalystStructType(DataType.Struct t) {
        scala.collection.immutable.Seq fields = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.ListHasAsScala(t.getFieldsList()).asScala().toSeq().map((Function1 & Serializable)protoField -> {
            Metadata metadata = protoField.hasMetadata() ? Metadata$.MODULE$.fromJson(protoField.getMetadata()) : Metadata$.MODULE$.empty();
            return new StructField(protoField.getName(), MODULE$.toCatalystType(protoField.getDataType()), protoField.getNullable(), metadata);
        });
        return StructType$.MODULE$.apply(fields);
    }

    private MapType toCatalystMapType(DataType.Map t) {
        return new MapType(this.toCatalystType(t.getKeyType()), this.toCatalystType(t.getValueType()), t.getValueContainsNull());
    }

    private UserDefinedType<?> toCatalystUDT(DataType.UDT t) {
        String string = t.getType();
        String string2 = "udt";
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new InvalidPlanInput("UserDefinedType requires the 'type' field to be 'udt', but got '" + t.getType() + "'.", InvalidPlanInput$.MODULE$.apply$default$2());
        }
        if (t.hasJvmClass()) {
            return (UserDefinedType)SparkClassUtils$.MODULE$.classForName(t.getJvmClass(), SparkClassUtils$.MODULE$.classForName$default$2(), SparkClassUtils$.MODULE$.classForName$default$3()).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        if (!(t.hasPythonClass() && t.hasSerializedPythonClass() && t.hasSqlType())) {
            throw new InvalidPlanInput("PythonUserDefinedType requires all the three fields: python_class, serialized_python_class and sql_type.", InvalidPlanInput$.MODULE$.apply$default$2());
        }
        return new PythonUserDefinedType(this.toCatalystType(t.getSqlType()), t.getPythonClass(), t.getSerializedPythonClass());
    }

    public org.apache.spark.connect.proto.DataType toConnectProtoType(DataType t) {
        StructType structType;
        StructField[] fields;
        DecimalType decimalType;
        Option option;
        DataType dataType = t;
        if (NullType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.NullType();
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.BooleanType();
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.BinaryType();
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.ByteType();
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.ShortType();
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.IntegerType();
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.LongType();
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.FloatType();
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.DoubleType();
        }
        if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            return org.apache.spark.connect.proto.DataType.newBuilder().setDecimal(DataType.Decimal.newBuilder().setPrecision(precision).setScale(scale).build()).build();
        }
        if (dataType instanceof CharType) {
            CharType charType = (CharType)dataType;
            int length = charType.length();
            return org.apache.spark.connect.proto.DataType.newBuilder().setChar(DataType.Char.newBuilder().setLength(length).build()).build();
        }
        if (dataType instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)dataType;
            int length = varcharType.length();
            return org.apache.spark.connect.proto.DataType.newBuilder().setVarChar(DataType.VarChar.newBuilder().setLength(length).build()).build();
        }
        if (dataType instanceof StringType) {
            StringType stringType = (StringType)dataType;
            return org.apache.spark.connect.proto.DataType.newBuilder().setString(DataType.String.newBuilder().setCollation(CollationFactory.fetchCollation((int)stringType.collationId()).collationName).build()).build();
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.DateType();
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.TimestampType();
        }
        if (TimestampNTZType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.TimestampNTZType();
        }
        if (CalendarIntervalType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.CalendarIntervalType();
        }
        if (dataType instanceof YearMonthIntervalType) {
            YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType;
            byte startField = yearMonthIntervalType.startField();
            byte endField = yearMonthIntervalType.endField();
            return org.apache.spark.connect.proto.DataType.newBuilder().setYearMonthInterval(DataType.YearMonthInterval.newBuilder().setStartField(startField).setEndField(endField).build()).build();
        }
        if (dataType instanceof DayTimeIntervalType) {
            DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType;
            byte startField = dayTimeIntervalType.startField();
            byte endField = dayTimeIntervalType.endField();
            return org.apache.spark.connect.proto.DataType.newBuilder().setDayTimeInterval(DataType.DayTimeInterval.newBuilder().setStartField(startField).setEndField(endField).build()).build();
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            if (elementType != null) {
                DataType dataType2 = elementType;
                if (true) {
                    boolean bl = containsNull;
                    return org.apache.spark.connect.proto.DataType.newBuilder().setArray(DataType.Array.newBuilder().setElementType(this.toConnectProtoType(dataType2)).setContainsNull(bl).build()).build();
                }
            }
        }
        if (dataType instanceof StructType && (fields = (structType = (StructType)dataType).fields()) != null) {
            StructField[] structFieldArray = fields;
            ArraySeq protoFields = ArrayImplicits$.MODULE$.SparkArrayOps((Object)structFieldArray).toImmutableArraySeq().map((Function1 & Serializable)x0$1 -> {
                StructField structField = x0$1;
                if (structField != null) {
                    String name = structField.name();
                    DataType dataType = structField.dataType();
                    boolean nullable = structField.nullable();
                    Metadata metadata = structField.metadata();
                    if (name != null) {
                        String string = name;
                        if (dataType != null) {
                            DataType dataType2 = dataType;
                            if (true) {
                                boolean bl = nullable;
                                if (metadata != null) {
                                    Metadata metadata2 = metadata;
                                    if (metadata2.equals((Object)Metadata$.MODULE$.empty())) {
                                        return DataType.StructField.newBuilder().setName(string).setDataType(MODULE$.toConnectProtoType(dataType2)).setNullable(bl).build();
                                    }
                                    return DataType.StructField.newBuilder().setName(string).setDataType(MODULE$.toConnectProtoType(dataType2)).setNullable(bl).setMetadata(metadata2.json()).build();
                                }
                            }
                        }
                    }
                }
                throw new MatchError((Object)structField);
            });
            return org.apache.spark.connect.proto.DataType.newBuilder().setStruct(DataType.Struct.newBuilder().addAllFields(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)protoFields).asJava()).build()).build();
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            if (keyType != null) {
                DataType dataType3 = keyType;
                if (valueType != null) {
                    DataType dataType4 = valueType;
                    if (true) {
                        boolean bl = valueContainsNull;
                        return org.apache.spark.connect.proto.DataType.newBuilder().setMap(DataType.Map.newBuilder().setKeyType(this.toConnectProtoType(dataType3)).setValueType(this.toConnectProtoType(dataType4)).setValueContainsNull(bl).build()).build();
                    }
                }
            }
        }
        if (VariantType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.VariantType();
        }
        if (dataType instanceof PythonUserDefinedType) {
            PythonUserDefinedType pythonUserDefinedType = (PythonUserDefinedType)dataType;
            return org.apache.spark.connect.proto.DataType.newBuilder().setUdt(DataType.UDT.newBuilder().setType("udt").setPythonClass(pythonUserDefinedType.pyUDT()).setSqlType(this.toConnectProtoType(pythonUserDefinedType.sqlType())).setSerializedPythonClass(pythonUserDefinedType.serializedPyClass()).build()).build();
        }
        if (dataType instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            String string = userDefinedType.getClass().getName();
            switch (string == null ? 0 : string.hashCode()) {
                case -442626967: {
                    if (!"org.apache.spark.ml.linalg.MatrixUDT".equals(string)) break;
                    return ProtoDataTypes$.MODULE$.MatrixUDT();
                }
                case 1006386087: {
                    if (!"org.apache.spark.ml.linalg.VectorUDT".equals(string)) break;
                    return ProtoDataTypes$.MODULE$.VectorUDT();
                }
            }
            DataType.UDT.Builder builder = DataType.UDT.newBuilder();
            builder.setType("udt").setJvmClass(string).setSqlType(this.toConnectProtoType(userDefinedType.sqlType()));
            Object object = userDefinedType.pyUDT() != null ? builder.setPythonClass(userDefinedType.pyUDT()) : BoxedUnit.UNIT;
            return org.apache.spark.connect.proto.DataType.newBuilder().setUdt(builder.build()).build();
        }
        throw new InvalidPlanInput("Does not support convert " + t.typeName() + " to connect proto types.", InvalidPlanInput$.MODULE$.apply$default$2());
    }

    private DataTypeProtoConverter$() {
    }
}

