/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.io.Serializable;
import java.util.Arrays;

public final class Geography
implements Serializable {
    protected final byte[] value;
    protected final int srid;
    public static final int DEFAULT_SRID = 4326;

    private Geography(byte[] value, int srid) {
        this.value = value;
        this.srid = srid;
    }

    public byte[] getBytes() {
        return this.value;
    }

    public int getSrid() {
        return this.srid;
    }

    public static Geography fromWKB(byte[] bytes, int srid) {
        return new Geography(bytes, srid);
    }

    public static Geography fromWKB(byte[] bytes) {
        return new Geography(bytes, 4326);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Geography other = (Geography)obj;
        return this.srid == other.srid && Arrays.equals(this.value, other.value);
    }

    public int hashCode() {
        return 31 * Arrays.hashCode(this.value) + Integer.hashCode(this.srid);
    }
}

