/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.CatalogSuite$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalog.CatalogMetadata;
import org.apache.spark.sql.catalog.Database;
import org.apache.spark.sql.catalog.Function;
import org.apache.spark.sql.catalog.Table;
import org.apache.spark.sql.test.ConnectFunSuite;
import org.apache.spark.sql.test.RemoteSparkSession;
import org.apache.spark.sql.test.SQLHelper;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Status;
import org.scalatest.compatible.Assertion;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t2AAA\u0002\u0001\u0019!)a\u0004\u0001C\u0001?\ta1)\u0019;bY><7+^5uK*\u0011A!B\u0001\u0004gFd'B\u0001\u0004\b\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0011\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0015\u0005\u0019qN]4\u0004\u0001M!\u0001!D\u000b\u001c!\tq1#D\u0001\u0010\u0015\t\u0001\u0012#\u0001\u0005gk:\u001cX/\u001b;f\u0015\t\u0011\u0012\"A\u0005tG\u0006d\u0017\r^3ti&\u0011Ac\u0004\u0002\f\u0003:Lh)\u001e8Tk&$X\r\u0005\u0002\u001735\tqC\u0003\u0002\u0019\u0007\u0005!A/Z:u\u0013\tQrC\u0001\nSK6|G/Z*qCJ\\7+Z:tS>t\u0007C\u0001\f\u001d\u0013\tirCA\u0005T#2CU\r\u001c9fe\u00061A(\u001b8jiz\"\u0012\u0001\t\t\u0003C\u0001i\u0011a\u0001")
public class CatalogSuite
extends AnyFunSuite
implements RemoteSparkSession,
SQLHelper {
    private SparkSession spark;
    private int serverPort;
    private boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    private Path baseResourcePath;
    private Path commonResourcePath;
    private volatile boolean bitmap$0;

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLHelper.withTempDatabase$(this, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLHelper.withTable$(this, tableNames, f);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$RemoteSparkSession$$super$beforeAll() {
        BeforeAndAfterAll.beforeAll$((BeforeAndAfterAll)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$RemoteSparkSession$$super$afterAll() {
        BeforeAndAfterAll.afterAll$((BeforeAndAfterAll)this);
    }

    @Override
    public void beforeAll() {
        RemoteSparkSession.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        RemoteSparkSession.afterAll$(this);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return AnyFunSuiteLike.run$((AnyFunSuiteLike)this, (Option)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    @Override
    public Path getWorkspaceFilePath(String first, Seq<String> more) {
        return ConnectFunSuite.getWorkspaceFilePath$(this, first, more);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private int serverPort$lzycompute() {
        CatalogSuite catalogSuite = this;
        synchronized (catalogSuite) {
            if (!this.bitmap$0) {
                this.serverPort = RemoteSparkSession.serverPort$(this);
                this.bitmap$0 = true;
            }
        }
        return this.serverPort;
    }

    @Override
    public int serverPort() {
        return !this.bitmap$0 ? this.serverPort$lzycompute() : this.serverPort;
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    @Override
    public Path baseResourcePath() {
        return this.baseResourcePath;
    }

    @Override
    public Path commonResourcePath() {
        return this.commonResourcePath;
    }

    @Override
    public void org$apache$spark$sql$test$ConnectFunSuite$_setter_$baseResourcePath_$eq(Path x$1) {
        this.baseResourcePath = x$1;
    }

    @Override
    public void org$apache$spark$sql$test$ConnectFunSuite$_setter_$commonResourcePath_$eq(Path x$1) {
        this.commonResourcePath = x$1;
    }

    public static final /* synthetic */ void $anonfun$new$2(CatalogSuite $this, String currentDb$1, String db) {
        try {
            String message;
            Database[] databasesWithPattern;
            Database[] dbs;
            $this.spark().catalog().setCurrentDatabase(db);
            String $org_scalatest_assert_macro_left = $this.spark().catalog().currentDatabase();
            String $org_scalatest_assert_macro_right = db;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
            Database[] $org_scalatest_assert_macro_left2 = dbs = (Database[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])$this.spark().catalog().listDatabases().collect()), (Function1 & Serializable)x$1 -> x$1.name(), (Ordering)Ordering.String$.MODULE$);
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])dbs), (Function1 & Serializable)x$2 -> x$2.name(), ClassTag$.MODULE$.apply(String.class))).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new String[]{db, currentDb$1})), "scala.Predef.wrapRefArray[String](scala.Predef.refArrayOps[org.apache.spark.sql.catalog.Database](dbs).map[String](((x$2: org.apache.spark.sql.catalog.Database) => x$2.name))((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))).sameElements[String](scala.Predef.wrapRefArray[String](scala.Array.apply[String](db, currentDb)((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])dbs), (Function1 & Serializable)x$3 -> x$3.catalog(), ClassTag$.MODULE$.apply(String.class))))).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark_catalog"})), "scala.Predef.wrapRefArray[String](scala.Predef.refArrayOps[String](scala.Predef.refArrayOps[org.apache.spark.sql.catalog.Database](dbs).map[String](((x$3: org.apache.spark.sql.catalog.Database) => x$3.catalog))((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))).distinct).sameElements[String](scala.Predef.wrapRefArray[String](scala.Array.apply[String](\"spark_catalog\")((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            Database[] $org_scalatest_assert_macro_left3 = databasesWithPattern = (Database[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])$this.spark().catalog().listDatabases("def*").collect()), (Function1 & Serializable)x$4 -> x$4.name(), (Ordering)Ordering.String$.MODULE$);
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])databasesWithPattern), (Function1 & Serializable)x$5 -> x$5.name(), ClassTag$.MODULE$.apply(String.class))).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new String[]{currentDb$1})), "scala.Predef.wrapRefArray[String](scala.Predef.refArrayOps[org.apache.spark.sql.catalog.Database](databasesWithPattern).map[String](((x$5: org.apache.spark.sql.catalog.Database) => x$5.name))((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))).sameElements[String](scala.Predef.wrapRefArray[String](scala.Array.apply[String](currentDb)((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
            Database[] $org_scalatest_assert_macro_left4 = databasesWithPattern = (Database[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])$this.spark().catalog().listDatabases("def2*").collect()), (Function1 & Serializable)x$6 -> x$6.name(), (Ordering)Ordering.String$.MODULE$);
            int $org_scalatest_assert_macro_right4 = 0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            Database database = $this.spark().catalog().getDatabase(db);
            String $org_scalatest_assert_macro_left5 = database.name();
            String $org_scalatest_assert_macro_right5 = db;
            String string3 = $org_scalatest_assert_macro_left5;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
            String $org_scalatest_assert_macro_left6 = message = ((AnalysisException)$this.intercept((Function0 & Serializable)() -> $this.spark().catalog().getDatabase("notExists"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49))).getMessage();
            String $org_scalatest_assert_macro_right6 = "SCHEMA_NOT_FOUND";
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().databaseExists(db), "CatalogSuite.this.spark.catalog.databaseExists(db)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.spark().catalog().databaseExists("notExists"), "CatalogSuite.this.spark.catalog.databaseExists(\"notExists\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        }
        catch (Throwable throwable) {
            $this.spark().catalog().setCurrentDatabase(currentDb$1);
            String $org_scalatest_assert_macro_left = $this.spark().catalog().currentDatabase();
            String $org_scalatest_assert_macro_right = currentDb$1;
            String string = $org_scalatest_assert_macro_left;
            String string5 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string5) : string5 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            throw throwable;
        }
        $this.spark().catalog().setCurrentDatabase(currentDb$1);
        String $org_scalatest_assert_macro_left = $this.spark().catalog().currentDatabase();
        String $org_scalatest_assert_macro_right = currentDb$1;
        String string = $org_scalatest_assert_macro_left;
        String string6 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
    }

    public static final /* synthetic */ void $anonfun$new$19(CatalogSuite $this, SparkSession session$1, String orcTableName$1, File table2Dir) {
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(CatalogSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_CatalogSuite$$typecreator18$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_CatalogSuite$$typecreator18$1(CatalogSuite $outer) {
            }
        }
        Dataset df2 = session$1.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Bob", "Alice", "Nico", "Bob", "Alice"})).zipWithIndex(), session$1.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_CatalogSuite$$typecreator18$1(null)))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name", "id"}));
        df2.write().orc(table2Dir.getPath());
        $this.spark().catalog().createTable(orcTableName$1, table2Dir.getPath(), "orc").collect();
        Table orcTable = $this.spark().catalog().getTable(orcTableName$1);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(orcTable.isTemporary(), "orcTable.isTemporary", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        String $org_scalatest_assert_macro_left = orcTable.name();
        String $org_scalatest_assert_macro_right = orcTableName$1;
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        String $org_scalatest_assert_macro_left2 = orcTable.tableType();
        String $org_scalatest_assert_macro_right2 = "EXTERNAL";
        String string3 = $org_scalatest_assert_macro_left2;
        String string4 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        Set $org_scalatest_assert_macro_left3 = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])$this.spark().catalog().listColumns(orcTableName$1).collect()), (Function1 & Serializable)x$10 -> x$10.name(), ClassTag$.MODULE$.apply(String.class))).toSet();
        Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name", "id"}));
        Set set = $org_scalatest_assert_macro_left3;
        Set set2 = $org_scalatest_assert_macro_right3;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
    }

    public static final /* synthetic */ void $anonfun$new$17(CatalogSuite $this, String parquetTableName$1, String orcTableName$1, String jsonTableName$1, File table1Dir) {
        SparkSession session = $this.spark();
        Dataset df1 = session.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Bob", "Alice", "Nico", "Bob", "Alice"})), session.implicits().newStringEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name"}));
        df1.write().parquet(table1Dir.getPath());
        $this.spark().catalog().createTable(parquetTableName$1, table1Dir.getPath()).collect();
        $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{orcTableName$1, jsonTableName$1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            $this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)table2Dir -> {
                CatalogSuite.$anonfun$new$19($this, session, orcTableName$1, table2Dir);
                return BoxedUnit.UNIT;
            });
            StructType schema = new StructType().add("id", (DataType)LongType$.MODULE$).add("a", (DataType)DoubleType$.MODULE$);
            $this.spark().catalog().createTable(jsonTableName$1, "json", schema, Predef$.MODULE$.Map().empty()).collect();
            Table jsonTable = $this.spark().catalog().getTable("default", jsonTableName$1);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(jsonTable.isTemporary(), "jsonTable.isTemporary", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            String $org_scalatest_assert_macro_left = jsonTable.name();
            String $org_scalatest_assert_macro_right = jsonTableName$1;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            String $org_scalatest_assert_macro_left2 = jsonTable.tableType();
            String $org_scalatest_assert_macro_right2 = "MANAGED";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().tableExists(jsonTableName$1), "CatalogSuite.this.spark.catalog.tableExists(jsonTableName)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            Set $org_scalatest_assert_macro_left3 = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])$this.spark().catalog().listTables().collect()), (Function1 & Serializable)x$11 -> x$11.name(), ClassTag$.MODULE$.apply(String.class))).toSet();
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{parquetTableName$1, orcTableName$1, jsonTableName$1}));
            Set set = $org_scalatest_assert_macro_left3;
            Set set2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            Set $org_scalatest_assert_macro_left4 = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])$this.spark().catalog().listTables($this.spark().catalog().currentDatabase(), "par*").collect()), (Function1 & Serializable)x$12 -> x$12.name(), ClassTag$.MODULE$.apply(String.class))).toSet();
            Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{parquetTableName$1}));
            Set set3 = $org_scalatest_assert_macro_left4;
            Set set4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            Object $org_scalatest_assert_macro_left5 = Predef$.MODULE$.refArrayOps((Object[])$this.spark().catalog().listTables($this.spark().catalog().currentDatabase(), "txt*").collect());
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left5), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        });
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().tableExists(parquetTableName$1), "CatalogSuite.this.spark.catalog.tableExists(parquetTableName)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.spark().catalog().tableExists(orcTableName$1), "CatalogSuite.this.spark.catalog.tableExists(orcTableName)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.spark().catalog().tableExists(jsonTableName$1), "CatalogSuite.this.spark.catalog.tableExists(jsonTableName)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        Set $org_scalatest_assert_macro_left = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])$this.spark().catalog().listTables().collect()), (Function1 & Serializable)x$13 -> x$13.name(), ClassTag$.MODULE$.apply(String.class))).toSet();
        Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{parquetTableName$1}));
        Set set = $org_scalatest_assert_macro_left;
        Set set2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
    }

    public static final /* synthetic */ void $anonfun$new$27(CatalogSuite $this, String parquetTableName$2, File table1Dir) {
        SparkSession session = $this.spark();
        Dataset df1 = session.implicits().localSeqToDatasetHolder((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Bob", "Alice", "Nico", "Bob", "Alice"})), session.implicits().newStringEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name"}));
        df1.write().parquet(table1Dir.getPath());
        $this.spark().catalog().createTable(parquetTableName$2, table1Dir.getPath()).collect();
        $this.spark().catalog().cacheTable(parquetTableName$2);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached(parquetTableName$2), "CatalogSuite.this.spark.catalog.isCached(parquetTableName)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        $this.spark().catalog().uncacheTable(parquetTableName$2);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached(parquetTableName$2), "CatalogSuite.this.spark.catalog.isCached(parquetTableName)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        $this.spark().catalog().cacheTable(parquetTableName$2, StorageLevel$.MODULE$.MEMORY_ONLY());
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached(parquetTableName$2), "CatalogSuite.this.spark.catalog.isCached(parquetTableName)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        $this.spark().catalog().clearCache();
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached(parquetTableName$2), "CatalogSuite.this.spark.catalog.isCached(parquetTableName)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
    }

    public static final /* synthetic */ boolean $anonfun$new$33(Function f) {
        String string = f.name();
        String string2 = "to_date";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$36(CatalogSuite $this, String tableName$1, File dir) {
        $this.spark().range(5L).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id as fieldOne", "id as partCol"})).write().partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"partCol"})).mode("overwrite").save(dir.getAbsolutePath());
        $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(156).append("\n             |create table ").append(tableName$1).append(" (fieldOne long, partCol int)\n             |using parquet\n             |options (path \"").append(dir.toURI()).append("\")\n             |partitioned by (partCol)").toString())));
        $this.spark().sql(new StringBuilder(16).append("show partitions ").append(tableName$1).toString()).count();
        long $org_scalatest_assert_macro_left = $this.spark().sql(new StringBuilder(14).append("select * from ").append(tableName$1).toString()).count();
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        $this.spark().catalog().recoverPartitions(tableName$1);
        long $org_scalatest_assert_macro_left2 = $this.spark().sql(new StringBuilder(14).append("select * from ").append(tableName$1).toString()).count();
        int $org_scalatest_assert_macro_right2 = 5;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
    }

    public static final /* synthetic */ void $anonfun$new$38(CatalogSuite $this, File dir) {
        String tableName = "spark_catalog.default.my_table";
        $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            try {
                $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(100).append("\n               | CREATE TABLE ").append(tableName).append("(col STRING) USING TEXT\n               | LOCATION '").append(dir.getAbsolutePath()).append("'\n               |").toString())));
                $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(25).append("INSERT INTO ").append(tableName).append(" SELECT 'abc'").toString())));
                $this.spark().catalog().cacheTable(tableName);
                Row[] $org_scalatest_assert_macro_left = (Row[])$this.spark().table(tableName).collect();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
                FileUtils.deleteDirectory((File)dir);
                Row[] $org_scalatest_assert_macro_left2 = (Row[])$this.spark().table(tableName).collect();
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
                $this.spark().catalog().refreshTable(tableName);
                Row[] $org_scalatest_assert_macro_left3 = (Row[])$this.spark().table(tableName).collect();
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
            }
            finally {
                $this.spark().catalog().clearCache();
            }
        });
    }

    public static final /* synthetic */ void $anonfun$new$41(CatalogSuite $this, File dir) {
        String tableName = "spark_catalog.default.my_table";
        $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            try {
                $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(100).append("\n               | CREATE TABLE ").append(tableName).append("(col STRING) USING TEXT\n               | LOCATION '").append(dir.getAbsolutePath()).append("'\n               |").toString())));
                $this.spark().sql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(25).append("INSERT INTO ").append(tableName).append(" SELECT 'abc'").toString())));
                $this.spark().catalog().cacheTable(tableName);
                Row[] $org_scalatest_assert_macro_left = (Row[])$this.spark().table(tableName).collect();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
                ((File)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])new File(dir.getAbsolutePath()).listFiles(new FilenameFilter(null){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".txt");
                    }
                })))).delete();
                Row[] $org_scalatest_assert_macro_left2 = (Row[])$this.spark().table(tableName).collect();
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
                $this.spark().catalog().refreshByPath(dir.getAbsolutePath());
                Row[] $org_scalatest_assert_macro_left3 = (Row[])$this.spark().table(tableName).collect();
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
            }
            finally {
                $this.spark().catalog().clearCache();
            }
        });
    }

    public CatalogSuite() {
        ConnectFunSuite.$init$(this);
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        RemoteSparkSession.$init$(this);
        SQLHelper.$init$(this);
        this.test("Database APIs", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String currentDb;
            String $org_scalatest_assert_macro_left = currentDb = this.spark().catalog().currentDatabase();
            String $org_scalatest_assert_macro_right = "default";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
            this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable)db -> {
                CatalogSuite.$anonfun$new$2(this, currentDb, db);
                return BoxedUnit.UNIT;
            });
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        this.test("CatalogMetadata APIs", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Assertion assertion;
            String currentCatalog;
            String $org_scalatest_assert_macro_left = currentCatalog = this.spark().catalog().currentCatalog();
            String $org_scalatest_assert_macro_right = "spark_catalog";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            try {
                CatalogMetadata[] catalogsWithPattern;
                CatalogMetadata[] catalogsAfterChange;
                String message;
                CatalogMetadata[] catalogs;
                CatalogMetadata[] $org_scalatest_assert_macro_left2 = catalogs = (CatalogMetadata[])this.spark().catalog().listCatalogs().collect();
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])catalogs), (Function1 & Serializable)x$7 -> x$7.name(), ClassTag$.MODULE$.apply(String.class))).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark_catalog"})), "scala.Predef.wrapRefArray[String](scala.Predef.refArrayOps[org.apache.spark.sql.catalog.CatalogMetadata](catalogs).map[String](((x$7: org.apache.spark.sql.catalog.CatalogMetadata) => x$7.name))((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))).sameElements[String](scala.Predef.wrapRefArray[String](scala.Array.apply[String](\"spark_catalog\")((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))))", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
                String $org_scalatest_assert_macro_left3 = message = ((Throwable)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.spark().catalog().setCurrentCatalog("notExists"), ClassTag$.MODULE$.apply(SparkException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69))).getMessage();
                String $org_scalatest_assert_macro_right3 = "plugin class not found";
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
                this.spark().catalog().setCurrentCatalog("testcat");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(this.spark().catalog().currentCatalog().equals("testcat"), "CatalogSuite.this.spark.catalog.currentCatalog().equals(\"testcat\")", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
                CatalogMetadata[] $org_scalatest_assert_macro_left4 = catalogsAfterChange = (CatalogMetadata[])this.spark().catalog().listCatalogs().collect();
                int $org_scalatest_assert_macro_right4 = 2;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
                Set $org_scalatest_assert_macro_left5 = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])catalogsAfterChange), (Function1 & Serializable)x$8 -> x$8.name(), ClassTag$.MODULE$.apply(String.class))).toSet();
                Set $org_scalatest_assert_macro_right5 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"testcat", "spark_catalog"}));
                Set set = $org_scalatest_assert_macro_left5;
                Set set2 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
                CatalogMetadata[] $org_scalatest_assert_macro_left6 = catalogsWithPattern = (CatalogMetadata[])this.spark().catalog().listCatalogs("spark*").collect();
                int $org_scalatest_assert_macro_right6 = 1;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])catalogsWithPattern), (Function1 & Serializable)x$9 -> x$9.name(), ClassTag$.MODULE$.apply(String.class))).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark_catalog"})), "scala.Predef.wrapRefArray[String](scala.Predef.refArrayOps[org.apache.spark.sql.catalog.CatalogMetadata](catalogsWithPattern).map[String](((x$9: org.apache.spark.sql.catalog.CatalogMetadata) => x$9.name))((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))).sameElements[String](scala.Predef.wrapRefArray[String](scala.Array.apply[String](\"spark_catalog\")((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))))", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
                CatalogMetadata[] $org_scalatest_assert_macro_left7 = catalogsWithPattern = (CatalogMetadata[])this.spark().catalog().listCatalogs("hive*").collect();
                int $org_scalatest_assert_macro_right7 = 0;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            }
            catch (Throwable throwable) {
                this.spark().catalog().setCurrentCatalog(currentCatalog);
                String $org_scalatest_assert_macro_left8 = this.spark().catalog().currentCatalog();
                String $org_scalatest_assert_macro_right8 = "spark_catalog";
                String string3 = $org_scalatest_assert_macro_left8;
                String string4 = $org_scalatest_assert_macro_right8;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
                throw throwable;
            }
            this.spark().catalog().setCurrentCatalog(currentCatalog);
            String $org_scalatest_assert_macro_left9 = this.spark().catalog().currentCatalog();
            String $org_scalatest_assert_macro_right9 = "spark_catalog";
            String string5 = $org_scalatest_assert_macro_left9;
            String string6 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right9, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            return assertion;
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("Table APIs", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String message;
            Object $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])this.spark().catalog().listTables().collect());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            String parquetTableName = "parquet_table";
            String orcTableName = "orc_table";
            String jsonTableName = "json_table";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{parquetTableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)table1Dir -> {
                CatalogSuite.$anonfun$new$17(this, parquetTableName, orcTableName, jsonTableName, table1Dir);
                return BoxedUnit.UNIT;
            }));
            String $org_scalatest_assert_macro_left2 = message = ((AnalysisException)this.intercept((Function0 & Serializable)() -> this.spark().catalog().getTable(parquetTableName), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144))).getMessage();
            String $org_scalatest_assert_macro_right = "TABLE_OR_VIEW_NOT_FOUND";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
            Object $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])this.spark().catalog().listTables().collect());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left3), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("Cache Table APIs", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String parquetTableName = "parquet_table";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{parquetTableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)table1Dir -> {
                CatalogSuite.$anonfun$new$27(this, parquetTableName, table1Dir);
                return BoxedUnit.UNIT;
            }));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.test("TempView APIs", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Assertion assertion;
            String viewName = "view1";
            String globalViewName = "g_view1";
            try {
                this.spark().range(100L).createTempView(viewName);
                Table view = this.spark().catalog().getTable(viewName);
                String $org_scalatest_assert_macro_left = view.name();
                String $org_scalatest_assert_macro_right = viewName;
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(view.isTemporary(), "view.isTemporary", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
                String $org_scalatest_assert_macro_left2 = view.tableType();
                String $org_scalatest_assert_macro_right2 = "TEMPORARY";
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
                this.spark().range(100L).createGlobalTempView(globalViewName);
                Table globalView = this.spark().catalog().getTable(new StringBuilder(12).append("global_temp.").append(globalViewName).toString());
                String $org_scalatest_assert_macro_left3 = globalView.name();
                String $org_scalatest_assert_macro_right3 = globalViewName;
                String string5 = $org_scalatest_assert_macro_left3;
                String string6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(globalView.isTemporary(), "globalView.isTemporary", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
                String $org_scalatest_assert_macro_left4 = globalView.tableType();
                String $org_scalatest_assert_macro_right4 = "TEMPORARY";
                String string7 = $org_scalatest_assert_macro_left4;
                String string8 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            }
            finally {
                this.spark().catalog().dropTempView(viewName);
                this.spark().catalog().dropGlobalTempView(globalViewName);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.spark().catalog().tableExists(viewName), "CatalogSuite.this.spark.catalog.tableExists(viewName)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.spark().catalog().tableExists(globalViewName), "CatalogSuite.this.spark.catalog.tableExists(globalViewName)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            }
            return assertion;
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        this.test("Function API", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String message;
            String dbName = this.spark().catalog().currentDatabase();
            Function[] functions1 = (Function[])this.spark().catalog().listFunctions().collect();
            Object $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])functions1);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
            Function[] functions2 = (Function[])this.spark().catalog().listFunctions(dbName).collect();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])functions1), (Function1 & Serializable)x$14 -> x$14.name(), ClassTag$.MODULE$.apply(String.class))).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])functions2), (Function1 & Serializable)x$15 -> x$15.name(), ClassTag$.MODULE$.apply(String.class)))), "scala.Predef.wrapRefArray[String](scala.Predef.refArrayOps[org.apache.spark.sql.catalog.Function](functions1).map[String](((x$14: org.apache.spark.sql.catalog.Function) => x$14.name))((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))).sameElements[String](scala.Predef.wrapRefArray[String](scala.Predef.refArrayOps[org.apache.spark.sql.catalog.Function](functions2).map[String](((x$15: org.apache.spark.sql.catalog.Function) => x$15.name))((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String]))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
            String absFunctionName = "abs";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.spark().catalog().functionExists(absFunctionName), "CatalogSuite.this.spark.catalog.functionExists(absFunctionName)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
            String $org_scalatest_assert_macro_left2 = this.spark().catalog().getFunction(absFunctionName).name();
            String $org_scalatest_assert_macro_right = absFunctionName;
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
            String notExistsFunction = "notExists";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.spark().catalog().functionExists(notExistsFunction), "CatalogSuite.this.spark.catalog.functionExists(notExistsFunction)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
            String $org_scalatest_assert_macro_left3 = message = ((AnalysisException)this.intercept((Function0 & Serializable)() -> this.spark().catalog().getFunction(notExistsFunction), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210))).getMessage();
            String $org_scalatest_assert_macro_right2 = "UNRESOLVED_ROUTINE";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
            Function[] functionsWithPattern1 = (Function[])this.spark().catalog().listFunctions(dbName, "to*").collect();
            Object $org_scalatest_assert_macro_left4 = Predef$.MODULE$.refArrayOps((Object[])functionsWithPattern1);
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left4), "nonEmpty", ArrayOps$.MODULE$.nonEmpty$extension($org_scalatest_assert_macro_left4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])functionsWithPattern1), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)CatalogSuite.$anonfun$new$33(f))), "scala.Predef.refArrayOps[org.apache.spark.sql.catalog.Function](functionsWithPattern1).exists(((f: org.apache.spark.sql.catalog.Function) => f.name.==(\"to_date\")))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
            Function[] functionsWithPattern2 = (Function[])this.spark().catalog().listFunctions(dbName, "*not_existing_func*").collect();
            Object $org_scalatest_assert_macro_left5 = Predef$.MODULE$.refArrayOps((Object[])functionsWithPattern2);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left5), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
        this.test("recoverPartitions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String tableName = "test";
            this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
                CatalogSuite.$anonfun$new$36(this, tableName, dir);
                return BoxedUnit.UNIT;
            }));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
        this.test("refreshTable", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            CatalogSuite.$anonfun$new$38(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
        this.test("refreshByPath", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)dir -> {
            CatalogSuite.$anonfun$new$41(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
        Statics.releaseFence();
    }
}

