/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.connect.Dataset;
import org.apache.spark.sql.connect.client.SparkResult;
import org.apache.spark.sql.connect.client.jdbc.SparkConnectConnection;
import org.apache.spark.sql.connect.client.jdbc.SparkConnectResultSet;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\t\rd\u0001B\u001f?\u00015C\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\u0006A\u0002!\t!\u0019\u0005\nI\u0002\u0001\r\u00111A\u0005\n\u0015D\u0011b\u001d\u0001A\u0002\u0003\u0007I\u0011\u0002;\t\u0013m\u0004\u0001\u0019!A!B\u00131\u0007\"\u0003?\u0001\u0001\u0004\u0005\r\u0011\"\u0003~\u0011-\t\u0019\u0001\u0001a\u0001\u0002\u0004%I!!\u0002\t\u0015\u0005%\u0001\u00011A\u0001B\u0003&a\u0010C\u0005\u0002\f\u0001\u0001\r\u0011\"\u0003\u0002\u000e!I\u0011Q\u0003\u0001A\u0002\u0013%\u0011q\u0003\u0005\t\u00037\u0001\u0001\u0015)\u0003\u0002\u0010!I\u0011Q\u0004\u0001A\u0002\u0013%\u0011q\u0004\u0005\n\u0003O\u0001\u0001\u0019!C\u0005\u0003SA\u0001\"!\f\u0001A\u0003&\u0011\u0011\u0005\u0005\b\u0003o\u0001A\u0011IA\u001d\u0011\u001d\tY\u0004\u0001C!\u0003{A\u0001\"a\u0010\u0001\t\u0003q\u0014Q\b\u0005\b\u0003\u0003\u0002A\u0011IA\"\u0011\u001d\ti\u0005\u0001C!\u0003\u001fBq!a\u0015\u0001\t\u0013\t)\u0006C\u0004\u0002|\u0001!\t%! \t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u0004\"9\u0011Q\u0011\u0001\u0005B\u0005\u001d\u0005bBAE\u0001\u0011\u0005\u00131\u0012\u0005\b\u0003#\u0003A\u0011IAD\u0011\u001d\t\u0019\n\u0001C!\u0003+Cq!!'\u0001\t\u0003\nY\nC\u0004\u0002\"\u0002!\t%a\"\t\u000f\u0005\r\u0006\u0001\"\u0011\u0002&\"9\u00111\u0016\u0001\u0005B\u0005u\u0002bBAW\u0001\u0011\u0005\u0013q\u0016\u0005\b\u0003o\u0003A\u0011IA\u001f\u0011\u001d\tI\f\u0001C!\u0003wCq!!1\u0001\t\u0003\n9\tC\u0004\u0002D\u0002!\t%!\u000f\t\u000f\u0005\u0015\u0007\u0001\"\u0011\u0002H\"9\u0011Q\u001a\u0001\u0005B\u0005\u001d\u0005bBAh\u0001\u0011\u0005\u0013\u0011\u001b\u0005\b\u0003/\u0004A\u0011IAD\u0011\u001d\tI\u000e\u0001C!\u0003\u000fCq!a7\u0001\t\u0003\n9\tC\u0004\u0002^\u0002!\t%a8\t\u000f\u0005\r\b\u0001\"\u0011\u0002>!9\u0011Q\u001d\u0001\u0005B\u0005\u001d\bbBAx\u0001\u0011\u0005\u0013\u0011\u001f\u0005\b\u0003\u0007\u0004A\u0011IA}\u0011\u001d\ty\u0010\u0001C!\u0003\u0007Cq!!\u0014\u0001\t\u0003\u0012\t\u0001C\u0004\u0002N\u0001!\tE!\u0003\t\u000f\u00055\u0003\u0001\"\u0011\u0003\u0012!9\u00111\u0010\u0001\u0005B\tm\u0001bBA>\u0001\u0011\u0005#\u0011\u0005\u0005\b\u0003w\u0002A\u0011\tB\u0014\u0011\u001d\u0011i\u0003\u0001C!\u0003\u000fCqAa\f\u0001\t\u0003\u0012\t\u0004C\u0004\u00038\u0001!\t%!\u000f\t\u000f\te\u0002\u0001\"\u0011\u0002>!9!1\b\u0001\u0005B\u0005e\u0002b\u0002B\u001f\u0001\u0011\u0005#q\b\u0005\b\u0005'\u0002A\u0011\tB+\u0005U\u0019\u0006/\u0019:l\u0007>tg.Z2u'R\fG/Z7f]RT!a\u0010!\u0002\t)$'m\u0019\u0006\u0003\u0003\n\u000baa\u00197jK:$(BA\"E\u0003\u001d\u0019wN\u001c8fGRT!!\u0012$\u0002\u0007M\fHN\u0003\u0002H\u0011\u0006)1\u000f]1sW*\u0011\u0011JS\u0001\u0007CB\f7\r[3\u000b\u0003-\u000b1a\u001c:h\u0007\u0001\u00192\u0001\u0001(W!\tyE+D\u0001Q\u0015\t\t&+\u0001\u0003mC:<'\"A*\u0002\t)\fg/Y\u0005\u0003+B\u0013aa\u00142kK\u000e$\bCA,Z\u001b\u0005A&BA#S\u0013\tQ\u0006LA\u0005Ti\u0006$X-\\3oi\u0006!1m\u001c8o!\tif,D\u0001?\u0013\tyfH\u0001\fTa\u0006\u00148nQ8o]\u0016\u001cGoQ8o]\u0016\u001cG/[8o\u0003\u0019a\u0014N\\5u}Q\u0011!m\u0019\t\u0003;\u0002AQa\u0017\u0002A\u0002q\u000b1b\u001c9fe\u0006$\u0018n\u001c8JIV\ta\r\u0005\u0002ha:\u0011\u0001N\u001c\t\u0003S2l\u0011A\u001b\u0006\u0003W2\u000ba\u0001\u0010:p_Rt$\"A7\u0002\u000bM\u001c\u0017\r\\1\n\u0005=d\u0017A\u0002)sK\u0012,g-\u0003\u0002re\n11\u000b\u001e:j]\u001eT!a\u001c7\u0002\u001f=\u0004XM]1uS>t\u0017\nZ0%KF$\"!^=\u0011\u0005Y<X\"\u00017\n\u0005ad'\u0001B+oSRDqA\u001f\u0003\u0002\u0002\u0003\u0007a-A\u0002yIE\nAb\u001c9fe\u0006$\u0018n\u001c8JI\u0002\n\u0011B]3tk2$8+\u001a;\u0016\u0003y\u0004\"!X@\n\u0007\u0005\u0005aHA\u000bTa\u0006\u00148nQ8o]\u0016\u001cGOU3tk2$8+\u001a;\u0002\u001bI,7/\u001e7u'\u0016$x\fJ3r)\r)\u0018q\u0001\u0005\bu\u001e\t\t\u00111\u0001\u007f\u0003)\u0011Xm];miN+G\u000fI\u0001\b[\u0006D(k\\<t+\t\ty\u0001E\u0002w\u0003#I1!a\u0005m\u0005\rIe\u000e^\u0001\f[\u0006D(k\\<t?\u0012*\u0017\u000fF\u0002v\u00033A\u0001B\u001f\u0006\u0002\u0002\u0003\u0007\u0011qB\u0001\t[\u0006D(k\\<tA\u000511\r\\8tK\u0012,\"!!\t\u0011\u0007Y\f\u0019#C\u0002\u0002&1\u0014qAQ8pY\u0016\fg.\u0001\u0006dY>\u001cX\rZ0%KF$2!^A\u0016\u0011!QX\"!AA\u0002\u0005\u0005\u0012aB2m_N,G\r\t\u0015\u0004\u001d\u0005E\u0002c\u0001<\u00024%\u0019\u0011Q\u00077\u0003\u0011Y|G.\u0019;jY\u0016\f\u0001\"[:DY>\u001cX\r\u001a\u000b\u0003\u0003C\tQa\u00197pg\u0016$\u0012!^\u0001\nG\",7m[(qK:\fA\"\u001a=fGV$X-U;fef$B!!\u0012\u0002LA\u0019q+a\u0012\n\u0007\u0005%\u0003LA\u0005SKN,H\u000e^*fi\")QI\u0005a\u0001M\u0006iQ\r_3dkR,W\u000b\u001d3bi\u0016$B!a\u0004\u0002R!)Qi\u0005a\u0001M\u0006a\u0001.Y:SKN,H\u000e^*fiR!\u0011\u0011EA,\u0011\u001d\tI\u0006\u0006a\u0001\u00037\n1b\u001d9be.\u0014Vm];miB\"\u0011QLA5!\u0019\ty&!\u0019\u0002f5\t\u0001)C\u0002\u0002d\u0001\u00131b\u00159be.\u0014Vm];miB!\u0011qMA5\u0019\u0001!A\"a\u001b\u0002X\u0005\u0005\t\u0011!B\u0001\u0003[\u00121a\u0018\u00132#\u0011\ty'!\u001e\u0011\u0007Y\f\t(C\u0002\u0002t1\u0014qAT8uQ&tw\rE\u0002w\u0003oJ1!!\u001fm\u0005\r\te._\u0001\bKb,7-\u001e;f)\u0011\t\t#a \t\u000b\u0015+\u0002\u0019\u00014\u0002\u0019\u001d,GOU3tk2$8+\u001a;\u0015\u0005\u0005\u0015\u0013aD4fi6\u000b\u0007PR5fY\u0012\u001c\u0016N_3\u0015\u0005\u0005=\u0011aD:fi6\u000b\u0007PR5fY\u0012\u001c\u0016N_3\u0015\u0007U\fi\tC\u0004\u0002\u0010b\u0001\r!a\u0004\u0002\u00075\f\u00070\u0001\u0006hKRl\u0015\r\u001f*poN\f!b]3u\u001b\u0006D(k\\<t)\r)\u0018q\u0013\u0005\b\u0003\u001fS\u0002\u0019AA\b\u0003M\u0019X\r^#tG\u0006\u0004X\r\u0015:pG\u0016\u001c8/\u001b8h)\r)\u0018Q\u0014\u0005\b\u0003?[\u0002\u0019AA\u0011\u0003\u0019)g.\u00192mK\u0006yq-\u001a;Rk\u0016\u0014\u0018\u0010V5nK>,H/A\btKR\fV/\u001a:z)&lWm\\;u)\r)\u0018q\u0015\u0005\b\u0003Sk\u0002\u0019AA\b\u0003\u001d\u0019XmY8oIN\faaY1oG\u0016d\u0017aC4fi^\u000b'O\\5oON$\"!!-\u0011\u0007]\u000b\u0019,C\u0002\u00026b\u0013!bU)M/\u0006\u0014h.\u001b8h\u00035\u0019G.Z1s/\u0006\u0014h.\u001b8hg\u0006i1/\u001a;DkJ\u001cxN\u001d(b[\u0016$2!^A_\u0011\u0019\ty,\ta\u0001M\u0006!a.Y7f\u000399W\r^+qI\u0006$XmQ8v]R\fabZ3u\u001b>\u0014XMU3tk2$8/A\ttKR4U\r^2i\t&\u0014Xm\u0019;j_:$2!^Ae\u0011\u001d\tY\r\na\u0001\u0003\u001f\t\u0011\u0002Z5sK\u000e$\u0018n\u001c8\u0002#\u001d,GOR3uG\"$\u0015N]3di&|g.\u0001\u0007tKR4U\r^2i'&TX\rF\u0002v\u0003'Dq!!6'\u0001\u0004\ty!\u0001\u0003s_^\u001c\u0018\u0001D4fi\u001a+Go\u00195TSj,\u0017aF4fiJ+7/\u001e7u'\u0016$8i\u001c8dkJ\u0014XM\\2z\u0003A9W\r\u001e*fgVdGoU3u)f\u0004X-\u0001\u0005bI\u0012\u0014\u0015\r^2i)\r)\u0018\u0011\u001d\u0005\u0006\u000b*\u0002\rAZ\u0001\u000bG2,\u0017M\u001d\"bi\u000eD\u0017\u0001D3yK\u000e,H/\u001a\"bi\u000eDGCAAu!\u00151\u00181^A\b\u0013\r\ti\u000f\u001c\u0002\u0006\u0003J\u0014\u0018-_\u0001\u000eO\u0016$8i\u001c8oK\u000e$\u0018n\u001c8\u0015\u0005\u0005M\bcA,\u0002v&\u0019\u0011q\u001f-\u0003\u0015\r{gN\\3di&|g\u000e\u0006\u0003\u0002\"\u0005m\bbBA\u007f]\u0001\u0007\u0011qB\u0001\bGV\u0014(/\u001a8u\u0003A9W\r^$f]\u0016\u0014\u0018\r^3e\u0017\u0016L8\u000f\u0006\u0004\u0002\u0010\t\r!Q\u0001\u0005\u0006\u000bB\u0002\rA\u001a\u0005\b\u0005\u000f\u0001\u0004\u0019AA\b\u0003E\tW\u000f^8HK:,'/\u0019;fI.+\u0017p\u001d\u000b\u0007\u0003\u001f\u0011YA!\u0004\t\u000b\u0015\u000b\u0004\u0019\u00014\t\u000f\t=\u0011\u00071\u0001\u0002j\u0006i1m\u001c7v[:Le\u000eZ3yKN$b!a\u0004\u0003\u0014\tU\u0001\"B#3\u0001\u00041\u0007b\u0002B\fe\u0001\u0007!\u0011D\u0001\fG>dW/\u001c8OC6,7\u000f\u0005\u0003w\u0003W4GCBA\u0011\u0005;\u0011y\u0002C\u0003Fg\u0001\u0007a\rC\u0004\u0003\bM\u0002\r!a\u0004\u0015\r\u0005\u0005\"1\u0005B\u0013\u0011\u0015)E\u00071\u0001g\u0011\u001d\u0011y\u0001\u000ea\u0001\u0003S$b!!\t\u0003*\t-\u0002\"B#6\u0001\u00041\u0007b\u0002B\fk\u0001\u0007!\u0011D\u0001\u0018O\u0016$(+Z:vYR\u001cV\r\u001e%pY\u0012\f'-\u001b7jif\f1b]3u!>|G.\u00192mKR\u0019QOa\r\t\u000f\tUr\u00071\u0001\u0002\"\u0005A\u0001o\\8mC\ndW-\u0001\u0006jgB{w\u000e\\1cY\u0016\f\u0011c\u00197pg\u0016|enQ8na2,G/[8o\u0003MI7o\u00117pg\u0016|enQ8na2,G/[8o\u0003\u0019)hn\u001e:baV!!\u0011\tB#)\u0011\u0011\u0019E!\u0013\u0011\t\u0005\u001d$Q\t\u0003\b\u0005\u000fZ$\u0019AA7\u0005\u0005!\u0006b\u0002B&w\u0001\u0007!QJ\u0001\u0006S\u001a\f7-\u001a\t\u0006O\n=#1I\u0005\u0004\u0005#\u0012(!B\"mCN\u001c\u0018\u0001D5t/J\f\u0007\u000f]3s\r>\u0014H\u0003BA\u0011\u0005/BqAa\u0013=\u0001\u0004\u0011I\u0006\r\u0003\u0003\\\t}\u0003#B4\u0003P\tu\u0003\u0003BA4\u0005?\"AB!\u0019\u0003X\u0005\u0005\t\u0011!B\u0001\u0003[\u00121a\u0018\u00133\u0001")
public class SparkConnectStatement
implements Statement {
    private final SparkConnectConnection conn;
    private String operationId;
    private SparkConnectResultSet resultSet;
    private int maxRows;
    private volatile boolean closed;

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return Statement.super.getLargeUpdateCount();
    }

    @Override
    public void setLargeMaxRows(long x$1) throws SQLException {
        Statement.super.setLargeMaxRows(x$1);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return Statement.super.getLargeMaxRows();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        return Statement.super.executeLargeBatch();
    }

    @Override
    public long executeLargeUpdate(String x$1) throws SQLException {
        return Statement.super.executeLargeUpdate(x$1);
    }

    @Override
    public long executeLargeUpdate(String x$1, int x$2) throws SQLException {
        return Statement.super.executeLargeUpdate(x$1, x$2);
    }

    @Override
    public long executeLargeUpdate(String x$1, int[] x$2) throws SQLException {
        return Statement.super.executeLargeUpdate(x$1, x$2);
    }

    @Override
    public long executeLargeUpdate(String x$1, String[] x$2) throws SQLException {
        return Statement.super.executeLargeUpdate(x$1, x$2);
    }

    @Override
    public String enquoteLiteral(String x$1) throws SQLException {
        return Statement.super.enquoteLiteral(x$1);
    }

    @Override
    public String enquoteIdentifier(String x$1, boolean x$2) throws SQLException {
        return Statement.super.enquoteIdentifier(x$1, x$2);
    }

    @Override
    public boolean isSimpleIdentifier(String x$1) throws SQLException {
        return Statement.super.isSimpleIdentifier(x$1);
    }

    @Override
    public String enquoteNCharLiteral(String x$1) throws SQLException {
        return Statement.super.enquoteNCharLiteral(x$1);
    }

    private String operationId() {
        return this.operationId;
    }

    private void operationId_$eq(String x$1) {
        this.operationId = x$1;
    }

    private SparkConnectResultSet resultSet() {
        return this.resultSet;
    }

    private void resultSet_$eq(SparkConnectResultSet x$1) {
        this.resultSet = x$1;
    }

    private int maxRows() {
        return this.maxRows;
    }

    private void maxRows_$eq(int x$1) {
        this.maxRows = x$1;
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    @Override
    public boolean isClosed() {
        return this.closed();
    }

    @Override
    public synchronized void close() {
        if (!this.closed()) {
            if (this.operationId() != null) {
                this.conn.spark().interruptOperation(this.operationId());
                this.operationId_$eq(null);
            }
            if (this.resultSet() != null) {
                this.resultSet().close();
                this.resultSet_$eq(null);
            }
            this.closed_$eq(false);
            return;
        }
    }

    public void checkOpen() {
        if (this.closed()) {
            throw new SQLException("JDBC Statement is closed.");
        }
    }

    @Override
    public ResultSet executeQuery(String sql) {
        boolean hasResultSet = this.execute(sql);
        if (hasResultSet) {
            Predef$.MODULE$.assert(this.resultSet() != null);
            return this.resultSet();
        }
        throw new SQLException("The query does not produce a ResultSet.");
    }

    @Override
    public int executeUpdate(String sql) {
        boolean hasResultSet = this.execute(sql);
        if (hasResultSet) {
            this.resultSet().close();
            throw new SQLException("The query produces a ResultSet.");
        }
        Predef$.MODULE$.assert(this.resultSet() == null);
        return this.getUpdateCount();
    }

    private boolean hasResultSet(SparkResult<?> sparkResult) {
        return sparkResult.schema().length() > 0;
    }

    @Override
    public boolean execute(String sql) {
        this.checkOpen();
        this.operationId_$eq(null);
        this.resultSet_$eq(null);
        Dataset df = this.conn.spark().sql(sql);
        if (this.maxRows() > 0) {
            df = df.limit(this.maxRows());
        }
        SparkResult sparkResult = df.collectResult();
        this.operationId_$eq(sparkResult.operationId());
        if (this.hasResultSet(sparkResult)) {
            this.resultSet_$eq(new SparkConnectResultSet((SparkResult<Row>)sparkResult, this));
            return true;
        }
        sparkResult.close();
        return false;
    }

    @Override
    public ResultSet getResultSet() {
        this.checkOpen();
        return this.resultSet();
    }

    @Override
    public int getMaxFieldSize() {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setMaxFieldSize(int max) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getMaxRows() {
        this.checkOpen();
        return this.maxRows();
    }

    @Override
    public void setMaxRows(int max) {
        this.checkOpen();
        if (max < 0) {
            throw new SQLException("The max rows must be zero or a positive integer.");
        }
        this.maxRows_$eq(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getQueryTimeout() {
        this.checkOpen();
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void cancel() {
        this.checkOpen();
        if (this.operationId() != null) {
            this.conn.spark().interruptOperation(this.operationId());
            return;
        }
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public void setCursorName(String name) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getUpdateCount() {
        this.checkOpen();
        if (this.resultSet() != null) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean getMoreResults() {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setFetchDirection(int direction) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getFetchDirection() {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setFetchSize(int rows) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getFetchSize() {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetConcurrency() {
        this.checkOpen();
        return 1007;
    }

    @Override
    public int getResultSetType() {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void addBatch(String sql) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearBatch() {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int[] executeBatch() {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Connection getConnection() {
        this.checkOpen();
        return this.conn;
    }

    @Override
    public boolean getMoreResults(int current) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getGeneratedKeys() {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setPoolable(boolean poolable) {
        this.checkOpen();
        if (poolable) {
            throw new SQLFeatureNotSupportedException("Poolable statement is not supported");
        }
    }

    @Override
    public boolean isPoolable() {
        this.checkOpen();
        return false;
    }

    @Override
    public void closeOnCompletion() {
        this.checkOpen();
    }

    @Override
    public boolean isCloseOnCompletion() {
        this.checkOpen();
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        if (this.isWrapperFor(iface)) {
            return (T)iface;
        }
        throw new SQLException(this.getClass().getName() + " not unwrappable from " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    public SparkConnectStatement(SparkConnectConnection conn) {
        this.conn = conn;
        this.maxRows = 0;
        this.closed = false;
    }
}

