/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.Level;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.util.LogLevel;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class LogLevelTestRule
implements TestRule {
    public Statement apply(Statement base, Description description) {
        Optional<Annotation> annotationOpt = description.getAnnotations().stream().filter(a -> a.annotationType().equals(LogLevel.class)).findAny();
        if (annotationOpt.isEmpty()) {
            return base;
        }
        LogLevel annotation = (LogLevel)annotationOpt.get();
        return new LogLevelStatement(base, annotation);
    }

    static class LogLevelStatement
    extends Statement {
        private final Statement delegate;
        private final LogLevel annotation;

        protected LogLevelStatement(Statement delegate, LogLevel annotation) {
            this.delegate = delegate;
            this.annotation = annotation;
        }

        @SuppressForbidden(reason="Using the Level class from log4j2 directly")
        public void evaluate() throws Throwable {
            Map<String, Level> savedLogLevels = LogLevel.Configurer.setLevels(this.annotation.value());
            try {
                this.delegate.evaluate();
            }
            finally {
                LogLevel.Configurer.restoreLogLevels(savedLogLevels);
            }
        }
    }
}

