/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.File;
import java.net.URL;
import org.apache.solr.common.SolrException;

public class ExternalPaths {
    public static final String SOURCE_HOME = ExternalPaths.determineSourceHome();
    public static String WEBAPP_HOME = new File(SOURCE_HOME, "webapp/web").getAbsolutePath();
    public static String DEFAULT_CONFIGSET = new File(SOURCE_HOME, "server/solr/configsets/_default/conf").getAbsolutePath();
    public static String TECHPRODUCTS_CONFIGSET = new File(SOURCE_HOME, "server/solr/configsets/sample_techproducts_configs/conf").getAbsolutePath();
    public static String SERVER_HOME = new File(SOURCE_HOME, "server/solr").getAbsolutePath();

    static String determineSourceHome() {
        try {
            File base;
            File file = new File("solr/conf");
            if (!file.exists()) {
                URL resourceUrl = ExternalPaths.class.getClassLoader().getResource("solr/conf");
                file = resourceUrl != null ? new File(resourceUrl.toURI()) : new File(System.getProperty("tests.src.home", "."));
            }
            for (base = file.getAbsoluteFile(); !new File(base, "solr/test-framework/build.gradle").exists() && null != base; base = base.getParentFile()) {
            }
            return null == base ? null : new File(base, "solr/").getAbsolutePath();
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to determine source home", (Throwable)e);
        }
    }
}

