/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.SimpleFloatFunction;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.ValueSourceParser;

public class NvlValueSourceParser
extends ValueSourceParser {
    private float nvlFloatValue = 0.0f;

    public ValueSource parse(FunctionQParser fp) throws SyntaxError {
        ValueSource source = fp.parseValueSource();
        final float nvl = fp.parseFloat().floatValue();
        return new SimpleFloatFunction(source){

            protected String name() {
                return "nvl";
            }

            protected float func(int doc, FunctionValues vals) throws IOException {
                float v = vals.floatVal(doc);
                if (v == NvlValueSourceParser.this.nvlFloatValue) {
                    return nvl;
                }
                return v;
            }
        };
    }

    public void init(NamedList<?> args) {
        Float nvlFloatValueArg = (Float)args.get("nvlFloatValue");
        if (nvlFloatValueArg != null) {
            this.nvlFloatValue = nvlFloatValueArg.floatValue();
        }
    }
}

