/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.solr.search.QueryLimit;
import org.apache.solr.search.QueryLimits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallerSpecificQueryLimit
implements QueryLimit {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final StackWalker stackWalker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private final Map<String, Set<String>> interestingCallers = new HashMap<String, Set<String>>();
    private final Map<String, Integer> maxCounts = new HashMap<String, Integer>();
    private final Map<String, AtomicInteger> callCounts = new HashMap<String, AtomicInteger>();
    private Set<String> trippedBy = new LinkedHashSet<String>();

    public CallerSpecificQueryLimit(String ... callerExprs) {
        this(callerExprs != null ? Arrays.asList(callerExprs) : List.of());
    }

    public CallerSpecificQueryLimit(Collection<String> callerExprs) {
        for (String callerExpr : callerExprs) {
            String[] exprCount = callerExpr.split(":");
            if (exprCount.length > 2) {
                throw new RuntimeException("Invalid count in callerExpr: " + callerExpr);
            }
            String[] clazzMethod = exprCount[0].split("\\.");
            if (clazzMethod.length > 2) {
                throw new RuntimeException("Invalid method in callerExpr: " + callerExpr);
            }
            Set methods = this.interestingCallers.computeIfAbsent(clazzMethod[0], c -> new HashSet());
            if (clazzMethod.length > 1) {
                methods.add(clazzMethod[1]);
            }
            if (exprCount.length <= 1) continue;
            try {
                int count = Integer.parseInt(exprCount[1]);
                this.maxCounts.put(exprCount[0], count);
                this.callCounts.put(exprCount[0], new AtomicInteger(0));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Invalid count in callerExpr: " + callerExpr, e);
            }
        }
    }

    public Set<String> getTrippedBy() {
        return this.trippedBy;
    }

    public Map<String, Integer> getCallCounts() {
        return this.callCounts.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey() + (String)(this.maxCounts.containsKey(e.getKey()) ? ":" + String.valueOf(this.maxCounts.get(e.getKey())) : ""), e -> ((AtomicInteger)e.getValue()).get()));
    }

    public boolean shouldExit() {
        Optional matchingExpr = this.stackWalker.walk(s -> s.filter(frame -> {
            Class<?> declaring = frame.getDeclaringClass();
            if (declaring == this.getClass() || declaring == QueryLimits.class) {
                return false;
            }
            String method = frame.getMethodName();
            if (this.interestingCallers.isEmpty()) {
                String expr = declaring.getSimpleName() + "." + method;
                if (log.isInfoEnabled()) {
                    log.info("++++ Limit tripped by any first caller: {} ++++", (Object)expr);
                }
                this.trippedBy.add(expr);
                this.callCounts.computeIfAbsent(expr, k -> new AtomicInteger()).incrementAndGet();
                return true;
            }
            Set<String> methods = this.interestingCallers.get(declaring.getSimpleName());
            if (methods == null) {
                return false;
            }
            if (methods.isEmpty() || methods.contains(method)) {
                Object expr = declaring.getSimpleName();
                if (methods.contains(method)) {
                    expr = (String)expr + "." + method;
                } else {
                    this.callCounts.computeIfAbsent(declaring.getSimpleName() + "." + method, k -> new AtomicInteger(0)).incrementAndGet();
                }
                int currentCount = this.callCounts.computeIfAbsent((String)expr, k -> new AtomicInteger(0)).incrementAndGet();
                if (this.maxCounts.containsKey(expr)) {
                    int maxCount = this.maxCounts.getOrDefault(expr, 0);
                    if (maxCount < 0) {
                        maxCount = Integer.MAX_VALUE;
                    }
                    if (currentCount > maxCount) {
                        if (log.isInfoEnabled()) {
                            log.info("++++ Limit tripped by caller: {}, current count: {}, max: {} ++++", new Object[]{expr, currentCount, this.maxCounts.get(expr)});
                        }
                        this.trippedBy.add((String)expr + ":" + String.valueOf(this.maxCounts.get(expr)));
                        return true;
                    }
                    return false;
                }
                this.trippedBy.add((String)expr);
                if (log.isInfoEnabled()) {
                    log.info("++++ Limit tripped by caller: {} ++++", expr);
                }
                return true;
            }
            return false;
        }).map(frame -> (frame.getDeclaringClass().getSimpleName().isBlank() ? frame.getClassName() : frame.getDeclaringClass().getSimpleName()) + "." + frame.getMethodName()).findFirst());
        return matchingExpr.isPresent();
    }

    public Object currentValue() {
        return "This class just for testing, not a real limit";
    }
}

