/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.BaseDistributedSearchTestCase;
import org.apache.solr.JSONTestUtil;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.StreamingUpdateRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.Group;
import org.apache.solr.client.solrj.response.GroupCommand;
import org.apache.solr.client.solrj.response.GroupResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.cloud.AbstractFullDistribZkTestBase;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.embedded.JettySolrRunner;
import org.apache.solr.util.TestInjection;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBasicDistributedZkTestBase
extends AbstractFullDistribZkTestBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String DEFAULT_COLLECTION = "collection1";
    private final boolean onlyLeaderIndexes = AbstractBasicDistributedZkTestBase.random().nextBoolean();
    String tsort = "t_sortable";
    private Map<String, List<SolrClient>> otherCollectionClients = new HashMap<String, List<SolrClient>>();
    private String oneInstanceCollection = "oneInstanceCollection";
    private String oneInstanceCollection2 = "oneInstanceCollection2";
    private AtomicInteger nodeCounter = new AtomicInteger();
    CompletionService<Object> completionService;
    Set<Future<Object>> pending;
    private static TestInjection.Hook newSearcherHook = new TestInjection.Hook(){
        volatile CountDownLatch latch;
        AtomicReference<String> collection = new AtomicReference();

        public void newSearcher(String collectionName) {
            String c = this.collection.get();
            if (c != null && c.equals(collectionName)) {
                log.info("Hook detected newSearcher");
                try {
                    this.latch.countDown();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }

        public void waitForSearcher(String collection, int cnt, int timeoutms, boolean failOnTimeout) throws InterruptedException {
            boolean timeout;
            this.latch = new CountDownLatch(cnt);
            this.collection.set(collection);
            boolean bl = timeout = !this.latch.await(timeoutms, TimeUnit.MILLISECONDS);
            if (timeout && failOnTimeout) {
                Assert.fail((String)("timed out waiting for new searcher event " + this.latch.getCount()));
            }
        }
    };

    public AbstractBasicDistributedZkTestBase() {
        if (Boolean.getBoolean("solr.tests.numeric.points")) {
            System.setProperty("solr.tests.numeric.dv", "true");
        }
        this.sliceCount = 2;
        this.completionService = new ExecutorCompletionService<Object>(this.executor);
        this.pending = new HashSet<Future<Object>>();
    }

    @BeforeClass
    public static void beforeBDZKTClass() {
        TestInjection.newSearcherHook((TestInjection.Hook)newSearcherHook);
    }

    @Override
    protected boolean useTlogReplicas() {
        return false;
    }

    @Override
    protected void setDistributedParams(ModifiableSolrParams params) {
        if (!r.nextBoolean()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.getShardCount(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append("shard" + (i + 3));
            }
            params.set("shards", new String[]{sb.toString()});
        }
    }

    @Test
    @BaseDistributedSearchTestCase.ShardsFixed(num=4)
    protected void test() throws Exception {
        int i;
        ZkStateReader zkStateReader = ZkStateReader.from((CloudSolrClient)this.cloudClient);
        for (int j = 1; j < this.sliceCount; ++j) {
            zkStateReader.getLeaderRetry(DEFAULT_COLLECTION, "shard" + j, 10000);
        }
        this.waitForRecoveriesToFinish(false);
        this.handle.clear();
        this.handle.put("timestamp", 4);
        this.del("*:*");
        this.queryAndCompareShards((SolrParams)AbstractBasicDistributedZkTestBase.params("q", "*:*", "distrib", "false", "sanity_check", "is_empty"));
        int foo_i_counter = 0;
        for (SolrClient client : this.clients) {
            this.indexDoc(client, (SolrParams)AbstractBasicDistributedZkTestBase.params("commit", "true"), AbstractBasicDistributedZkTestBase.sdoc(this.id, 1, this.i1, 100, this.tlong, 100, "foo_i", ++foo_i_counter));
            this.queryAndCompareShards((SolrParams)AbstractBasicDistributedZkTestBase.params("q", "id:1", "distrib", "false", "sanity_check", "non_distrib_id_1_lookup"));
            this.queryAndCompareShards((SolrParams)AbstractBasicDistributedZkTestBase.params("q", "id:1", "sanity_check", "distrib_id_1_lookup"));
        }
        this.indexr(this.id, 1, this.i1, 100, this.tlong, 100, this.t1, "now is the time for all good men", "foo_f", Float.valueOf(1.414f), "foo_b", "true", "foo_d", 1.414, this.tsort, "now is the time for all good men");
        this.indexr(this.id, 2, this.i1, 50, this.tlong, 50, this.t1, "to come to the aid of their country.", this.tsort, "to come to the aid of their country.");
        this.indexr(this.id, 3, this.i1, 2, this.tlong, 2, this.t1, "how now brown cow", this.tsort, "how now brown cow");
        this.indexr(this.id, 4, this.i1, -100, this.tlong, 101, this.t1, "the quick fox jumped over the lazy dog", this.tsort, "the quick fox jumped over the lazy dog");
        this.indexr(this.id, 5, this.i1, 500, this.tlong, 500, this.t1, "the quick fox jumped way over the lazy dog", this.tsort, "the quick fox jumped over the lazy dog");
        this.indexr(this.id, 6, this.i1, -600, this.tlong, 600, this.t1, "humpty dumpy sat on a wall", this.tsort, "the quick fox jumped over the lazy dog");
        this.indexr(this.id, 7, this.i1, 123, this.tlong, 123, this.t1, "humpty dumpy had a great fall", this.tsort, "the quick fox jumped over the lazy dog");
        this.indexr(this.id, 8, this.i1, 876, this.tlong, 876, this.t1, "all the kings horses and all the kings men", this.tsort, "all the kings horses and all the kings men");
        this.indexr(this.id, 9, this.i1, 7, this.tlong, 7, this.t1, "couldn't put humpty together again", this.tsort, "the quick fox jumped over the lazy dog");
        this.indexr(this.id, 10, this.i1, 4321, this.tlong, 4321, this.t1, "this too shall pass", this.tsort, "this too shall pass");
        this.indexr(this.id, 11, this.i1, -987, this.tlong, 987, this.t1, "An eye for eye only ends up making the whole world blind.", this.tsort, "An eye for eye only ends up making the whole world blind.");
        this.indexr(this.id, 12, this.i1, 379, this.tlong, 379, this.t1, "Great works are performed, not by strength, but by perseverance.", this.tsort, "Great works are performed, not by strength, but by perseverance.");
        this.indexr(this.id, 13, this.i1, 232, this.tlong, 232, this.t1, "no eggs on wall, lesson learned", this.oddField, "odd man out", this.tsort, "no eggs on wall, lesson learned");
        this.indexr(this.id, 14, "SubjectTerms_mfacet", new String[]{"mathematical models", "mathematical analysis"});
        this.indexr(this.id, 15, "SubjectTerms_mfacet", new String[]{"test 1", "test 2", "test3"});
        this.indexr(this.id, 16, "SubjectTerms_mfacet", new String[]{"test 1", "test 2", "test3"});
        String[] vals = new String[100];
        for (i = 0; i < 100; ++i) {
            vals[i] = "test " + i;
        }
        this.indexr(this.id, 17, "SubjectTerms_mfacet", vals);
        for (i = 100; i < 150; ++i) {
            this.indexr(this.id, i);
        }
        this.commit();
        this.testTokenizedGrouping();
        this.testSortableTextFaceting();
        this.testSortableTextSorting();
        this.testSortableTextGrouping();
        this.queryAndCompareShards((SolrParams)AbstractBasicDistributedZkTestBase.params("q", "*:*", "sort", "id desc", "distrib", "false", "sanity_check", "is_empty"));
        for (String f : fieldNames) {
            this.query(false, (Object[])new String[]{"q", "*:*", "sort", f + " desc"});
            this.query(false, (Object[])new String[]{"q", "*:*", "sort", f + " asc"});
        }
        this.query(false, (Object[])new String[]{"q", "*:*", "sort", this.i1 + " desc"});
        this.query(false, (Object[])new String[]{"q", "*:*", "sort", this.i1 + " asc"});
        this.query(false, (Object[])new String[]{"q", "*:*", "sort", this.i1 + " desc", "fl", "*,score"});
        this.query(false, (Object[])new String[]{"q", "*:*", "sort", "n_tl1 asc", "fl", "*,score"});
        this.query(false, (Object[])new String[]{"q", "*:*", "sort", "n_tl1 desc"});
        this.handle.put("maxScore", 4);
        this.query(false, (Object[])new String[]{"q", "{!func}" + this.i1});
        this.handle.remove("maxScore");
        this.query(false, (Object[])new String[]{"q", "{!func}" + this.i1, "fl", "*,score"});
        this.handle.put("highlighting", 8);
        this.handle.put("response", 8);
        this.handle.put("maxScore", 4);
        this.query(false, (Object[])new String[]{"q", "quick"});
        this.query(false, (Object[])new String[]{"q", "all", "fl", "id", "start", "0"});
        this.query(false, (Object[])new String[]{"q", "all", "fl", "foofoofoo", "start", "0"});
        this.query(false, (Object[])new String[]{"q", "all", "fl", "id", "start", "100"});
        this.handle.put("score", 4);
        this.query(false, (Object[])new String[]{"q", "quick", "fl", "*,score"});
        this.query(false, (Object[])new String[]{"q", "all", "fl", "*,score", "start", "1"});
        this.query(false, (Object[])new String[]{"q", "all", "fl", "*,score", "start", "100"});
        this.query(false, (Object[])new String[]{"q", "now their fox sat had put", "fl", "*,score", "hl", "true", "hl.fl", this.t1});
        this.query(false, (Object[])new String[]{"q", "now their fox sat had put", "fl", "foofoofoo", "hl", "true", "hl.fl", this.t1});
        this.query(false, (Object[])new String[]{"q", "matchesnothing", "fl", "*,score"});
        this.query(false, new Object[]{"q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1});
        this.query(false, new Object[]{"q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.limit", -1, "facet.sort", "count"});
        this.query(false, new Object[]{"q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.limit", -1, "facet.sort", "count", "facet.mincount", 2});
        this.query(false, new Object[]{"q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.limit", -1, "facet.sort", "index"});
        this.query(false, new Object[]{"q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.limit", -1, "facet.sort", "index", "facet.mincount", 2});
        this.query(false, new Object[]{"q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.limit", 1});
        this.query(false, new Object[]{"q", "*:*", "rows", 100, "facet", "true", "facet.query", "quick", "facet.query", "all", "facet.query", "*:*"});
        this.query(false, new Object[]{"q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.offset", 1});
        this.query(false, new Object[]{"q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.mincount", 2});
        this.query(false, new Object[]{"q", "*:*", "rows", 100, "facet", "true", "facet.query", "quick", "facet.query", "all", "facet.query", "*:*", "facet.field", this.t1});
        this.query(false, new Object[]{"q", "*:*", "rows", 100, "facet", "true", "facet.query", "{!key=myquick}quick", "facet.query", "{!key=myall ex=a}all", "facet.query", "*:*", "facet.field", "{!key=mykey ex=a}" + this.t1, "facet.field", "{!key=other ex=b}" + this.t1, "facet.field", "{!key=again ex=a,b}" + this.t1, "facet.field", this.t1, "fq", "{!tag=a}id_i1:[1 TO 7]", "fq", "{!tag=b}id_i1:[3 TO 9]"});
        this.query(false, new Object[]{"q", "*:*", "facet", "true", "facet.field", "{!ex=t1}SubjectTerms_mfacet", "fq", "{!tag=t1}SubjectTerms_mfacet:(test 1)", "facet.limit", "10", "facet.mincount", "1"});
        this.query(false, new Object[]{"q", "*:*", "rows", 100, "facet", "true", "facet.field", this.missingField, "facet.mincount", 2});
        this.query(false, new Object[]{"q", "*:*", "rows", 100, "facet", "true", "facet.field", this.oddField, "facet.mincount", 2});
        this.query(false, new Object[]{"q", "*:*", "sort", this.i1 + " desc", "stats", "true", "stats.field", this.i1});
        this.handle.put("facet_fields", 4);
        this.query(false, new Object[]{"q", "*:*", "rows", 0, "facet", "true", "facet.field", this.t1, "facet.limit", 5, "facet.shard.limit", 5});
        this.query(false, new Object[]{"q", "*:*", "rows", 0, "facet", "true", "facet.field", "{!key='a b/c \\' \\} foo'}" + this.t1, "facet.limit", 5, "facet.shard.limit", 5});
        this.handle.remove("facet_fields");
        if (this.clients.size() >= 2) {
            this.index(this.id, 100, this.i1, 107, this.t1, "oh no, a duplicate!");
            for (int i2 = 0; i2 < this.clients.size(); ++i2) {
                this.index_specific(i2, this.id, 100, this.i1, 107, this.t1, "oh no, a duplicate!");
            }
            this.commit();
            this.query(false, new Object[]{"q", "duplicate", "hl", "true", "hl.fl", this.t1});
            this.query(false, new Object[]{"q", "fox duplicate horses", "hl", "true", "hl.fl", this.t1});
            this.query(false, new Object[]{"q", "*:*", "rows", 100});
        }
        this.handle.put("explain", 4);
        this.handle.put("debug", 8);
        this.handle.put("time", 4);
        this.handle.put("track", 2);
        this.query(false, new Object[]{"q", "now their fox sat had put", "fl", "*,score", "debugQuery", "true"});
        this.query(false, new Object[]{"q", "id_i1:[1 TO 5]", "debugQuery", "true"});
        this.query(false, new Object[]{"q", "id_i1:[1 TO 5]", "debug", "timing"});
        this.query(false, new Object[]{"q", "id_i1:[1 TO 5]", "debug", "results"});
        this.query(false, new Object[]{"q", "id_i1:[1 TO 5]", "debug", "query"});
        long before = this.cloudClient.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound();
        for (SolrClient client : this.clients) {
            AbstractBasicDistributedZkTestBase.assertEquals((String)("unexpected pre-commitWithin document count on node: " + ((HttpSolrClient)client).getBaseURL()), (long)before, (long)client.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound());
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("commitWithin", 10);
        this.add((SolrClient)this.cloudClient, (SolrParams)params, List.of(AbstractBasicDistributedZkTestBase.getDoc("id", 300), AbstractBasicDistributedZkTestBase.getDoc("id", 301)));
        newSearcherHook.waitForSearcher(DEFAULT_COLLECTION, 2, 20000, false);
        ClusterState clusterState = this.getCommonCloudSolrClient().getClusterState();
        DocCollection dColl = clusterState.getCollection(DEFAULT_COLLECTION);
        this.assertSliceCounts("should have found 2 docs, 300 and 301", before + 2L, dColl);
        UpdateRequest deleteByIdReq = new UpdateRequest();
        deleteByIdReq.deleteById("300");
        deleteByIdReq.setCommitWithin(10);
        deleteByIdReq.process((SolrClient)this.cloudClient);
        newSearcherHook.waitForSearcher(DEFAULT_COLLECTION, 2, 20000, false);
        this.assertSliceCounts("deleteById commitWithin did not work", before + 1L, dColl);
        UpdateRequest deleteByQueryReq = new UpdateRequest();
        deleteByQueryReq.deleteByQuery("id:301");
        deleteByQueryReq.setCommitWithin(10);
        deleteByQueryReq.process((SolrClient)this.cloudClient);
        newSearcherHook.waitForSearcher(DEFAULT_COLLECTION, 2, 20000, false);
        this.assertSliceCounts("deleteByQuery commitWithin did not work", before, dColl);
        this.doOptimisticLockingAndUpdating();
        this.testShardParamVariations();
        this.testMultipleCollections();
        this.testANewCollectionInOneInstance();
        this.testSearchByCollectionName();
        this.testUpdateByCollectionName();
        this.testANewCollectionInOneInstanceWithManualShardAssignement();
        this.testNumberOfCommitsWithCommitAfterAdd();
        this.testUpdateProcessorsRunOnlyOnce("distrib-dup-test-chain-explicit");
        this.testUpdateProcessorsRunOnlyOnce("distrib-dup-test-chain-implicit");
        this.testStopAndStartCoresInOneInstance();
    }

    private void testSortableTextFaceting() throws Exception {
        SolrQuery query = new SolrQuery("*:*");
        query.addFacetField(new String[]{this.tsort});
        query.setFacetMissing(Boolean.valueOf(false));
        QueryResponse resp = this.queryServer((ModifiableSolrParams)query);
        List ffs = resp.getFacetFields();
        for (FacetField ff : ffs) {
            if (!ff.getName().equals(this.tsort)) continue;
            block16: for (FacetField.Count count : ff.getValues()) {
                long num = count.getCount();
                switch (count.getName()) {
                    case "all the kings horses and all the kings men": 
                    case "An eye for eye only ends up making the whole world blind.": 
                    case "Great works are performed, not by strength, but by perseverance.": 
                    case "how now brown cow": 
                    case "no eggs on wall, lesson learned": 
                    case "now is the time for all good men": 
                    case "this too shall pass": 
                    case "to come to the aid of their country.": {
                        AbstractBasicDistributedZkTestBase.assertEquals((String)("Should have exactly one facet count for field " + ff.getName()), (long)1L, (long)num);
                        continue block16;
                    }
                    case "the quick fox jumped over the lazy dog": {
                        AbstractBasicDistributedZkTestBase.assertEquals((String)"Should have 5 docs for the lazy dog", (long)5L, (long)num);
                        continue block16;
                    }
                }
                AbstractBasicDistributedZkTestBase.fail((String)("No case for facet '" + ff.getName() + "'"));
            }
        }
    }

    private void testSortableTextSorting() throws Exception {
        SolrQuery query = new SolrQuery("*:*");
        query.addSort(this.tsort, SolrQuery.ORDER.desc);
        query.addField("*");
        query.addField("eoe_sortable");
        query.addField(this.tsort);
        QueryResponse resp = this.queryServer((ModifiableSolrParams)query);
        SolrDocumentList docs = resp.getResults();
        String title = ((SolrDocument)docs.get(0)).getFieldValue(this.tsort).toString();
        for (SolrDocument doc : docs) {
            AbstractBasicDistributedZkTestBase.assertTrue((String)"Docs should be back in sorted order, descending", (title.compareTo(doc.getFieldValue(this.tsort).toString()) >= 0 ? 1 : 0) != 0);
            title = doc.getFieldValue(this.tsort).toString();
        }
    }

    private void testSortableTextGrouping() throws Exception {
        SolrQuery query = new SolrQuery("*:*");
        query.add("group", new String[]{"true"});
        query.add("group.field", new String[]{this.tsort});
        QueryResponse resp = this.queryServer((ModifiableSolrParams)query);
        GroupResponse groupResp = resp.getGroupResponse();
        List grpCmds = groupResp.getValues();
        for (GroupCommand grpCmd : grpCmds) {
            if (!grpCmd.getName().equals(this.tsort)) continue;
            block16: for (Group grp : grpCmd.getValues()) {
                long count = grp.getResult().getNumFound();
                if (grp.getGroupValue() == null) continue;
                switch (grp.getGroupValue()) {
                    case "all the kings horses and all the kings men": 
                    case "An eye for eye only ends up making the whole world blind.": 
                    case "Great works are performed, not by strength, but by perseverance.": 
                    case "how now brown cow": 
                    case "no eggs on wall, lesson learned": 
                    case "now is the time for all good men": 
                    case "this too shall pass": 
                    case "to come to the aid of their country.": {
                        AbstractBasicDistributedZkTestBase.assertEquals((String)("Should have exactly one facet count for field " + grpCmd.getName()), (long)1L, (long)count);
                        continue block16;
                    }
                    case "the quick fox jumped over the lazy dog": {
                        AbstractBasicDistributedZkTestBase.assertEquals((String)"Should have 5 docs for the lazy dog", (long)5L, (long)count);
                        continue block16;
                    }
                }
                AbstractBasicDistributedZkTestBase.fail((String)("No case for facet '" + grpCmd.getName() + "'"));
            }
        }
    }

    private void testTokenizedGrouping() throws Exception {
        SolrException ex = (SolrException)AbstractBasicDistributedZkTestBase.expectThrows(SolrException.class, () -> this.query(false, (Object[])new String[]{"q", "*:*", "group", "true", "group.field", this.t1}));
        AbstractBasicDistributedZkTestBase.assertTrue((String)"Expected error from server that SortableTextFields are required", (boolean)ex.getMessage().contains("Sorting on a tokenized field that is not a SortableTextField is not supported in cloud mode"));
    }

    private void assertSliceCounts(String msg, long expected, DocCollection dColl) throws Exception {
        long found = this.checkSlicesSameCounts(dColl);
        if (found != expected) {
            Thread.sleep(1000L);
            found = this.checkSlicesSameCounts(dColl);
        }
        AbstractBasicDistributedZkTestBase.assertEquals((String)msg, (long)expected, (long)this.checkSlicesSameCounts(dColl));
    }

    private void waitForDocCount(long expectedNumFound, long waitMillis, String failureMessage) throws Exception {
        AtomicLong total = new AtomicLong(-1L);
        try {
            ZkStateReader.from((CloudSolrClient)this.getCommonCloudSolrClient()).waitForState(DEFAULT_COLLECTION, waitMillis, TimeUnit.MILLISECONDS, (n, c) -> {
                long docTotal;
                try {
                    docTotal = this.checkSlicesSameCounts(c);
                }
                catch (IOException | SolrServerException e) {
                    throw new RuntimeException(e);
                }
                total.set(docTotal);
                return docTotal == expectedNumFound;
            });
        }
        catch (InterruptedException | TimeoutException exception) {
            // empty catch block
        }
        AbstractBasicDistributedZkTestBase.assertEquals((String)failureMessage, (long)expectedNumFound, (long)total.get());
        for (SolrClient client : this.clients) {
            AbstractBasicDistributedZkTestBase.assertEquals((String)failureMessage, (long)expectedNumFound, (long)client.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound());
        }
    }

    private long checkSlicesSameCounts(DocCollection dColl) throws SolrServerException, IOException {
        long docTotal = 0L;
        for (Slice slice : dColl.getActiveSlices()) {
            long sliceDocCount = -1L;
            for (Replica rep : slice.getReplicas()) {
                HttpSolrClient one = AbstractBasicDistributedZkTestBase.getHttpSolrClient(rep);
                try {
                    SolrQuery query = new SolrQuery("*:*");
                    query.setDistrib(false);
                    QueryResponse resp = one.query((SolrParams)query);
                    long hits = resp.getResults().getNumFound();
                    if (sliceDocCount == -1L) {
                        sliceDocCount = hits;
                        docTotal += hits;
                        continue;
                    }
                    if (hits == sliceDocCount) continue;
                    long l = -1L;
                    return l;
                }
                finally {
                    if (one == null) continue;
                    one.close();
                }
            }
        }
        return docTotal;
    }

    private void testShardParamVariations() throws Exception {
        SolrQuery query = new SolrQuery("*:*");
        HashMap<String, Long> shardCounts = new HashMap<String, Long>();
        for (String shard : this.shardToJetty.keySet()) {
            ArrayList solrclients = new ArrayList(this.clients);
            Collections.shuffle(solrclients, AbstractBasicDistributedZkTestBase.random());
            for (SolrClient solrClient : solrclients) {
                query.set("shards", new String[]{shard});
                long numDocs = solrClient.query((SolrParams)query).getResults().getNumFound();
                AbstractBasicDistributedZkTestBase.assertTrue((String)("numDocs < 0 for shard " + shard + " via " + String.valueOf(solrClient)), (0L <= numDocs ? 1 : 0) != 0);
                if (!shardCounts.containsKey(shard)) {
                    shardCounts.put(shard, numDocs);
                }
                AbstractBasicDistributedZkTestBase.assertEquals((String)("inconsitent numDocs for shard " + shard + " via " + String.valueOf(solrClient)), (long)((Long)shardCounts.get(shard)), (long)numDocs);
                ArrayList replicaJetties = new ArrayList((Collection)this.shardToJetty.get(shard));
                Collections.shuffle(replicaJetties, AbstractBasicDistributedZkTestBase.random());
                ArrayList<String> replicaAlts = new ArrayList<String>(replicaJetties.size() * 2);
                for (AbstractFullDistribZkTestBase.CloudJettyRunner replicaJetty : (List)this.shardToJetty.get(shard)) {
                    String replica = replicaJetty.url;
                    query.set("shards", new String[]{replica});
                    if (0 == AbstractBasicDistributedZkTestBase.random().nextInt(3) || replicaAlts.size() < 2) {
                        replicaAlts.add(replica);
                    }
                    numDocs = solrClient.query((SolrParams)query).getResults().getNumFound();
                    AbstractBasicDistributedZkTestBase.assertTrue((String)("numDocs < 0 for replica " + replica + " via " + String.valueOf(solrClient)), (0L <= numDocs ? 1 : 0) != 0);
                    AbstractBasicDistributedZkTestBase.assertEquals((String)("inconsitent numDocs for shard " + shard + " in replica " + replica + " via " + String.valueOf(solrClient)), (long)((Long)shardCounts.get(shard)), (long)numDocs);
                }
                String replicas = String.join((CharSequence)"|", replicaAlts);
                query.set("shards", new String[]{replicas});
                numDocs = solrClient.query((SolrParams)query).getResults().getNumFound();
                AbstractBasicDistributedZkTestBase.assertTrue((String)("numDocs < 0 for replicas " + replicas + " via " + String.valueOf(solrClient)), (0L <= numDocs ? 1 : 0) != 0);
                AbstractBasicDistributedZkTestBase.assertEquals((String)("inconsitent numDocs for replicas " + replicas + " via " + String.valueOf(solrClient)), (long)((Long)shardCounts.get(shard)), (long)numDocs);
            }
        }
        long randomShardCountsExpected = 0L;
        ArrayList<String> randomShards = new ArrayList<String>(shardCounts.size());
        for (Map.Entry entry : shardCounts.entrySet()) {
            if (!AbstractBasicDistributedZkTestBase.random().nextBoolean() && randomShards.size() >= 2) continue;
            String shard = (String)entry.getKey();
            randomShardCountsExpected += ((Long)entry.getValue()).longValue();
            if (AbstractBasicDistributedZkTestBase.random().nextBoolean()) {
                randomShards.add(shard);
                continue;
            }
            ArrayList<String> replicas = new ArrayList<String>(7);
            for (AbstractFullDistribZkTestBase.CloudJettyRunner replicaJetty : (List)this.shardToJetty.get(shard)) {
                if (0 != AbstractBasicDistributedZkTestBase.random().nextInt(3) && 0 != replicas.size()) continue;
                replicas.add(replicaJetty.url);
            }
            Collections.shuffle(replicas, AbstractBasicDistributedZkTestBase.random());
            randomShards.add(String.join((CharSequence)"|", replicas));
        }
        String randShards = String.join((CharSequence)",", randomShards);
        query.set("shards", new String[]{randShards});
        for (SolrClient client : this.clients) {
            AbstractBasicDistributedZkTestBase.assertEquals((String)("numDocs for " + randShards + " via " + String.valueOf(client)), (long)randomShardCountsExpected, (long)client.query((SolrParams)query).getResults().getNumFound());
        }
        query = new SolrQuery("*:*");
        long l = 0L;
        for (Long c : shardCounts.values()) {
            l += c.longValue();
        }
        for (SolrClient client : this.clients) {
            AbstractBasicDistributedZkTestBase.assertEquals((String)("sum of shard numDocs on client: " + String.valueOf(client)), (long)l, (long)client.query((SolrParams)query).getResults().getNumFound());
        }
        AbstractBasicDistributedZkTestBase.assertTrue((String)"total numDocs <= 0, WTF? Test is useless", (0L < l ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void testStopAndStartCoresInOneInstance() throws Exception {
        block11: {
            JettySolrRunner jetty = (JettySolrRunner)this.jettys.get(0);
            try (HttpSolrClient httpSolrClient = (HttpSolrClient)jetty.newClient(15000, 60000);){
                ExecutorUtil.MDCAwareThreadPoolExecutor executor = null;
                try {
                    executor = new ExecutorUtil.MDCAwareThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue(), (ThreadFactory)new SolrNamedThreadFactory("testExecutor"));
                    int cnt = 3;
                    AbstractBasicDistributedZkTestBase.createCollectionInOneInstance((SolrClient)httpSolrClient, jetty.getNodeName(), (ThreadPoolExecutor)executor, "multiunload2", 1, cnt);
                    if (executor == null) break block11;
                }
                catch (Throwable throwable) {
                    if (executor != null) {
                        ExecutorUtil.shutdownAndAwaitTermination(executor);
                    }
                    throw throwable;
                }
                ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)executor);
            }
        }
        ((AbstractFullDistribZkTestBase.CloudJettyRunner)this.cloudJettys.get((int)0)).jetty.stop();
        this.printLayout();
        ((AbstractFullDistribZkTestBase.CloudJettyRunner)this.cloudJettys.get((int)0)).jetty.start();
        ZkStateReader.from((CloudSolrClient)this.cloudClient).forceUpdateCollection("multiunload2");
        try {
            ZkStateReader.from((CloudSolrClient)this.cloudClient).getLeaderRetry("multiunload2", "shard1", 30000);
        }
        catch (SolrException e) {
            this.printLayout();
            throw e;
        }
        this.printLayout();
    }

    public static void createCollectionInOneInstance(SolrClient client, String nodeName, ThreadPoolExecutor executor, String collection, int numShards, int numReplicas) {
        AbstractBasicDistributedZkTestBase.assertNotNull((Object)nodeName);
        try {
            AbstractBasicDistributedZkTestBase.assertEquals((long)0L, (long)((CollectionAdminResponse)CollectionAdminRequest.createCollection((String)collection, (String)"conf1", (int)numShards, (int)1).setCreateNodeSet("").process(client)).getStatus());
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e);
        }
        int i = 0;
        while (i < numReplicas) {
            int freezeI = i++;
            executor.execute(() -> {
                try {
                    AbstractBasicDistributedZkTestBase.assertTrue((boolean)((CollectionAdminResponse)CollectionAdminRequest.addReplicaToShard((String)collection, (String)("shard" + (freezeI % numShards + 1))).setCoreName(collection + freezeI).setNode(nodeName).process(client)).isSuccess());
                }
                catch (IOException | SolrServerException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    @Override
    protected CollectionAdminResponse createCollection(Map<String, List<Integer>> collectionInfos, String collectionName, String configSetName, int numShards, int numReplicas, SolrClient client, String createNodeSetStr) throws SolrServerException, IOException {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{CollectionParams.CollectionAction.CREATE.toString()});
        params.set("numShards", numShards);
        params.set("replicationFactor", numReplicas);
        if (createNodeSetStr != null) {
            params.set("createNodeSet", new String[]{createNodeSetStr});
        }
        int clientIndex = this.clients.size() > 1 ? AbstractBasicDistributedZkTestBase.random().nextInt(2) : 0;
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(numShards);
        list.add(numReplicas);
        if (collectionInfos != null) {
            collectionInfos.put(collectionName, list);
        }
        params.set("name", new String[]{collectionName});
        params.set("collection.configName", new String[]{configSetName});
        QueryRequest request = new QueryRequest((SolrParams)params);
        request.setPath("/admin/collections");
        CollectionAdminResponse res = new CollectionAdminResponse();
        if (client == null) {
            String baseUrl = ((HttpSolrClient)this.clients.get(clientIndex)).getBaseURL();
            try (SolrClient aClient = this.createNewSolrClient("", baseUrl);){
                res.setResponse(aClient.request((SolrRequest)request));
            }
        } else {
            res.setResponse(client.request((SolrRequest)request));
        }
        return res;
    }

    @Override
    protected Replica getLeaderFromZk(String collection, String slice) {
        ClusterState clusterState = this.getCommonCloudSolrClient().getClusterState();
        Replica leader = clusterState.getCollection(collection).getLeader(slice);
        if (leader == null) {
            throw new RuntimeException("Could not find leader:" + collection + " " + slice);
        }
        return leader;
    }

    private void testUpdateProcessorsRunOnlyOnce(String chain) throws Exception {
        int i;
        String fieldA = "regex_dup_A_s";
        String fieldB = "regex_dup_B_s";
        String val = "x";
        String expected = "x_x";
        ModifiableSolrParams updateParams = new ModifiableSolrParams();
        updateParams.add("update.chain", new String[]{chain});
        int numLoops = AbstractBasicDistributedZkTestBase.atLeast((int)50);
        for (i = 1; i < numLoops; ++i) {
            SolrClient updateClient = (SolrClient)this.clients.get(AbstractBasicDistributedZkTestBase.random().nextInt(this.clients.size()));
            SolrInputDocument doc = new SolrInputDocument();
            AbstractBasicDistributedZkTestBase.addFields(doc, this.id, i, "regex_dup_A_s", "x", "regex_dup_B_s", "x");
            UpdateResponse ures = this.add(updateClient, (SolrParams)updateParams, doc);
            AbstractBasicDistributedZkTestBase.assertEquals((String)(chain + ": update failed"), (long)0L, (long)ures.getStatus());
            ures = updateClient.commit();
            AbstractBasicDistributedZkTestBase.assertEquals((String)(chain + ": commit failed"), (long)0L, (long)ures.getStatus());
        }
        for (i = 1; i < numLoops; ++i) {
            String query = this.id + ":" + i;
            QueryResponse qres = this.queryServer((ModifiableSolrParams)new SolrQuery(query));
            AbstractBasicDistributedZkTestBase.assertEquals((String)(chain + ": query failed: " + query), (long)0L, (long)qres.getStatus());
            AbstractBasicDistributedZkTestBase.assertEquals((String)(chain + ": didn't find correct # docs with query: " + query), (long)1L, (long)qres.getResults().getNumFound());
            SolrDocument doc = (SolrDocument)qres.getResults().get(0);
            for (String field : new String[]{"regex_dup_A_s", "regex_dup_B_s"}) {
                AbstractBasicDistributedZkTestBase.assertEquals((String)(chain + ": doc#" + i + " has wrong value for " + field), (Object)"x_x", (Object)doc.getFirstValue(field));
            }
        }
    }

    private void doOptimisticLockingAndUpdating() throws Exception {
        log.info("### STARTING doOptimisticLockingAndUpdating");
        this.printLayout();
        SolrInputDocument sd = AbstractBasicDistributedZkTestBase.sdoc("id", 1000, "_version_", -1);
        this.indexDoc(sd);
        AbstractBasicDistributedZkTestBase.ignoreException("version conflict");
        for (SolrClient client : this.clients) {
            SolrException e = (SolrException)AbstractBasicDistributedZkTestBase.expectThrows(SolrException.class, () -> client.add(sd));
            AbstractBasicDistributedZkTestBase.assertEquals((long)409L, (long)e.code());
        }
        AbstractBasicDistributedZkTestBase.unIgnoreException("version conflict");
        SolrInputDocument sd2 = AbstractBasicDistributedZkTestBase.sdoc("id", 1000, "foo_i", 5);
        ((SolrClient)this.clients.get(0)).add(sd2);
        ArrayList<Integer> expected = new ArrayList<Integer>();
        int val = 0;
        for (SolrClient client : this.clients) {
            client.add(AbstractBasicDistributedZkTestBase.sdoc("id", 1000, "val_i", AbstractBasicDistributedZkTestBase.map("add", val += 10), "foo_i", val));
            expected.add(val);
        }
        QueryRequest qr = new QueryRequest((SolrParams)AbstractBasicDistributedZkTestBase.params("qt", "/get", "id", "1000"));
        for (SolrClient client : this.clients) {
            val += 10;
            NamedList rsp = client.request((SolrRequest)qr);
            String match = JSONTestUtil.matchObj("/val_i", rsp.get("doc"), expected);
            if (match == null) continue;
            throw new RuntimeException(match);
        }
    }

    private void testNumberOfCommitsWithCommitAfterAdd() throws SolrServerException, IOException {
        log.info("### STARTING testNumberOfCommitsWithCommitAfterAdd");
        long startCommits = this.getNumCommits((HttpSolrClient)this.clients.get(0));
        NamedList result = ((SolrClient)this.clients.get(0)).request((SolrRequest)new StreamingUpdateRequest("/update", AbstractBasicDistributedZkTestBase.getFile("books_numeric_ids.csv").toPath(), "application/csv").setCommitWithin(900000).setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true));
        long endCommits = this.getNumCommits((HttpSolrClient)this.clients.get(0));
        AbstractBasicDistributedZkTestBase.assertEquals((long)(startCommits + 1L), (long)endCommits);
    }

    private Long getNumCommits(HttpSolrClient sourceClient) throws SolrServerException, IOException {
        String collection = sourceClient.getDefaultCollection();
        try (HttpSolrClient client = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(sourceClient.getBaseURL()).withConnectionTimeout(15000, TimeUnit.MILLISECONDS)).withSocketTimeout(60000, TimeUnit.MILLISECONDS)).build();){
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("qt", new String[]{"/admin/metrics"});
            params.set("prefix", new String[]{"UPDATE.updateHandler"});
            params.set("registry", new String[]{"solr.core." + collection});
            QueryRequest req = new QueryRequest((SolrParams)params);
            NamedList resp = client.request((SolrRequest)req);
            NamedList metrics = (NamedList)resp.get("metrics");
            NamedList uhandlerCat = (NamedList)metrics.getVal(0);
            Map commits = (Map)uhandlerCat.get("UPDATE.updateHandler.commits");
            Long l = (Long)commits.get("count");
            return l;
        }
    }

    private void testANewCollectionInOneInstanceWithManualShardAssignement() throws Exception {
        log.info("### STARTING testANewCollectionInOneInstanceWithManualShardAssignement");
        AbstractBasicDistributedZkTestBase.assertEquals((long)0L, (long)((CollectionAdminResponse)CollectionAdminRequest.createCollection((String)this.oneInstanceCollection2, (String)"conf1", (int)2, (int)2).setCreateNodeSet("").process((SolrClient)this.cloudClient)).getStatus());
        ArrayList<SolrClient> collectionClients = new ArrayList<SolrClient>();
        for (int i = 0; i < 4; ++i) {
            CollectionAdminResponse resp = (CollectionAdminResponse)CollectionAdminRequest.addReplicaToShard((String)this.oneInstanceCollection2, (String)("shard" + (i % 2 + 1))).setNode(((JettySolrRunner)this.jettys.get(0)).getNodeName()).process((SolrClient)this.cloudClient);
            for (String coreName : resp.getCollectionCoresStatus().keySet()) {
                collectionClients.add(this.createNewSolrClient(coreName, ((JettySolrRunner)this.jettys.get(0)).getBaseUrl().toString()));
            }
        }
        SolrClient client1 = (SolrClient)collectionClients.get(0);
        SolrClient client2 = (SolrClient)collectionClients.get(1);
        SolrClient client3 = (SolrClient)collectionClients.get(2);
        SolrClient client4 = (SolrClient)collectionClients.get(3);
        this.waitForRecoveriesToFinish(this.oneInstanceCollection2, ZkStateReader.from((CloudSolrClient)this.getCommonCloudSolrClient()), false, true);
        AbstractBasicDistributedZkTestBase.assertAllActive(this.oneInstanceCollection2, ZkStateReader.from((CloudSolrClient)this.getCommonCloudSolrClient()));
        client2.add(AbstractBasicDistributedZkTestBase.getDoc(this.id, "1"));
        client3.add(AbstractBasicDistributedZkTestBase.getDoc(this.id, "2"));
        client4.add(AbstractBasicDistributedZkTestBase.getDoc(this.id, "3"));
        client1.commit();
        SolrQuery query = new SolrQuery("*:*");
        query.set("distrib", false);
        long oneDocs = client1.query((SolrParams)query).getResults().getNumFound();
        long twoDocs = client2.query((SolrParams)query).getResults().getNumFound();
        long threeDocs = client3.query((SolrParams)query).getResults().getNumFound();
        long fourDocs = client4.query((SolrParams)query).getResults().getNumFound();
        query.set("collection", new String[]{this.oneInstanceCollection2});
        query.set("distrib", true);
        long allDocs = this.getCommonCloudSolrClient().query((SolrParams)query).getResults().getNumFound();
        AbstractBasicDistributedZkTestBase.assertEquals((long)3L, (long)allDocs);
        ZkStateReader zkStateReader = ZkStateReader.from((CloudSolrClient)this.getCommonCloudSolrClient());
        zkStateReader.forceUpdateCollection(this.oneInstanceCollection2);
        Map slices = zkStateReader.getClusterState().getCollection(this.oneInstanceCollection2).getSlicesMap();
        AbstractBasicDistributedZkTestBase.assertNotNull((Object)slices);
        Replica leader = this.getCommonCloudSolrClient().getClusterState().getCollection(this.oneInstanceCollection2).getLeader("shard1");
        try (HttpSolrClient unloadClient = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(((JettySolrRunner)this.jettys.get(0)).getBaseUrl().toString()).withConnectionTimeout(15000, TimeUnit.MILLISECONDS)).withSocketTimeout(60000, TimeUnit.MILLISECONDS)).build();){
            CoreAdminRequest.Unload unloadCmd = new CoreAdminRequest.Unload(true);
            unloadCmd.setCoreName(leader.getCoreName());
            String leaderUrl = leader.getCoreUrl();
            testExecutor.execute(new Runnable((SolrClient)unloadClient, unloadCmd){
                final /* synthetic */ SolrClient val$unloadClient;
                final /* synthetic */ CoreAdminRequest.Unload val$unloadCmd;
                {
                    this.val$unloadClient = solrClient;
                    this.val$unloadCmd = unload;
                }

                @Override
                public void run() {
                    try {
                        this.val$unloadClient.request((SolrRequest)this.val$unloadCmd);
                    }
                    catch (SolrServerException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            try {
                ZkStateReader.from((CloudSolrClient)this.getCommonCloudSolrClient()).waitForState(this.oneInstanceCollection2, 20000L, TimeUnit.MILLISECONDS, (n, c) -> {
                    try {
                        if (leaderUrl.equals(zkStateReader.getLeaderUrl(this.oneInstanceCollection2, "shard1", 10000))) {
                            return false;
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    return true;
                });
            }
            catch (InterruptedException | TimeoutException e) {
                AbstractBasicDistributedZkTestBase.fail((String)"Leader never changed");
            }
        }
        IOUtils.close(collectionClients);
    }

    private void testSearchByCollectionName() throws SolrServerException, IOException {
        log.info("### STARTING testSearchByCollectionName");
        SolrClient client = (SolrClient)this.clients.get(0);
        String baseUrl = ((HttpSolrClient)client).getBaseURL();
        try (SolrClient client1 = this.createNewSolrClient(this.oneInstanceCollection, baseUrl);){
            SolrQuery query = new SolrQuery("*:*");
            long oneDocs = client1.query((SolrParams)query).getResults().getNumFound();
            AbstractBasicDistributedZkTestBase.assertEquals((long)3L, (long)oneDocs);
        }
    }

    private void testUpdateByCollectionName() throws SolrServerException, IOException {
        log.info("### STARTING testUpdateByCollectionName");
        SolrClient client = (SolrClient)this.clients.get(0);
        String baseUrl = ((HttpSolrClient)client).getBaseURL();
        try (SolrClient client1 = this.createNewSolrClient(this.oneInstanceCollection, baseUrl);){
            client1.commit();
        }
    }

    private void testANewCollectionInOneInstance() throws Exception {
        log.info("### STARTING testANewCollectionInOneInstance");
        CollectionAdminResponse response = (CollectionAdminResponse)CollectionAdminRequest.createCollection((String)this.oneInstanceCollection, (String)"conf1", (int)2, (int)2).setCreateNodeSet(((JettySolrRunner)this.jettys.get(0)).getNodeName()).process((SolrClient)this.cloudClient);
        AbstractBasicDistributedZkTestBase.assertEquals((long)0L, (long)response.getStatus());
        ArrayList<SolrClient> collectionClients = new ArrayList<SolrClient>();
        for (String coreName : response.getCollectionCoresStatus().keySet()) {
            collectionClients.add(this.createNewSolrClient(coreName, ((JettySolrRunner)this.jettys.get(0)).getBaseUrl().toString()));
        }
        SolrClient client1 = (SolrClient)collectionClients.get(0);
        SolrClient client2 = (SolrClient)collectionClients.get(1);
        SolrClient client3 = (SolrClient)collectionClients.get(2);
        SolrClient client4 = (SolrClient)collectionClients.get(3);
        this.waitForRecoveriesToFinish(this.oneInstanceCollection, ZkStateReader.from((CloudSolrClient)this.getCommonCloudSolrClient()), false);
        AbstractBasicDistributedZkTestBase.assertAllActive(this.oneInstanceCollection, ZkStateReader.from((CloudSolrClient)this.getCommonCloudSolrClient()));
        client2.add(AbstractBasicDistributedZkTestBase.getDoc(this.id, "1"));
        client3.add(AbstractBasicDistributedZkTestBase.getDoc(this.id, "2"));
        client4.add(AbstractBasicDistributedZkTestBase.getDoc(this.id, "3"));
        client1.commit();
        SolrQuery query = new SolrQuery("*:*");
        query.set("distrib", false);
        long oneDocs = client1.query((SolrParams)query).getResults().getNumFound();
        long twoDocs = client2.query((SolrParams)query).getResults().getNumFound();
        long threeDocs = client3.query((SolrParams)query).getResults().getNumFound();
        long fourDocs = client4.query((SolrParams)query).getResults().getNumFound();
        query.set("collection", new String[]{this.oneInstanceCollection});
        query.set("distrib", true);
        long allDocs = this.getCommonCloudSolrClient().query((SolrParams)query).getResults().getNumFound();
        AbstractBasicDistributedZkTestBase.assertEquals((long)3L, (long)allDocs);
        IOUtils.close(collectionClients);
    }

    private void createSolrCore(String collection, List<SolrClient> collectionClients, String baseUrl, int num, String shardId) {
        Callable<Object> call = () -> {
            try (HttpSolrClient client = AbstractBasicDistributedZkTestBase.getHttpSolrClient(baseUrl);){
                CoreAdminRequest.Create createCmd = new CoreAdminRequest.Create();
                createCmd.setRoles("none");
                createCmd.setCoreName(collection + num);
                createCmd.setCollection(collection);
                if (AbstractBasicDistributedZkTestBase.random().nextBoolean()) {
                    createCmd.setCoreNodeName("anode" + this.nodeCounter.incrementAndGet());
                }
                if (shardId == null) {
                    createCmd.setNumShards(2);
                }
                createCmd.setDataDir(this.getDataDir(AbstractBasicDistributedZkTestBase.createTempDir((String)collection).toFile().getAbsolutePath()));
                if (shardId != null) {
                    createCmd.setShardId(shardId);
                }
                client.request((SolrRequest)createCmd);
            }
            catch (Exception e) {
                log.error("error creating core", (Throwable)e);
            }
            return null;
        };
        this.pending.add(this.completionService.submit(call));
        collectionClients.add(this.createNewSolrClient(collection + num, baseUrl));
    }

    private void testMultipleCollections() throws Exception {
        log.info("### STARTING testMultipleCollections");
        this.createNewCollection("collection2");
        this.createNewCollection("collection3");
        while (this.pending != null && this.pending.size() > 0) {
            Future<Object> future = this.completionService.take();
            if (future == null) {
                return;
            }
            this.pending.remove(future);
        }
        this.indexDoc("collection2", AbstractBasicDistributedZkTestBase.getDoc(this.id, "10000000"));
        this.indexDoc("collection2", AbstractBasicDistributedZkTestBase.getDoc(this.id, "10000001"));
        this.indexDoc("collection2", AbstractBasicDistributedZkTestBase.getDoc(this.id, "10000003"));
        this.getSolrClient("collection2").add(AbstractBasicDistributedZkTestBase.getDoc(this.id, "10000004"));
        this.indexDoc("collection3", AbstractBasicDistributedZkTestBase.getDoc(this.id, "20000000"));
        this.indexDoc("collection3", AbstractBasicDistributedZkTestBase.getDoc(this.id, "20000001"));
        this.getSolrClient("collection3").add(AbstractBasicDistributedZkTestBase.getDoc(this.id, "10000005"));
        this.otherCollectionClients.get("collection2").get(0).commit();
        this.otherCollectionClients.get("collection3").get(0).commit();
        CloudSolrClient clientForCollection1 = this.getSolrClient(DEFAULT_COLLECTION);
        long collection1Docs = clientForCollection1.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound();
        long collection2Docs = this.otherCollectionClients.get("collection2").get(0).query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound();
        long collection3Docs = this.otherCollectionClients.get("collection3").get(0).query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound();
        SolrQuery query = new SolrQuery("*:*");
        query.set("collection", new String[]{"collection2,collection3"});
        long found = ((SolrClient)this.clients.get(0)).query((SolrParams)query).getResults().getNumFound();
        AbstractBasicDistributedZkTestBase.assertEquals((long)(collection2Docs + collection3Docs), (long)found);
        query = new SolrQuery("*:*");
        query.set("collection", new String[]{"collection1,collection2,collection3"});
        found = ((SolrClient)this.clients.get(0)).query((SolrParams)query).getResults().getNumFound();
        AbstractBasicDistributedZkTestBase.assertEquals((long)(collection1Docs + collection2Docs + collection3Docs), (long)found);
        found = this.getCommonCloudSolrClient().query((SolrParams)query).getResults().getNumFound();
        AbstractBasicDistributedZkTestBase.assertEquals((long)(collection1Docs + collection2Docs + collection3Docs), (long)found);
        query.set("collection", new String[]{"collection2,collection3"});
        found = this.getCommonCloudSolrClient().query((SolrParams)query).getResults().getNumFound();
        AbstractBasicDistributedZkTestBase.assertEquals((long)(collection2Docs + collection3Docs), (long)found);
        query.set("collection", new String[]{"collection3"});
        found = this.getCommonCloudSolrClient().query((SolrParams)query).getResults().getNumFound();
        AbstractBasicDistributedZkTestBase.assertEquals((long)collection3Docs, (long)found);
        query.remove("collection");
        found = this.getCommonCloudSolrClient().query((SolrParams)query).getResults().getNumFound();
        AbstractBasicDistributedZkTestBase.assertEquals((long)collection1Docs, (long)found);
        AbstractBasicDistributedZkTestBase.assertEquals((long)collection3Docs, (long)(collection2Docs - 1L));
    }

    protected void indexDoc(String collection, SolrInputDocument doc) throws IOException, SolrServerException {
        List<SolrClient> clients = this.otherCollectionClients.get(collection);
        int which = (doc.getField(this.id).toString().hashCode() & Integer.MAX_VALUE) % clients.size();
        SolrClient client = clients.get(which);
        client.add(doc);
    }

    private void createNewCollection(String collection) throws InterruptedException {
        try {
            AbstractBasicDistributedZkTestBase.assertEquals((long)0L, (long)((CollectionAdminResponse)CollectionAdminRequest.createCollection((String)collection, (String)"conf1", (int)2, (int)1).setCreateNodeSet("").process((SolrClient)this.cloudClient)).getStatus());
        }
        catch (Exception e) {
            log.error("error creating collection", (Throwable)e);
        }
        ArrayList<SolrClient> collectionClients = new ArrayList<SolrClient>();
        this.otherCollectionClients.put(collection, collectionClients);
        int unique = 0;
        for (JettySolrRunner runner : this.jettys) {
            int frozeUnique = ++unique;
            Callable<Object> call = () -> {
                try {
                    AbstractBasicDistributedZkTestBase.assertTrue((boolean)((CollectionAdminResponse)CollectionAdminRequest.addReplicaToShard((String)collection, (String)("shard" + (frozeUnique % 2 + 1))).setNode(runner.getNodeName()).process((SolrClient)this.cloudClient)).isSuccess());
                }
                catch (Exception e) {
                    log.error("error adding replica", (Throwable)e);
                }
                return null;
            };
            collectionClients.add(this.createNewSolrClient(collection, runner.getBaseUrl().toString()));
            this.pending.add(this.completionService.submit(call));
            while (this.pending != null && this.pending.size() > 0) {
                Future<Object> future = this.completionService.take();
                if (future == null) {
                    return;
                }
                this.pending.remove(future);
            }
        }
    }

    @Override
    protected SolrClient createNewSolrClient(String collection, String baseUrl) {
        HttpSolrClient client = AbstractBasicDistributedZkTestBase.getHttpSolrClient(baseUrl, collection);
        return client;
    }

    protected SolrClient createNewSolrClient(String collection, String baseUrl, int connectionTimeoutMillis, int socketTimeoutMillis) {
        HttpSolrClient client = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(baseUrl).withDefaultCollection(collection)).withConnectionTimeout(connectionTimeoutMillis, TimeUnit.MILLISECONDS)).withSocketTimeout(socketTimeoutMillis, TimeUnit.MILLISECONDS)).build();
        return client;
    }

    @Override
    protected QueryResponse queryServer(ModifiableSolrParams params) throws SolrServerException, IOException {
        if (r.nextBoolean()) {
            return super.queryServer(params);
        }
        if (r.nextBoolean()) {
            params.set("collection", new String[]{DEFAULT_COLLECTION});
        }
        QueryResponse rsp = this.getCommonCloudSolrClient().query((SolrParams)params);
        return rsp;
    }

    @Override
    public void distribTearDown() throws Exception {
        super.distribTearDown();
        if (this.otherCollectionClients != null) {
            for (List<SolrClient> clientList : this.otherCollectionClients.values()) {
                IOUtils.close(clientList);
            }
        }
        this.otherCollectionClients = null;
        List<Runnable> tasks = this.executor.shutdownNow();
        AbstractBasicDistributedZkTestBase.assertTrue((boolean)tasks.isEmpty());
    }
}

