/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.solr.client.solrj.request;

import java.util.HashSet;
import java.util.Set;
import org.apache.solr.client.solrj.InputStreamResponse;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

// WARNING: This class is generated from a Mustache template; any intended
// changes should be made to the underlying template and not this file directly.

/**
 * Experimental SolrRequest's and SolrResponse's for zookeeperRead, generated from an OAS.
 *
 * <p>See individual request and response classes for more detailed and relevant information.
 *
 * <p>All SolrRequest implementations rely on v2 APIs which may require a SolrClient configured to
 * use the '/api' path prefix, instead of '/solr'.
 *
 * @lucene.experimental
 */
public class ZookeeperReadApi {

  public static class ListNodesResponse
      extends JacksonParsingResponse<
          org.apache.solr.client.api.model.ZooKeeperListChildrenResponse> {
    public ListNodesResponse() {
      super(org.apache.solr.client.api.model.ZooKeeperListChildrenResponse.class);
    }
  }

  public static class ListNodes extends SolrRequest<ListNodesResponse> {
    private final String zkPath;
    private Boolean children;

    /**
     * Create a ListNodes request object.
     *
     * @param zkPath Path param - The path of the ZooKeeper node to stat and list children of
     */
    public ListNodes(String zkPath) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/cluster/zookeeper/children{zkPath}".replace("{" + "zkPath" + "}", zkPath));

      this.zkPath = zkPath;
    }

    /**
     * @param children Controls whether stat information for child nodes is included in the
     *     response. &#39;true&#39; by default.
     */
    public void setChildren(Boolean children) {
      this.children = children;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      if (children != null) {

        params.add("children", children.toString());
      }
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      queryParams.add("children");
      return queryParams;
    }

    @Override
    protected ListNodesResponse createResponse(SolrClient client) {
      return new ListNodesResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class ReadNodeResponse extends InputStreamResponse {}

  public static class ReadNode extends SolrRequest<ReadNodeResponse> {
    private final String zkPath;

    /**
     * Create a ReadNode request object.
     *
     * @param zkPath Path param - The path of the node to read from ZooKeeper
     */
    public ReadNode(String zkPath) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/cluster/zookeeper/data{zkPath}".replace("{" + "zkPath" + "}", zkPath));

      this.zkPath = zkPath;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      return queryParams;
    }

    @Override
    protected ReadNodeResponse createResponse(SolrClient client) {
      return new ReadNodeResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }
}
