/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.solr.client.solrj.request;

import java.util.HashSet;
import java.util.Set;
import org.apache.solr.client.api.model.GetSegmentDataResponse;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

// WARNING: This class is generated from a Mustache template; any intended
// changes should be made to the underlying template and not this file directly.

/**
 * Experimental SolrRequest's and SolrResponse's for segments, generated from an OAS.
 *
 * <p>See individual request and response classes for more detailed and relevant information.
 *
 * <p>All SolrRequest implementations rely on v2 APIs which may require a SolrClient configured to
 * use the '/api' path prefix, instead of '/solr'.
 *
 * @lucene.experimental
 */
public class SegmentsApi {

  public static class GetSegmentDataResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.GetSegmentDataResponse> {
    public GetSegmentDataResponse() {
      super(org.apache.solr.client.api.model.GetSegmentDataResponse.class);
    }
  }

  public static class GetSegmentData extends SolrRequest<GetSegmentDataResponse> {
    private final String coreName;
    private Boolean coreInfo;
    private Boolean fieldInfo;
    private Boolean rawSize;
    private Boolean rawSizeSummary;
    private Boolean rawSizeDetails;
    private Float rawSizeSamplingPercent;
    private Boolean sizeInfo;

    /**
     * Create a GetSegmentData request object.
     *
     * @param coreName Path param -
     */
    public GetSegmentData(String coreName) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/cores/{coreName}/segments".replace("{" + "coreName" + "}", coreName));

      this.coreName = coreName;
    }

    /**
     * @param coreInfo Boolean flag to include metadata (e.g. index an data directories, IndexWriter
     *     configuration, etc.) about each shard leader&#39;s core
     */
    public void setCoreInfo(Boolean coreInfo) {
      this.coreInfo = coreInfo;
    }

    /**
     * @param fieldInfo Boolean flag to include statistics about the indexed fields present on each
     *     shard leader.
     */
    public void setFieldInfo(Boolean fieldInfo) {
      this.fieldInfo = fieldInfo;
    }

    /**
     * @param rawSize Boolean flag to include simple estimates of the disk size taken up by each
     *     field (e.g. \&quot;id\&quot;, \&quot;_version_\&quot;) and by each index data structure
     *     (e.g. &#39;storedFields&#39;, &#39;docValues_numeric&#39;).
     */
    public void setRawSize(Boolean rawSize) {
      this.rawSize = rawSize;
    }

    /**
     * @param rawSizeSummary Boolean flag to include more involved estimates of the disk size taken
     *     up by index data structures, on a per-field basis (e.g. how much data does the
     *     \&quot;id\&quot; field contribute to &#39;storedField&#39; index files). More detail than
     *     &#39;rawSize&#39;, less detail than &#39;rawSizeDetails&#39;.
     */
    public void setRawSizeSummary(Boolean rawSizeSummary) {
      this.rawSizeSummary = rawSizeSummary;
    }

    /**
     * @param rawSizeDetails Boolean flag to include detailed statistics about the disk size taken
     *     up by various fields and data structures. More detail than &#39;rawSize&#39; and
     *     &#39;rawSizeSummary&#39;.
     */
    public void setRawSizeDetails(Boolean rawSizeDetails) {
      this.rawSizeDetails = rawSizeDetails;
    }

    /**
     * @param rawSizeSamplingPercent Percentage (between 0 and 100) of data to read when estimating
     *     index size and statistics. Defaults to 5.0 (i.e. 5%).
     */
    public void setRawSizeSamplingPercent(Float rawSizeSamplingPercent) {
      this.rawSizeSamplingPercent = rawSizeSamplingPercent;
    }

    /**
     * @param sizeInfo Boolean flag to include information about the largest index files for each
     *     Lucene segment.
     */
    public void setSizeInfo(Boolean sizeInfo) {
      this.sizeInfo = sizeInfo;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      if (coreInfo != null) {

        params.add("coreInfo", coreInfo.toString());
      }
      if (fieldInfo != null) {

        params.add("fieldInfo", fieldInfo.toString());
      }
      if (rawSize != null) {

        params.add("rawSize", rawSize.toString());
      }
      if (rawSizeSummary != null) {

        params.add("rawSizeSummary", rawSizeSummary.toString());
      }
      if (rawSizeDetails != null) {

        params.add("rawSizeDetails", rawSizeDetails.toString());
      }
      if (rawSizeSamplingPercent != null) {

        params.add("rawSizeSamplingPercent", rawSizeSamplingPercent.toString());
      }
      if (sizeInfo != null) {

        params.add("sizeInfo", sizeInfo.toString());
      }
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      queryParams.add("coreInfo");
      queryParams.add("fieldInfo");
      queryParams.add("rawSize");
      queryParams.add("rawSizeSummary");
      queryParams.add("rawSizeDetails");
      queryParams.add("rawSizeSamplingPercent");
      queryParams.add("sizeInfo");
      return queryParams;
    }

    @Override
    protected GetSegmentDataResponse createResponse(SolrClient client) {
      return new GetSegmentDataResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }
}
