/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.solr.client.solrj.request;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.solr.client.api.model.CreateAliasRequestBody;
import org.apache.solr.client.api.model.CreateCollectionRequestBody;
import org.apache.solr.client.api.model.GetAliasByNameResponse;
import org.apache.solr.client.api.model.RoutedAliasProperties;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

// WARNING: This class is generated from a Mustache template; any intended
// changes should be made to the underlying template and not this file directly.

/**
 * Experimental SolrRequest's and SolrResponse's for aliases, generated from an OAS.
 *
 * <p>See individual request and response classes for more detailed and relevant information.
 *
 * <p>All SolrRequest implementations rely on v2 APIs which may require a SolrClient configured to
 * use the '/api' path prefix, instead of '/solr'.
 *
 * @lucene.experimental
 */
public class AliasesApi {

  public static class CreateAliasResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public CreateAliasResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class CreateAlias extends SolrRequest<CreateAliasResponse> {
    private final CreateAliasRequestBody requestBody;

    /** Create a CreateAlias request object. */
    public CreateAlias() {
      super(SolrRequest.METHOD.valueOf("POST"), "/aliases");

      this.requestBody = new CreateAliasRequestBody();
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setName(String name) {
      this.requestBody.name = name;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setCollections(List<String> collections) {
      this.requestBody.collections = collections;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setAsync(String async) {
      this.requestBody.async = async;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setRouters(List<RoutedAliasProperties> routers) {
      this.requestBody.routers = routers;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setCollCreationParameters(CreateCollectionRequestBody collCreationParameters) {
      this.requestBody.collCreationParameters = collCreationParameters;
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
      // v2 only supports JSON request bodies, so we ignore this type coming from the RequestWriter
      return new JacksonContentWriter(requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      return queryParams;
    }

    @Override
    protected CreateAliasResponse createResponse(SolrClient client) {
      return new CreateAliasResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class DeleteAliasResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public DeleteAliasResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class DeleteAlias extends SolrRequest<DeleteAliasResponse> {
    private final String aliasName;
    private String async;

    /**
     * Create a DeleteAlias request object.
     *
     * @param aliasName Path param - The name of the alias to delete
     */
    public DeleteAlias(String aliasName) {
      super(
          SolrRequest.METHOD.valueOf("DELETE"),
          "/aliases/{aliasName}".replace("{" + "aliasName" + "}", aliasName));

      this.aliasName = aliasName;
    }

    public void setAsync(String async) {
      this.async = async;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      if (async != null) {

        params.add("async", async);
      }
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      queryParams.add("async");
      return queryParams;
    }

    @Override
    protected DeleteAliasResponse createResponse(SolrClient client) {
      return new DeleteAliasResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class GetAliasByNameResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.GetAliasByNameResponse> {
    public GetAliasByNameResponse() {
      super(org.apache.solr.client.api.model.GetAliasByNameResponse.class);
    }
  }

  public static class GetAliasByName extends SolrRequest<GetAliasByNameResponse> {
    private final String aliasName;

    /**
     * Create a GetAliasByName request object.
     *
     * @param aliasName Path param - Alias name.
     */
    public GetAliasByName(String aliasName) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/aliases/{aliasName}".replace("{" + "aliasName" + "}", aliasName));

      this.aliasName = aliasName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      return queryParams;
    }

    @Override
    protected GetAliasByNameResponse createResponse(SolrClient client) {
      return new GetAliasByNameResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class GetAliasesResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.ListAliasesResponse> {
    public GetAliasesResponse() {
      super(org.apache.solr.client.api.model.ListAliasesResponse.class);
    }
  }

  public static class GetAliases extends SolrRequest<GetAliasesResponse> {

    /** Create a GetAliases request object. */
    public GetAliases() {
      super(SolrRequest.METHOD.valueOf("GET"), "/aliases");
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      return queryParams;
    }

    @Override
    protected GetAliasesResponse createResponse(SolrClient client) {
      return new GetAliasesResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }
}
