/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.noggit.JSONParser;

public class JsonRecordReader {
    private Node rootNode = new Node("/", (Node)null);

    public static JsonRecordReader getInst(String split, List<String> fieldMappings) {
        JsonRecordReader jsonRecordReader = new JsonRecordReader(split);
        Iterator<String> i$ = fieldMappings.iterator();
        while (i$.hasNext()) {
            String s;
            String path = s = i$.next();
            int idx = s.indexOf(58);
            String fieldName = null;
            if (idx > 0) {
                fieldName = s.substring(0, idx);
                path = s.substring(idx + 1);
            }
            jsonRecordReader.addField(path, fieldName, true, false);
        }
        return jsonRecordReader;
    }

    private JsonRecordReader(String splitPath) {
        String[] splits;
        for (String split : splits = splitPath.split("\\|")) {
            if ((split = split.trim()).startsWith("//")) {
                throw new RuntimeException("split cannot start with '//': " + split);
            }
            if (split.length() == 0) continue;
            this.addField(split, split, false, true);
        }
    }

    private void addField(String path, String fieldName, boolean multiValued, boolean isRecord) {
        if (!path.startsWith("/")) {
            throw new RuntimeException("All paths must start with '/' " + path);
        }
        List<String> paths = JsonRecordReader.splitEscapeQuote(path);
        if (paths.size() == 0) {
            if (isRecord) {
                this.rootNode.isRecord = true;
            }
            return;
        }
        if ("".equals(paths.get(0).trim())) {
            paths.remove(0);
        }
        this.rootNode.build(paths, fieldName, multiValued, isRecord, path);
        this.rootNode.buildOptimize();
    }

    public List<Map<String, Object>> getAllRecords(Reader r) throws IOException {
        final ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        this.streamRecords(r, new Handler(){

            @Override
            public void handle(Map<String, Object> record, String path) {
                results.add(record);
            }
        });
        return results;
    }

    public void streamRecords(Reader r, Handler handler) throws IOException {
        this.streamRecords(new JSONParser(r), handler);
    }

    public void streamRecords(JSONParser parser, Handler handler) throws IOException {
        this.rootNode.parse(parser, handler, new LinkedHashMap(), new Stack(), false);
    }

    private static List<String> splitEscapeQuote(String str) {
        LinkedList<String> result = new LinkedList<String>();
        String[] ss = str.split("/");
        for (int i = 0; i < ss.length; ++i) {
            StringBuilder sb = new StringBuilder();
            int quoteCount = 0;
            while (true) {
                sb.append(ss[i]);
                for (int j = 0; j < ss[i].length(); ++j) {
                    if (ss[i].charAt(j) != '\'') continue;
                    ++quoteCount;
                }
                if (quoteCount % 2 == 0) break;
                ++i;
                sb.append("/");
            }
            result.add(sb.toString());
        }
        return result;
    }

    public static Object parseSingleFieldValue(int ev, JSONParser parser, MethodFrameWrapper runnable) throws IOException {
        switch (ev) {
            case 1: {
                return parser.getString();
            }
            case 2: {
                return parser.getLong();
            }
            case 3: {
                return parser.getDouble();
            }
            case 4: {
                return parser.getNumberChars().toString();
            }
            case 5: {
                return parser.getBoolean();
            }
            case 6: {
                parser.getNull();
                return null;
            }
            case 9: {
                return JsonRecordReader.parseArrayFieldValue(ev, parser, runnable);
            }
            case 7: {
                if (runnable != null) {
                    runnable.walk(7);
                    return null;
                }
                JsonRecordReader.consumeTillMatchingEnd(parser, 1, 0);
                return null;
            }
        }
        throw new RuntimeException("Error parsing JSON field value. Unexpected " + JSONParser.getEventString((int)ev));
    }

    public static List<Object> parseArrayFieldValue(int ev, JSONParser parser, MethodFrameWrapper runnable) throws IOException {
        assert (ev == 9);
        ArrayList<Object> lst = new ArrayList<Object>(2);
        while (true) {
            if ((ev = parser.nextEvent()) == 10) {
                if (lst.isEmpty()) {
                    return null;
                }
                return lst;
            }
            Object val = JsonRecordReader.parseSingleFieldValue(ev, parser, runnable);
            if (val == null) continue;
            lst.add(val);
        }
    }

    public static void consumeTillMatchingEnd(JSONParser parser, int obj, int arr) throws IOException {
        do {
            int event;
            if ((event = parser.nextEvent()) == 7) {
                ++obj;
            }
            if (event == 8) {
                --obj;
            }
            assert (obj >= 0);
            if (event == 9) {
                ++arr;
            }
            if (event == 10) {
                --arr;
            }
            assert (arr >= 0);
        } while (obj != 0 || arr != 0);
    }

    static abstract class MethodFrameWrapper {
        Node node;

        MethodFrameWrapper() {
        }

        public abstract void walk(int var1) throws IOException;
    }

    public static interface Handler {
        public void handle(Map<String, Object> var1, String var2);
    }

    private static class Node {
        String name;
        String fieldName;
        String splitPath;
        final LinkedHashMap<String, Node> childNodes = new LinkedHashMap();
        Node parent;
        boolean isLeaf = false;
        boolean isRecord = false;
        Node wildCardChild;
        Node recursiveWildCardChild;
        static final String WILDCARD_PATH = "*";
        static final String RECURSIVE_WILDCARD_PATH = "**";

        public Node(String name, Node p) {
            this.name = name;
            this.parent = p;
        }

        public Node(String name, String fieldName) {
            this.name = name;
            this.fieldName = fieldName;
        }

        private void buildOptimize() {
            if (this.parent != null && this.parent.recursiveWildCardChild != null && this.recursiveWildCardChild == null) {
                this.recursiveWildCardChild = this.parent.recursiveWildCardChild;
            }
            for (Node n : this.childNodes.values()) {
                n.buildOptimize();
            }
        }

        private void build(List<String> paths, String fieldName, boolean multiValued, boolean record, String path) {
            String segment = paths.remove(0);
            if (segment.length() < 1) {
                throw new RuntimeException("all pieces in path must be non empty " + path);
            }
            Node n = this.getOrAddNode(segment, this.childNodes);
            if (paths.isEmpty()) {
                if (record) {
                    assert (!WILDCARD_PATH.equals(n.name));
                    assert (!RECURSIVE_WILDCARD_PATH.equals(n.name));
                    n.isRecord = true;
                    n.splitPath = fieldName;
                } else {
                    if (n.name.equals(WILDCARD_PATH)) {
                        this.wildCardChild = n;
                    }
                    if (n.name.equals(RECURSIVE_WILDCARD_PATH)) {
                        this.recursiveWildCardChild = n.recursiveWildCardChild = n;
                    }
                    n.isLeaf = true;
                    n.fieldName = fieldName;
                }
            } else {
                if (WILDCARD_PATH.equals(this.name) || RECURSIVE_WILDCARD_PATH.equals(this.name)) {
                    throw new RuntimeException("wild cards are allowed only in the end " + path);
                }
                n.build(paths, fieldName, multiValued, record, path);
            }
        }

        private Node getOrAddNode(String pathName, Map<String, Node> children) {
            Node n = children.get(pathName);
            if (n != null) {
                return n;
            }
            n = new Node(pathName, this);
            children.put(pathName, n);
            return n;
        }

        private static Map<String, Object> getDeepCopy(Map<String, Object> values) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                if (entry.getValue() instanceof List) {
                    result.put(entry.getKey(), new ArrayList((List)entry.getValue()));
                    continue;
                }
                result.put(entry.getKey(), entry.getValue());
            }
            return result;
        }

        private void parse(JSONParser parser, Handler handler, Map<String, Object> values, Stack<Set<String>> stack, boolean recordStarted) throws IOException {
            int event = -1;
            while ((event = parser.nextEvent()) != 11) {
                if (event == 7) {
                    this.handleObjectStart(parser, new HashSet<Node>(), handler, values, stack, recordStarted);
                    continue;
                }
                if (event != 9) continue;
                while ((event = parser.nextEvent()) != 10) {
                    if (event != 7) continue;
                    this.handleObjectStart(parser, new HashSet<Node>(), handler, values, stack, recordStarted);
                }
            }
        }

        private void handleObjectStart(final JSONParser parser, final Set<Node> childrenFound, final Handler handler, final Map<String, Object> values, final Stack<Set<String>> stack, boolean recordStarted) throws IOException {
            final boolean isRecordStarted = recordStarted || this.isRecord;
            Set<Object> valuesAddedinThisFrame = null;
            if (this.isRecord) {
                valuesAddedinThisFrame = new HashSet();
                stack.push(valuesAddedinThisFrame);
            } else if (recordStarted) {
                valuesAddedinThisFrame = stack.peek();
            }
            try {
                int event;
                while (true) {
                    if ((event = parser.nextEvent()) == 8) {
                        if (this.isRecord()) {
                            handler.handle(Node.getDeepCopy(values), this.splitPath);
                        }
                        return;
                    }
                    assert (event == 1);
                    assert (parser.wasKey());
                    String name = parser.getString();
                    Node node = this.childNodes.get(name);
                    if (node == null) {
                        node = this.wildCardChild;
                    }
                    if (node == null) {
                        node = this.recursiveWildCardChild;
                    }
                    if (node != null) {
                        class Wrapper
                        extends MethodFrameWrapper {
                            Wrapper() {
                                this.node = node2;
                            }

                            @Override
                            public void walk(int event) throws IOException {
                                if (event == 7) {
                                    this.node.handleObjectStart(parser, childrenFound, handler, values, stack, isRecordStarted);
                                } else if (event == 9) {
                                    while ((event = parser.nextEvent()) != 10) {
                                        if (event != 7) continue;
                                        this.node.handleObjectStart(parser, childrenFound, handler, values, stack, isRecordStarted);
                                    }
                                }
                            }
                        }
                        if (node.isLeaf) {
                            Object val;
                            event = parser.nextEvent();
                            String nameInRecord = node.fieldName == null ? name : node.fieldName;
                            Wrapper runnable = null;
                            if ((event == 7 || event == 9) && node.recursiveWildCardChild != null) {
                                runnable = new Wrapper();
                            }
                            if ((val = JsonRecordReader.parseSingleFieldValue(event, parser, runnable)) == null) continue;
                            this.putValue(values, nameInRecord, val);
                            if (!isRecordStarted) continue;
                            valuesAddedinThisFrame.add(nameInRecord);
                            continue;
                        }
                        event = parser.nextEvent();
                        new Wrapper().walk(event);
                        continue;
                    }
                    event = parser.nextEvent();
                    if (event == 1 || event == 2 || event == 4 || event == 5 || event == 6) continue;
                    if (event == 9) {
                        JsonRecordReader.consumeTillMatchingEnd(parser, 0, 1);
                        continue;
                    }
                    if (event != 7) break;
                    JsonRecordReader.consumeTillMatchingEnd(parser, 1, 0);
                }
                throw new RuntimeException("unexpected token " + event);
            }
            finally {
                Set<String> cleanThis;
                if (!(!this.isRecord() && isRecordStarted || stack.empty() || (cleanThis = stack.pop()) == null)) {
                    for (String fld : cleanThis) {
                        values.remove(fld);
                    }
                }
            }
        }

        private boolean isRecord() {
            return this.isRecord;
        }

        private void putValue(Map<String, Object> values, String fieldName, Object o) {
            if (o == null) {
                return;
            }
            Object val = values.get(fieldName);
            if (val == null) {
                values.put(fieldName, o);
                return;
            }
            if (val instanceof List) {
                List list = (List)val;
                list.add(o);
                return;
            }
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(val);
            l.add(o);
            values.put(fieldName, l);
        }

        public String toString() {
            return this.name;
        }
    }
}

