/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudLegacySolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrClientCache
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, SolrClient> solrClients = new HashMap<String, SolrClient>();
    private final HttpClient httpClient;
    private static final int conTimeout = Math.max(Integer.parseInt(System.getProperty("connTimeout", "60000")), 60000);
    private static final int socketTimeout = Math.max(Integer.parseInt(System.getProperty("socketTimeout", "60000")), 60000);

    public SolrClientCache() {
        this.httpClient = null;
    }

    @Deprecated(since="9.0")
    public SolrClientCache(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Deprecated(since="9.0")
    public synchronized CloudSolrClient getCloudSolrClient(String zkHost) {
        CloudSolrClient client;
        assert (conTimeout >= 60000);
        assert (socketTimeout >= 60000);
        if (log.isDebugEnabled()) {
            log.debug("SolrClientCache.conTimeout: {}", (Object)conTimeout);
            log.debug("SolrClientCache.socketTimeout: {}", (Object)socketTimeout);
        }
        Objects.requireNonNull(zkHost, "ZooKeeper host cannot be null!");
        if (this.solrClients.containsKey(zkHost)) {
            client = (CloudSolrClient)this.solrClients.get(zkHost);
        } else {
            ArrayList<String> hosts = new ArrayList<String>();
            hosts.add(zkHost);
            CloudLegacySolrClient.Builder builder = (CloudLegacySolrClient.Builder)((CloudLegacySolrClient.Builder)new CloudLegacySolrClient.Builder(hosts, Optional.empty()).withSocketTimeout(socketTimeout, TimeUnit.MILLISECONDS)).withConnectionTimeout(conTimeout, TimeUnit.MILLISECONDS);
            if (this.httpClient != null) {
                builder = (CloudLegacySolrClient.Builder)builder.withHttpClient(this.httpClient);
            }
            client = builder.build();
            client.connect();
            this.solrClients.put(zkHost, (SolrClient)client);
        }
        return client;
    }

    @Deprecated(since="9.0")
    public synchronized SolrClient getHttpSolrClient(String baseUrl) {
        SolrClient client;
        if (this.solrClients.containsKey(baseUrl)) {
            client = this.solrClients.get(baseUrl);
        } else {
            HttpSolrClient.Builder builder = (HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(baseUrl).withSocketTimeout(socketTimeout, TimeUnit.MILLISECONDS)).withConnectionTimeout(conTimeout, TimeUnit.MILLISECONDS);
            if (this.httpClient != null) {
                builder = (HttpSolrClient.Builder)builder.withHttpClient(this.httpClient);
            }
            client = builder.build();
            this.solrClients.put(baseUrl, client);
        }
        return client;
    }

    public synchronized void close() {
        for (Map.Entry<String, SolrClient> entry : this.solrClients.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (IOException e) {
                log.error("Error closing SolrClient for {}", (Object)entry.getKey(), (Object)e);
            }
        }
        this.solrClients.clear();
    }
}

