/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.prometheus.exporter;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.embedded.SSLConfig;
import org.apache.solr.client.solrj.impl.CloudHttp2SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.NoOpResponseParser;
import org.apache.solr.prometheus.exporter.PrometheusExporterSettings;
import org.apache.solr.prometheus.exporter.SolrScrapeConfiguration;
import org.apache.zookeeper.client.ConnectStringParser;

public class SolrClientFactory {
    private final PrometheusExporterSettings settings;
    private final SolrScrapeConfiguration configuration;

    public SolrClientFactory(PrometheusExporterSettings settings, SolrScrapeConfiguration configuration) {
        this.settings = settings;
        this.configuration = configuration;
    }

    private static Http2SolrClient.Builder newHttp2SolrClientBuilder(String solrHost, PrometheusExporterSettings settings, SolrScrapeConfiguration configuration) {
        Http2SolrClient.Builder builder = (Http2SolrClient.Builder)((Http2SolrClient.Builder)((Http2SolrClient.Builder)new Http2SolrClient.Builder(solrHost).withIdleTimeout((long)settings.getHttpReadTimeout(), TimeUnit.MILLISECONDS)).withConnectionTimeout((long)settings.getHttpConnectionTimeout(), TimeUnit.MILLISECONDS)).withResponseParser((ResponseParser)new NoOpResponseParser("json"));
        if (configuration.getBasicAuthUser() != null) {
            builder.withBasicAuthCredentials(configuration.getBasicAuthUser(), configuration.getBasicAuthPwd());
        }
        if (configuration.isSSLEnabled()) {
            builder.withSSLConfig(new SSLConfig(true, true, configuration.getSslConfiguration().keystorePath.toString(), configuration.getSslConfiguration().keystorePassword, configuration.getSslConfiguration().trustStorePath.toString(), configuration.getSslConfiguration().trustStorePassword));
        }
        return builder;
    }

    public Http2SolrClient createStandaloneSolrClient(String solrHost) {
        return SolrClientFactory.newHttp2SolrClientBuilder(solrHost, this.settings, this.configuration).build();
    }

    public CloudSolrClient createCloudSolrClient(String zookeeperConnectionString) {
        ConnectStringParser parser = new ConnectStringParser(zookeeperConnectionString);
        List zkHosts = parser.getServerAddresses().stream().map(address -> address.getHostString() + ":" + address.getPort()).collect(Collectors.toList());
        CloudHttp2SolrClient client = new CloudHttp2SolrClient.Builder(zkHosts, Optional.ofNullable(parser.getChrootPath())).withHttpClientBuilder(SolrClientFactory.newHttp2SolrClientBuilder(null, this.settings, this.configuration)).withResponseParser((ResponseParser)new NoOpResponseParser("json")).build();
        client.connect();
        return client;
    }
}

