/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.api.endpoint;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.io.InputStream;
import java.util.List;
import org.apache.solr.client.api.model.FileStoreDirectoryListingResponse;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.api.model.UploadToFileStoreResponse;

@Path(value="/cluster/filestore")
public interface ClusterFileStoreApis {
    @PUT
    @Operation(summary="Upload a file to the filestore.", tags={"file-store"})
    @Path(value="/files{filePath:.+}")
    public UploadToFileStoreResponse uploadFile(@Parameter(description="File store path") @PathParam(value="filePath") String var1, @Parameter(description="Signature(s) for the file being uploaded") @QueryParam(value="sig") List<String> var2, @Parameter(description="File content to be stored in the filestore") @RequestBody(required=true, extensions={@Extension(properties={@ExtensionProperty(name="genericEntity", value="true")})}) InputStream var3);

    @GET
    @Operation(summary="Retrieve metadata about a file or directory in the filestore.", tags={"file-store"})
    @Path(value="/metadata{path:.+}")
    public FileStoreDirectoryListingResponse getMetadata(@Parameter(description="Path to a file or directory within the filestore") @PathParam(value="path") String var1);

    @GET
    @Operation(summary="Retrieve raw contents of a file in the filestore.", tags={"file-store"}, extensions={@Extension(properties={@ExtensionProperty(name="rawOutput", value="true")})})
    @Path(value="/files{filePath:.+}")
    public SolrJerseyResponse getFile(@Parameter(description="Path to a file or directory within the filestore") @PathParam(value="filePath") String var1);

    @DELETE
    @Operation(summary="Delete a file or directory from the filestore.", tags={"file-store"})
    @Path(value="/files{path:.+}")
    public SolrJerseyResponse deleteFile(@Parameter(description="Path to a file or directory within the filestore") @PathParam(value="path") String var1, @Parameter(description="Indicates whether the deletion should only be done on the receiving node.  For internal use only") @QueryParam(value="localDelete") Boolean var2);

    @POST
    @Operation(summary="Fetches a filestore entry from other nodes in the cluster.", tags={"file-store"})
    @Path(value="/commands/fetch{path:.+}")
    public SolrJerseyResponse fetchFile(@Parameter(description="Path to a file or directory within the filestore") @PathParam(value="path") String var1, @Parameter(description="An optional Solr node name to fetch the file from") @QueryParam(value="getFrom") String var2);

    @POST
    @Operation(summary="Syncs a file by pushing it to other nodes in the cluster.", tags={"file-store"})
    @Path(value="/commands/sync{path:.+}")
    public SolrJerseyResponse syncFile(@Parameter(description="Path to a file or directory within the filestore") @PathParam(value="path") String var1);
}

