/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.html.dom;

import org.apache.commons.lang3.StringUtils;
import org.apache.sling.scripting.sightly.compiler.SightlyCompilerException;
import org.apache.sling.scripting.sightly.impl.html.dom.MarkupHandler;
import org.apache.sling.scripting.sightly.impl.html.dom.template.Template;
import org.apache.sling.scripting.sightly.impl.html.dom.template.TemplateAttribute;
import org.apache.sling.scripting.sightly.impl.html.dom.template.TemplateCommentNode;
import org.apache.sling.scripting.sightly.impl.html.dom.template.TemplateElementNode;
import org.apache.sling.scripting.sightly.impl.html.dom.template.TemplateNode;
import org.apache.sling.scripting.sightly.impl.html.dom.template.TemplateTextNode;

public class TreeTraverser {
    private final MarkupHandler handler;

    public TreeTraverser(MarkupHandler handler) {
        this.handler = handler;
    }

    public void traverse(Template template) {
        this.traverseNode(template);
        this.handler.onDocumentFinished();
    }

    private void traverseNode(TemplateNode node) {
        if (node instanceof TemplateElementNode) {
            this.traverseElement((TemplateElementNode)node);
        } else if (node instanceof TemplateTextNode) {
            this.traverseText((TemplateTextNode)node);
        } else if (node instanceof TemplateCommentNode) {
            this.traverseComment((TemplateCommentNode)node);
        } else {
            throw new IllegalArgumentException("Unknown node type");
        }
    }

    private void traverseElement(TemplateElementNode elem) {
        SightlyCompilerException bubbledError = null;
        StringBuilder offendingInput = new StringBuilder();
        if ("ROOT".equalsIgnoreCase(elem.getName())) {
            this.traverseChildren(elem);
            return;
        }
        String tagName = elem.getName();
        if (elem.isStartElement()) {
            this.handler.onOpenTagStart("<" + tagName, tagName);
            try {
                for (TemplateAttribute attribute : elem.getAttributes()) {
                    this.handler.onAttribute(attribute.getName(), attribute.getValue(), attribute.getQuoteChar());
                }
            }
            catch (SightlyCompilerException e) {
                if (StringUtils.isEmpty((CharSequence)e.getOffendingInput())) {
                    bubbledError = e;
                    offendingInput.append("<").append(tagName);
                    for (TemplateAttribute attribute : elem.getAttributes()) {
                        String quoteChar = String.valueOf(attribute.getQuoteChar());
                        offendingInput.append(" ").append(attribute.getName());
                        if (!StringUtils.isNotEmpty((CharSequence)attribute.getValue())) continue;
                        offendingInput.append("=").append(quoteChar).append(attribute.getValue()).append(quoteChar);
                    }
                }
                throw e;
            }
            if (elem.hasEndSlash()) {
                this.handler.onOpenTagEnd("/>");
                if (bubbledError != null) {
                    offendingInput.append("/>");
                }
            } else {
                this.handler.onOpenTagEnd(">");
                if (bubbledError != null) {
                    offendingInput.append(">");
                }
            }
            if (bubbledError != null) {
                throw new SightlyCompilerException(bubbledError.getMessage(), offendingInput.toString());
            }
        } else {
            this.handler.onOpenTagStart("", tagName);
            this.handler.onOpenTagEnd("");
        }
        this.traverseChildren(elem);
        if (elem.isHasEndElement()) {
            this.handler.onCloseTag("</" + elem.getName() + ">");
        } else {
            this.handler.onCloseTag("");
        }
    }

    private void traverseText(TemplateTextNode textNode) {
        this.handler.onText(textNode.getText());
    }

    private void traverseComment(TemplateCommentNode comment) {
        this.handler.onComment(comment.getText());
    }

    private void traverseChildren(TemplateElementNode elem) {
        for (TemplateNode node : elem.getChildren()) {
            this.traverseNode(node);
        }
    }
}

