/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.helper;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.iterators.IteratorChain;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.resource.path.PathBuilder;
import org.apache.sling.resourceresolver.impl.helper.ChainedIterator;
import org.apache.sling.resourceresolver.impl.helper.ResourceResolverContext;
import org.apache.sling.resourceresolver.impl.helper.UniqueResourceIterator;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderHandler;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderStorage;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderStorageProvider;
import org.apache.sling.resourceresolver.impl.providers.stateful.AuthenticatedResourceProvider;
import org.apache.sling.resourceresolver.impl.providers.tree.Node;
import org.apache.sling.resourceresolver.impl.providers.tree.PathTree;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceResolverControl {
    private static final Logger logger = LoggerFactory.getLogger(ResourceResolverControl.class);
    private static final String[] FORBIDDEN_ATTRIBUTES = new String[]{"user.password", "sling.service.bundle", "sling.service.subservice"};
    private final boolean isAdmin;
    private final Map<String, Object> authenticationInfo;
    private volatile ResourceResolver resourceTypeResourceResolver;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final ResourceProviderStorageProvider resourceProviderTracker;
    private final Map<ResourceProviderHandler, Object> authenticatedProviders = new IdentityHashMap<ResourceProviderHandler, Object>();

    public ResourceResolverControl(boolean isAdmin, Map<String, Object> authenticationInfo, ResourceProviderStorageProvider resourceProviderTracker) {
        this.authenticationInfo = authenticationInfo;
        this.isAdmin = isAdmin;
        this.resourceProviderTracker = resourceProviderTracker;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public Map<String, Object> getAuthenticationInfo() {
        return this.authenticationInfo;
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    private void logout() {
        for (Map.Entry<ResourceProviderHandler, Object> entry : this.authenticatedProviders.entrySet()) {
            try {
                ResourceProvider<Object> rp = entry.getKey().getResourceProvider();
                if (rp != null) {
                    rp.logout(entry.getValue());
                    continue;
                }
                if (!(entry.getValue() instanceof Closeable)) continue;
                ((Closeable)entry.getValue()).close();
            }
            catch (Throwable throwable) {}
        }
        this.authenticatedProviders.clear();
    }

    public void refresh(@NotNull ResourceResolverContext context) {
        for (AuthenticatedResourceProvider p : context.getProviderManager().getAllUsedRefreshable()) {
            p.refresh();
        }
        if (this.resourceTypeResourceResolver != null) {
            this.resourceTypeResourceResolver.refresh();
        }
    }

    public boolean isLive(@NotNull ResourceResolverContext context) {
        for (AuthenticatedResourceProvider p : context.getProviderManager().getAllAuthenticated()) {
            if (p.isLive()) continue;
            return false;
        }
        return true;
    }

    public Resource getParent(@NotNull ResourceResolverContext context, @NotNull String parentPath, @NotNull Resource child) {
        Resource parentCandidate;
        AuthenticatedResourceProvider childProvider = this.getBestMatchingProvider(context, child.getPath());
        AuthenticatedResourceProvider parentProvider = this.getBestMatchingProvider(context, parentPath);
        if (parentProvider != null && (parentCandidate = childProvider == parentProvider ? parentProvider.getParent(child) : parentProvider.getResource(parentPath, null, null)) != null) {
            return parentCandidate;
        }
        if (this.isIntermediatePath(parentPath)) {
            return new SyntheticResource(context.getResourceResolver(), parentPath, "sling:syntheticResourceProviderResource");
        }
        return null;
    }

    public Resource getResource(ResourceResolverContext context, String path, Resource parent, Map<String, String> parameters, boolean isResolve) {
        Resource resourceCandidate;
        if (path == null || path.length() == 0 || path.charAt(0) != '/') {
            logger.debug("Not absolute {}", (Object)path);
            return null;
        }
        AuthenticatedResourceProvider provider = this.getBestMatchingProvider(context, path);
        if (provider != null && (resourceCandidate = provider.getResource(path, parent, parameters)) != null) {
            return resourceCandidate;
        }
        if (!isResolve && this.isIntermediatePath(path)) {
            logger.debug("Resolved Synthetic {}", (Object)path);
            return new SyntheticResource(context.getResourceResolver(), path, "sling:syntheticResourceProviderResource");
        }
        logger.debug("Resource null {} ", (Object)path);
        return null;
    }

    private boolean isIntermediatePath(String fullPath) {
        return this.getResourceProviderStorage().getTree().getNode(fullPath) != null;
    }

    public Iterator<Resource> listChildren(ResourceResolverContext context, Resource parent) {
        Node<ResourceProviderHandler> node;
        String parentPath = parent.getPath();
        Iterator<Resource> realChildren = null;
        AuthenticatedResourceProvider provider = this.getBestMatchingProvider(context, parentPath);
        if (provider != null) {
            realChildren = provider.listChildren(parent);
        }
        HashSet<String> visitedNames = new HashSet<String>();
        IteratorChain chain = new IteratorChain();
        if (realChildren != null) {
            chain.addIterator(realChildren);
        }
        if ((node = this.getResourceProviderStorage().getTree().getNode(parent.getPath())) != null) {
            ArrayList<SyntheticResource> syntheticList = new ArrayList<SyntheticResource>();
            ArrayList<Resource> providerList = new ArrayList<Resource>();
            for (Map.Entry<String, Node<ResourceProviderHandler>> entry : node.getChildren().entrySet()) {
                String name = entry.getKey();
                ResourceProviderHandler handler = entry.getValue().getValue();
                PathBuilder pathBuilder = new PathBuilder(parent.getPath());
                pathBuilder.append(name);
                String childPath = pathBuilder.toString();
                if (handler == null) {
                    syntheticList.add(new SyntheticResource(context.getResourceResolver(), childPath, "sling:syntheticResourceProviderResource"));
                    continue;
                }
                Resource rsrc = null;
                try {
                    AuthenticatedResourceProvider rp = context.getProviderManager().getOrCreateProvider(handler, this);
                    rsrc = rp == null ? null : rp.getResource(childPath, parent, null);
                }
                catch (LoginException loginException) {
                    // empty catch block
                }
                if (rsrc != null) {
                    providerList.add(rsrc);
                    continue;
                }
                if (entry.getValue().getChildren().isEmpty()) {
                    syntheticList.add(new SyntheticResource(context.getResourceResolver(), childPath, "sling:syntheticResourceProviderResource"));
                    continue;
                }
                visitedNames.add(name);
            }
            if (!providerList.isEmpty()) {
                chain.addIterator(providerList.iterator());
            }
            if (!syntheticList.isEmpty()) {
                chain.addIterator(syntheticList.iterator());
            }
        }
        if (chain.size() == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new UniqueResourceIterator(visitedNames, (Iterator<Resource>)chain);
    }

    public Collection<String> getAttributeNames(ResourceResolverContext context) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (AuthenticatedResourceProvider p : context.getProviderManager().getAllBestEffort(this.getResourceProviderStorage().getAttributableHandlers(), this)) {
            p.getAttributeNames(names);
        }
        if (this.authenticationInfo != null) {
            names.addAll(this.authenticationInfo.keySet());
        }
        for (String key : FORBIDDEN_ATTRIBUTES) {
            names.remove(key);
        }
        return names;
    }

    public Object getAttribute(ResourceResolverContext context, String name) {
        for (String key : FORBIDDEN_ATTRIBUTES) {
            if (!key.equals(name)) continue;
            return null;
        }
        for (AuthenticatedResourceProvider p : context.getProviderManager().getAllBestEffort(this.getResourceProviderStorage().getAttributableHandlers(), this)) {
            Object attribute = p.getAttribute(name);
            if (attribute == null) continue;
            return attribute;
        }
        return this.authenticationInfo != null ? this.authenticationInfo.get(name) : null;
    }

    public Resource create(ResourceResolverContext context, String path, Map<String, Object> properties) throws PersistenceException {
        Resource creationResultResource;
        AuthenticatedResourceProvider provider = this.getBestMatchingModifiableProvider(context, path);
        if (provider != null && (creationResultResource = provider.create(context.getResourceResolver(), path, properties)) != null) {
            return creationResultResource;
        }
        throw new UnsupportedOperationException("create '" + ResourceUtil.getName((String)path) + "' at " + ResourceUtil.getParent((String)path));
    }

    public void delete(ResourceResolverContext context, Resource resource) throws PersistenceException {
        String path = resource.getPath();
        AuthenticatedResourceProvider provider = this.getBestMatchingModifiableProvider(context, path);
        if (provider != null) {
            provider.delete(resource);
            return;
        }
        throw new UnsupportedOperationException("delete at '" + path + "'");
    }

    public void revert(ResourceResolverContext context) {
        for (AuthenticatedResourceProvider p : context.getProviderManager().getAllUsedModifiable()) {
            p.revert();
        }
    }

    public void commit(ResourceResolverContext context) throws PersistenceException {
        for (AuthenticatedResourceProvider p : context.getProviderManager().getAllUsedModifiable()) {
            p.commit();
        }
    }

    public boolean hasChanges(ResourceResolverContext context) {
        for (AuthenticatedResourceProvider p : context.getProviderManager().getAllUsedModifiable()) {
            if (!p.hasChanges()) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedLanguages(ResourceResolverContext context) {
        LinkedHashSet<String> supportedLanguages = new LinkedHashSet<String>();
        for (AuthenticatedResourceProvider p : context.getProviderManager().getAllBestEffort(this.getResourceProviderStorage().getLanguageQueryableHandlers(), this)) {
            supportedLanguages.addAll(Arrays.asList(p.getSupportedLanguages()));
        }
        return supportedLanguages.toArray(new String[supportedLanguages.size()]);
    }

    public Iterator<Resource> findResources(ResourceResolverContext context, String query, String language) {
        List<AuthenticatedResourceProvider> queryableRP = this.getQueryableProviders(context, language);
        ArrayList<Iterator<Resource>> iterators = new ArrayList<Iterator<Resource>>(queryableRP.size());
        for (AuthenticatedResourceProvider p : queryableRP) {
            iterators.add(p.findResources(query, language));
        }
        return new ChainedIterator<Resource>(iterators.iterator());
    }

    private List<AuthenticatedResourceProvider> getQueryableProviders(ResourceResolverContext context, String language) {
        ArrayList<AuthenticatedResourceProvider> queryableProviders = new ArrayList<AuthenticatedResourceProvider>();
        for (AuthenticatedResourceProvider p : context.getProviderManager().getAllBestEffort(this.getResourceProviderStorage().getLanguageQueryableHandlers(), this)) {
            if (!ArrayUtils.contains((Object[])p.getSupportedLanguages(), (Object)language)) continue;
            queryableProviders.add(p);
        }
        return queryableProviders;
    }

    public Iterator<Map<String, Object>> queryResources(ResourceResolverContext context, String query, String language) {
        List<AuthenticatedResourceProvider> queryableRP = this.getQueryableProviders(context, language);
        ArrayList<Iterator<Map<String, Object>>> iterators = new ArrayList<Iterator<Map<String, Object>>>(queryableRP.size());
        for (AuthenticatedResourceProvider p : queryableRP) {
            iterators.add(p.queryResources(query, language));
        }
        return new ChainedIterator<Map<String, Object>>(iterators.iterator());
    }

    public <AdapterType> AdapterType adaptTo(ResourceResolverContext context, Class<AdapterType> type) {
        for (AuthenticatedResourceProvider p : context.getProviderManager().getAllBestEffort(this.getResourceProviderStorage().getAdaptableHandlers(), this)) {
            AdapterType adaptee = p.adaptTo(type);
            if (adaptee == null) continue;
            return adaptee;
        }
        return null;
    }

    private AuthenticatedResourceProvider checkExistence(ResourceResolverContext context, String path, String type) throws PersistenceException {
        Node<ResourceProviderHandler> node = this.getResourceProviderStorage().getTree().getBestMatchingNode(path);
        if (node == null) {
            throw new PersistenceException(type.concat(" resource does not exist."), null, path, null);
        }
        AuthenticatedResourceProvider provider = null;
        try {
            provider = context.getProviderManager().getOrCreateProvider(node.getValue(), this);
        }
        catch (LoginException loginException) {
            // empty catch block
        }
        if (provider == null) {
            throw new PersistenceException(type.concat(" resource does not exist."), null, path, null);
        }
        Resource rsrc = provider.getResource(path, null, null);
        if (rsrc == null) {
            throw new PersistenceException(type.concat(" resource does not exist."), null, path, null);
        }
        return provider;
    }

    public AuthenticatedResourceProvider checkSourceAndDest(ResourceResolverContext context, String srcAbsPath, String destAbsPath) throws PersistenceException {
        AuthenticatedResourceProvider destProvider;
        AuthenticatedResourceProvider srcProvider = this.checkExistence(context, srcAbsPath, "Source");
        if (srcProvider == (destProvider = this.checkExistence(context, destAbsPath, "Destination"))) {
            PathTree<ResourceProviderHandler> providerTree = this.getResourceProviderStorage().getTree();
            boolean sourceHasProvider = this.hasSubProvider(context, providerTree.getNode(srcAbsPath));
            boolean destHasProvider = this.hasSubProvider(context, providerTree.getNode(destAbsPath));
            if (!sourceHasProvider && !destHasProvider) {
                return srcProvider;
            }
        }
        return null;
    }

    private boolean hasSubProvider(ResourceResolverContext context, Node<ResourceProviderHandler> node) {
        if (node != null) {
            for (Node<ResourceProviderHandler> childNode : node.getChildren().values()) {
                ResourceProviderHandler handler = childNode.getValue();
                if (handler != null) {
                    try {
                        context.getProviderManager().getOrCreateProvider(handler, this);
                        return true;
                    }
                    catch (LoginException loginException) {
                        // empty catch block
                    }
                }
                if (!this.hasSubProvider(context, childNode)) continue;
                return true;
            }
        }
        return false;
    }

    private void copy(ResourceResolverContext context, Resource src, String dstPath, List<Resource> newNodes) throws PersistenceException {
        ValueMap vm = src.getValueMap();
        String createPath = new PathBuilder(dstPath).append(src.getName()).toString();
        newNodes.add(this.create(context, createPath, (Map<String, Object>)vm));
        for (Resource c : src.getChildren()) {
            this.copy(context, c, createPath, newNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource copy(ResourceResolverContext context, String srcAbsPath, String destAbsPath) throws PersistenceException {
        AuthenticatedResourceProvider optimizedSourceProvider = this.checkSourceAndDest(context, srcAbsPath, destAbsPath);
        if (optimizedSourceProvider != null && optimizedSourceProvider.copy(srcAbsPath, destAbsPath)) {
            return this.getResource(context, destAbsPath + '/' + ResourceUtil.getName((String)srcAbsPath), null, null, false);
        }
        Resource srcResource = this.getResource(context, srcAbsPath, null, null, false);
        ArrayList<Resource> newResources = new ArrayList<Resource>();
        boolean rollback = true;
        try {
            this.copy(context, srcResource, destAbsPath, newResources);
            rollback = false;
            Resource resource = (Resource)newResources.get(0);
            return resource;
        }
        finally {
            if (rollback) {
                for (Resource rsrc : newResources) {
                    this.delete(context, rsrc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource move(ResourceResolverContext context, String srcAbsPath, String destAbsPath) throws PersistenceException {
        AuthenticatedResourceProvider optimizedSourceProvider = this.checkSourceAndDest(context, srcAbsPath, destAbsPath);
        if (optimizedSourceProvider != null && optimizedSourceProvider.move(srcAbsPath, destAbsPath)) {
            return this.getResource(context, destAbsPath + '/' + ResourceUtil.getName((String)srcAbsPath), null, null, false);
        }
        Resource srcResource = this.getResource(context, srcAbsPath, null, null, false);
        ArrayList<Resource> newResources = new ArrayList<Resource>();
        boolean rollback = true;
        try {
            this.copy(context, srcResource, destAbsPath, newResources);
            this.delete(context, srcResource);
            rollback = false;
            Resource resource = (Resource)newResources.get(0);
            return resource;
        }
        finally {
            if (rollback) {
                for (Resource rsrc : newResources) {
                    this.delete(context, rsrc);
                }
            }
        }
    }

    public ResourceProviderStorage getResourceProviderStorage() {
        return this.resourceProviderTracker.getResourceProviderStorage();
    }

    @Nullable
    private AuthenticatedResourceProvider getBestMatchingProvider(ResourceResolverContext context, String path) {
        try {
            Node<ResourceProviderHandler> node = this.resourceProviderTracker.getResourceProviderStorage().getTree().getBestMatchingNode(path);
            return node == null ? null : context.getProviderManager().getOrCreateProvider(node.getValue(), this);
        }
        catch (LoginException le) {
            return null;
        }
    }

    @Nullable
    private AuthenticatedResourceProvider getBestMatchingModifiableProvider(ResourceResolverContext context, String path) {
        Node<ResourceProviderHandler> node = this.resourceProviderTracker.getResourceProviderStorage().getTree().getBestMatchingNode(path);
        if (node != null && node.getValue().getInfo().isModifiable()) {
            try {
                return context.getProviderManager().getOrCreateProvider(node.getValue(), this);
            }
            catch (LoginException le) {
                return null;
            }
        }
        return null;
    }

    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.logout();
            if (this.resourceTypeResourceResolver != null) {
                try {
                    this.resourceTypeResourceResolver.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.resourceTypeResourceResolver = null;
            }
        }
    }

    private ResourceResolver getResourceTypeResourceResolver(ResourceResolverFactory factory, ResourceResolver resolver) {
        if (this.isAdmin) {
            return resolver;
        }
        if (this.resourceTypeResourceResolver == null) {
            try {
                Bundle bundle = FrameworkUtil.getBundle(ResourceResolverControl.class);
                HashMap<String, Object> authenticationInfo = new HashMap<String, Object>();
                authenticationInfo.put("sling.service.bundle", bundle);
                authenticationInfo.put("sling.service.subservice", "hierarchy");
                this.resourceTypeResourceResolver = factory.getServiceResourceResolver(authenticationInfo);
            }
            catch (LoginException e) {
                throw new IllegalStateException("Failed to create resource-type ResourceResolver", e);
            }
        }
        return this.resourceTypeResourceResolver;
    }

    public String getParentResourceType(ResourceResolverFactory factory, ResourceResolver resolver, String resourceType) {
        Resource rtResource;
        ResourceResolver adminResolver;
        String rtPath = resourceType == null ? null : ResourceUtil.resourceTypeToPath((String)resourceType);
        String resourceSuperType = null;
        if (rtPath != null && (adminResolver = this.getResourceTypeResourceResolver(factory, resolver)) != null && (rtResource = adminResolver.getResource(rtPath)) != null) {
            resourceSuperType = rtResource.getResourceSuperType();
        }
        return resourceSuperType;
    }

    public static String getProperty(Resource res, String propName) {
        return ResourceResolverControl.getProperty(res, propName, String.class);
    }

    public static <Type> Type getProperty(Resource res, String propName, Class<Type> type) {
        ValueMap props = (ValueMap)res.adaptTo(ValueMap.class);
        if (props != null) {
            Object prop = props.get(propName, type);
            if (prop != null) {
                return (Type)prop;
            }
            prop = props.get("jcr:content/" + propName, type);
            return (Type)prop;
        }
        return null;
    }

    public void registerAuthenticatedProvider(@NotNull ResourceProviderHandler handler, @Nullable Object providerState) {
        this.authenticatedProviders.put(handler, providerState);
    }

    public void clearAuthenticatedProviders() {
        this.authenticatedProviders.clear();
    }
}

