/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcemerger.impl;

import java.util.Map;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceProviderFactory;
import org.apache.sling.resourcemerger.impl.CRUDMergingResourceProvider;
import org.apache.sling.resourcemerger.impl.MergingResourceProvider;
import org.apache.sling.resourcemerger.spi.MergedResourcePicker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MergingResourceProviderFactory
implements ResourceProviderFactory {
    private final String mergeRootPath;
    private final MergedResourcePicker picker;
    private final boolean readOnly;

    MergingResourceProviderFactory(String mergeRootPath, MergedResourcePicker picker, boolean readOnly) {
        this.mergeRootPath = mergeRootPath;
        this.picker = picker;
        this.readOnly = readOnly;
    }

    public ResourceProvider getResourceProvider(Map<String, Object> authenticationInfo) throws LoginException {
        if (this.readOnly) {
            return new MergingResourceProvider(this.mergeRootPath, this.picker, this.readOnly);
        }
        return new CRUDMergingResourceProvider(this.mergeRootPath, this.picker);
    }

    public ResourceProvider getAdministrativeResourceProvider(Map<String, Object> authenticationInfo) throws LoginException {
        if (this.readOnly) {
            return new MergingResourceProvider(this.mergeRootPath, this.picker, this.readOnly);
        }
        return new CRUDMergingResourceProvider(this.mergeRootPath, this.picker);
    }
}

