/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcemerger.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.ModifyingResourceProvider;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.resourcemerger.impl.MergingResourceProvider;
import org.apache.sling.resourcemerger.spi.MergedResourcePicker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRUDMergingResourceProvider
extends MergingResourceProvider
implements ModifyingResourceProvider {
    public CRUDMergingResourceProvider(String mergeRootPath, MergedResourcePicker picker) {
        super(mergeRootPath, picker, false);
    }

    private ExtendedResourceHolder getAllResources(ResourceResolver resolver, String path, String relativePath) {
        ExtendedResourceHolder holder = new ExtendedResourceHolder(ResourceUtil.getName((String)path));
        holder.count = 0;
        for (Resource rsrc : this.picker.pickResources(resolver, relativePath)) {
            Resource parent;
            ++holder.count;
            holder.highestResourcePath = rsrc.getPath();
            if (ResourceUtil.isNonExistingResource((Resource)rsrc) || (parent = rsrc.getParent()) == null) continue;
            boolean hidden = new MergingResourceProvider.ParentHidingHandler(parent).isHidden(holder.name);
            if (hidden) {
                holder.resources.clear();
                continue;
            }
            holder.resources.add(rsrc);
        }
        return holder;
    }

    public Resource create(ResourceResolver resolver, String path, Map<String, Object> properties) throws PersistenceException {
        Resource mountResource = this.getResource(resolver, path);
        if (mountResource != null) {
            throw new PersistenceException("Resource at " + path + " already exists.", null, path, null);
        }
        String relativePath = this.getRelativePath(path);
        if (relativePath == null || relativePath.length() == 0) {
            throw new PersistenceException("Resource at " + path + " can't be created.", null, path, null);
        }
        ExtendedResourceHolder holder = this.getAllResources(resolver, path, relativePath);
        if (holder.count < 2) {
            throw new PersistenceException("Modifying is only supported with at least two potentially merged resources.", null, path, null);
        }
        if (holder.resources.size() == 0 || holder.resources.size() < holder.count && !holder.resources.get(holder.resources.size() - 1).getPath().equals(holder.highestResourcePath)) {
            String createPath = holder.highestResourcePath;
            Resource parentResource = ResourceUtil.getOrCreateResource((ResourceResolver)resolver, (String)ResourceUtil.getParent((String)createPath), (String)null, null, (boolean)false);
            resolver.create(parentResource, ResourceUtil.getName((String)createPath), properties);
        } else {
            Resource hidingResource = resolver.getResource(holder.highestResourcePath);
            if (hidingResource != null) {
                ModifiableValueMap mvm = (ModifiableValueMap)hidingResource.adaptTo(ModifiableValueMap.class);
                mvm.remove((Object)"sling:hideResource");
                mvm.putAll(properties);
            }
        }
        return this.getResource(resolver, path);
    }

    public void delete(ResourceResolver resolver, String path) throws PersistenceException {
        String relativePath = this.getRelativePath(path);
        if (relativePath == null || relativePath.length() == 0) {
            throw new PersistenceException("Resource at " + path + " can't be created.", null, path, null);
        }
        Resource mntResource = this.getResource(resolver, path);
        if (mntResource == null) {
            throw new PersistenceException("Resource at " + path + " does not exist", null, path, null);
        }
        ExtendedResourceHolder holder = this.getAllResources(resolver, path, relativePath);
        if (holder.count < 2) {
            throw new PersistenceException("Modifying is only supported with at least two potentially merged resources.", null, path, null);
        }
        if (holder.resources.size() == 1 && holder.resources.get(0).getPath().equals(holder.highestResourcePath)) {
            resolver.delete(holder.resources.get(0));
        } else {
            String createPath = holder.highestResourcePath;
            Resource parentResource = ResourceUtil.getOrCreateResource((ResourceResolver)resolver, (String)ResourceUtil.getParent((String)createPath), (String)null, null, (boolean)false);
            HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
            properties.put("sling:hideResource", Boolean.TRUE);
            resolver.create(parentResource, ResourceUtil.getName((String)createPath), properties);
        }
    }

    public void revert(ResourceResolver resolver) {
    }

    public void commit(ResourceResolver resolver) throws PersistenceException {
    }

    public boolean hasChanges(ResourceResolver resolver) {
        return false;
    }

    private static final class ExtendedResourceHolder {
        public final String name;
        public final List<Resource> resources = new ArrayList<Resource>();
        public int count;
        public String highestResourcePath;

        public ExtendedResourceHolder(String n) {
            this.name = n;
        }
    }
}

