/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcemerger.impl;

import java.util.Map;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceProviderFactory;
import org.apache.sling.resourcemerger.impl.CRUDMergingResourceProvider;
import org.apache.sling.resourcemerger.impl.MergingResourceProvider;
import org.apache.sling.resourcemerger.spi.MergedResourcePicker;

class MergingResourceProviderFactory
implements ResourceProviderFactory {
    private final String mergeRootPath;
    private final MergedResourcePicker picker;
    private final boolean readOnly;
    private final boolean traverseHierarchie;

    MergingResourceProviderFactory(String mergeRootPath, MergedResourcePicker picker, boolean readOnly, boolean traverseHierarchie) {
        this.mergeRootPath = mergeRootPath;
        this.picker = picker;
        this.readOnly = readOnly;
        this.traverseHierarchie = traverseHierarchie;
    }

    public ResourceProvider getResourceProvider(Map<String, Object> authenticationInfo) throws LoginException {
        if (this.readOnly) {
            return new MergingResourceProvider(this.mergeRootPath, this.picker, this.readOnly, this.traverseHierarchie);
        }
        return new CRUDMergingResourceProvider(this.mergeRootPath, this.picker, this.traverseHierarchie);
    }

    public ResourceProvider getAdministrativeResourceProvider(Map<String, Object> authenticationInfo) throws LoginException {
        if (this.readOnly) {
            return new MergingResourceProvider(this.mergeRootPath, this.picker, this.readOnly, this.traverseHierarchie);
        }
        return new CRUDMergingResourceProvider(this.mergeRootPath, this.picker, this.traverseHierarchie);
    }
}

