/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcemerger.impl;

import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceProviderFactory;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.resourcemerger.api.ResourceMergerService;
import org.apache.sling.resourcemerger.impl.MergedResourceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(name="Apache Sling Merged Resource Provider Factory", description="This resource provider delivers merged resources based on the search paths.", metatype=true)
@Service(value={ResourceProviderFactory.class, ResourceMergerService.class})
@Properties(value={@Property(name="provider.roots", value={"/mnt/overlay"}, label="Root", description="The mount point of merged resources"), @Property(name="provider.ownsRoots", boolValue={true}, propertyPrivate=true)})
public class MergedResourceProviderFactory
implements ResourceProviderFactory,
ResourceMergerService {
    public static final String DEFAULT_ROOT = "/mnt/overlay";
    private String mergeRootPath;

    public ResourceProvider getResourceProvider(Map<String, Object> stringObjectMap) throws LoginException {
        return new MergedResourceProvider(this.mergeRootPath);
    }

    public ResourceProvider getAdministrativeResourceProvider(Map<String, Object> stringObjectMap) throws LoginException {
        return new MergedResourceProvider(this.mergeRootPath);
    }

    @Override
    public String getMergedResourcePath(String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException("Provided relative path is null");
        }
        if (relativePath.startsWith("/")) {
            throw new IllegalArgumentException("Provided path is not a relative path");
        }
        return this.mergeRootPath + "/" + relativePath;
    }

    @Override
    public Resource getMergedResource(Resource resource) {
        if (resource != null) {
            String[] searchPaths;
            ResourceResolver resolver = resource.getResourceResolver();
            for (String searchPathPrefix : searchPaths = resolver.getSearchPath()) {
                if (!resource.getPath().startsWith(searchPathPrefix)) continue;
                String searchPath = searchPathPrefix.substring(0, searchPathPrefix.length() - 1);
                return resolver.getResource(resource.getPath().replaceFirst(searchPath, this.mergeRootPath));
            }
        }
        return null;
    }

    @Override
    public boolean isMergedResource(Resource resource) {
        if (resource == null) {
            return false;
        }
        return Boolean.TRUE.equals(resource.getResourceMetadata().get((Object)"sling.mergedResource"));
    }

    @Activate
    protected void configure(Map<String, Object> properties) {
        this.mergeRootPath = PropertiesUtil.toString((Object)properties.get("provider.roots"), (String)DEFAULT_ROOT);
        if (this.mergeRootPath.endsWith("/")) {
            this.mergeRootPath = this.mergeRootPath.substring(0, this.mergeRootPath.length() - 1);
        }
    }
}

