/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcemerger.impl;

import java.util.List;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.resourcemerger.impl.MergedValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergedResource
extends AbstractResource {
    private final ResourceResolver resolver;
    private final String path;
    private final String resourceType;
    private final ResourceMetadata metadata = new ResourceMetadata();
    private ValueMap properties;

    MergedResource(ResourceResolver resolver, String mergeRootPath, String relativePath, List<Resource> mappedResources, List<ValueMap> valueMaps) {
        this.resolver = resolver;
        this.path = relativePath.length() == 0 ? mergeRootPath : mergeRootPath + "/" + relativePath;
        this.properties = new MergedValueMap(valueMaps);
        this.resourceType = (String)this.properties.get("sling:resourceType", (Object)(relativePath.length() == 0 ? "/" : relativePath));
        this.metadata.put("sling.mergedResource", (Object)true);
        String[] resourcePaths = new String[mappedResources.size()];
        int i = 0;
        for (Resource rsrc : mappedResources) {
            resourcePaths[i] = rsrc.getPath();
            ++i;
        }
        this.metadata.put("sling.mergedResources", (Object)resourcePaths);
    }

    public String getPath() {
        return this.path;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceSuperType() {
        return null;
    }

    public ResourceMetadata getResourceMetadata() {
        return this.metadata;
    }

    public ResourceResolver getResourceResolver() {
        return this.resolver;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ValueMap.class) {
            return (AdapterType)this.properties;
        }
        return (AdapterType)super.adaptTo(type);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        Resource r = (Resource)o;
        return r.getPath().equals(this.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public String toString() {
        return "MergedResource [path=" + this.path + ", resources=" + this.metadata.get((Object)"sling.mergedResources") + "]";
    }
}

