/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.operations;

import java.util.Collections;
import java.util.List;
import org.apache.sling.repoinit.parser.impl.QuotableStringUtil;
import org.apache.sling.repoinit.parser.operations.AclGroupBase;
import org.apache.sling.repoinit.parser.operations.AclLine;
import org.apache.sling.repoinit.parser.operations.OperationVisitor;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class RemoveAcePrincipals
extends AclGroupBase {
    private final List<String> principals;

    public RemoveAcePrincipals(List<String> principals, List<AclLine> lines) {
        super(lines, Collections.emptyList());
        this.principals = Collections.unmodifiableList(principals);
    }

    @Override
    protected String getParametersDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.principals);
        sb.append(super.getParametersDescription());
        return sb.toString();
    }

    @Override
    @NotNull
    public String asRepoInitString() {
        String topline = String.format("remove ACE for %s%n", RemoveAcePrincipals.listToString(QuotableStringUtil.forRepoInitString(this.principals)));
        return this.asRepoInit(topline, true);
    }

    public List<String> getPrincipals() {
        return this.principals;
    }

    @Override
    public void accept(OperationVisitor v) {
        v.visitRemoveAcePrincipal(this);
    }
}

