/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class JcrItemResource<T extends Item>
extends AbstractResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrItemResource.class);
    private final ResourceResolver resourceResolver;
    protected final String path;
    protected final String version;
    private final T item;
    private final ResourceMetadata metadata;

    protected JcrItemResource(ResourceResolver resourceResolver, String path, String version, T item, ResourceMetadata metadata) {
        this.resourceResolver = resourceResolver;
        this.path = path;
        this.version = version;
        this.item = item;
        this.metadata = metadata;
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public String getPath() {
        if (this.version == null) {
            return this.path;
        }
        if (this.version.contains(".")) {
            return String.format("%s;v='%s'", this.path, this.version);
        }
        return String.format("%s;v=%s", this.path, this.version);
    }

    public ResourceMetadata getResourceMetadata() {
        return this.metadata;
    }

    protected T getItem() {
        return this.item;
    }

    protected String getResourceTypeForNode(Node node) throws RepositoryException {
        String result = null;
        if (node.hasProperty("sling:resourceType")) {
            result = node.getProperty("sling:resourceType").getString();
        }
        if (result == null || result.length() == 0) {
            result = node.hasProperty("{http://www.jcp.org/jcr/1.0}primaryType") ? node.getProperty("{http://www.jcp.org/jcr/1.0}primaryType").getString() : node.getPrimaryNodeType().getName();
        }
        return result;
    }

    public static long getContentLength(Property property) throws RepositoryException {
        if (property.isMultiple()) {
            return -1L;
        }
        long length = -1L;
        if (property.getType() == 2) {
            try {
                length = property.getLength();
            }
            catch (ValueFormatException vfe) {
                LOGGER.debug("Length of Property {} cannot be retrieved, ignored ({})", (Object)property.getPath(), (Object)vfe);
            }
        } else {
            length = property.getString().getBytes(StandardCharsets.UTF_8).length;
        }
        return length;
    }

    abstract Iterator<Resource> listJcrChildren();
}

