/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.jcr.resource.internal.helper.CalendarConverter;
import org.apache.sling.jcr.resource.internal.helper.Converter;

public class StringConverter
implements Converter {
    private final Object value;

    public StringConverter(Object val) {
        this.value = val;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public Long toLong() {
        return Long.parseLong(this.toString());
    }

    @Override
    public Byte toByte() {
        return Byte.parseByte(this.toString());
    }

    @Override
    public Short toShort() {
        return Short.parseShort(this.toString());
    }

    @Override
    public Integer toInteger() {
        return Integer.parseInt(this.toString());
    }

    @Override
    public Double toDouble() {
        return Double.parseDouble(this.toString());
    }

    @Override
    public Float toFloat() {
        return Float.valueOf(Float.parseFloat(this.toString()));
    }

    @Override
    public ZonedDateTime toZonedDateTime() {
        return new CalendarConverter(this.toCalendar()).toZonedDateTime();
    }

    @Override
    public Calendar toCalendar() {
        Calendar c = ISO8601.parse(this.toString());
        if (c == null) {
            throw new IllegalArgumentException("Not a date string: " + this.toString());
        }
        return c;
    }

    @Override
    public Date toDate() {
        Calendar c = this.toCalendar();
        return c.getTime();
    }

    @Override
    public Boolean toBoolean() {
        return Boolean.valueOf(this.toString());
    }

    @Override
    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.toString());
    }
}

