/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api.artifacts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionState;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.extension.apiregions.api.artifacts.Mode;
import org.apache.sling.feature.extension.apiregions.api.artifacts.VersionRule;
import org.apache.sling.feature.extension.apiregions.api.config.AttributeableEntity;

public class ArtifactRules
extends AttributeableEntity {
    public static final String EXTENSION_NAME = "artifact-rules";
    private Mode mode;
    private final List<VersionRule> bundleVersionRules = new ArrayList<VersionRule>();
    private final List<VersionRule> artifactVersionRules = new ArrayList<VersionRule>();

    public static ArtifactRules getArtifactRules(Feature feature) {
        Extension ext = feature == null ? null : feature.getExtensions().getByName(EXTENSION_NAME);
        return ArtifactRules.getArtifactRules(ext);
    }

    public static ArtifactRules getArtifactRules(Extension ext) {
        if (ext == null) {
            return null;
        }
        if (ext.getType() != ExtensionType.JSON) {
            throw new IllegalArgumentException("Extension " + ext.getName() + " must have JSON type");
        }
        try {
            ArtifactRules result = new ArtifactRules();
            result.fromJSONObject(ext.getJSONStructure().asJsonObject());
            return result;
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe.getMessage(), ioe);
        }
    }

    public static void setArtifactRules(Feature feature, ArtifactRules rules) {
        Extension ext = feature.getExtensions().getByName(EXTENSION_NAME);
        if (rules == null) {
            if (ext != null) {
                feature.getExtensions().remove((Object)ext);
            }
        } else {
            if (ext == null) {
                ext = new Extension(ExtensionType.JSON, EXTENSION_NAME, ExtensionState.OPTIONAL);
                feature.getExtensions().add((Object)ext);
            }
            try {
                ext.setJSONStructure((JsonStructure)rules.toJSONObject());
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe);
            }
        }
    }

    public ArtifactRules() {
        this.setDefaults();
    }

    @Override
    protected void setDefaults() {
        super.setDefaults();
        this.setMode(Mode.STRICT);
    }

    @Override
    public void clear() {
        super.clear();
        this.getBundleVersionRules().clear();
        this.getArtifactVersionRules().clear();
    }

    @Override
    public JsonObjectBuilder createJson() throws IOException {
        JsonArrayBuilder arrayBuilder;
        JsonObjectBuilder objBuilder = super.createJson();
        if (this.getMode() != Mode.STRICT) {
            objBuilder.add("mode", this.getMode().name());
        }
        if (!this.getBundleVersionRules().isEmpty()) {
            arrayBuilder = Json.createArrayBuilder();
            for (VersionRule rule : this.getBundleVersionRules()) {
                arrayBuilder.add(rule.createJson());
            }
            objBuilder.add("bundle-version-rules", arrayBuilder);
        }
        if (!this.getArtifactVersionRules().isEmpty()) {
            arrayBuilder = Json.createArrayBuilder();
            for (VersionRule rule : this.getArtifactVersionRules()) {
                arrayBuilder.add(rule.createJson());
            }
            objBuilder.add("artifact-version-rules", arrayBuilder);
        }
        return objBuilder;
    }

    @Override
    public void fromJSONObject(JsonObject jsonObj) throws IOException {
        super.fromJSONObject(jsonObj);
        try {
            VersionRule rule;
            JsonValue val;
            String modeVal = this.getString("mode");
            if (modeVal != null) {
                this.setMode(Mode.valueOf(modeVal.toUpperCase()));
            }
            if ((val = this.getAttributes().remove("bundle-version-rules")) != null) {
                for (JsonValue innerVal : val.asJsonArray()) {
                    rule = new VersionRule();
                    rule.fromJSONObject(innerVal.asJsonObject());
                    this.getBundleVersionRules().add(rule);
                }
            }
            if ((val = this.getAttributes().remove("artifact-version-rules")) != null) {
                for (JsonValue innerVal : val.asJsonArray()) {
                    rule = new VersionRule();
                    rule.fromJSONObject(innerVal.asJsonObject());
                    this.getArtifactVersionRules().add(rule);
                }
            }
        }
        catch (IllegalArgumentException | JsonException e) {
            throw new IOException(e);
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode value) {
        this.mode = value == null ? Mode.STRICT : value;
    }

    public List<VersionRule> getBundleVersionRules() {
        return this.bundleVersionRules;
    }

    public List<VersionRule> getArtifactVersionRules() {
        return this.artifactVersionRules;
    }
}

