/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.scanner.BundleDescriptor;

public class CheckBundlesForConnect
implements AnalyserTask {
    @Override
    public String getName() {
        return "Bundle Check For Connect";
    }

    @Override
    public String getId() {
        return "bundle-connect";
    }

    @Override
    public void execute(AnalyserTaskContext ctx) {
        HashMap<String, ArrayList<Artifact>> packageMap = new HashMap<String, ArrayList<Artifact>>();
        for (BundleDescriptor bundleDescriptor : ctx.getFeatureDescriptor().getBundleDescriptors()) {
            if (bundleDescriptor.getManifest() == null) continue;
            String cp = bundleDescriptor.getManifest().getMainAttributes().getValue("Bundle-ClassPath");
            String[] jars = null;
            if (cp != null) {
                jars = cp.split(",");
                ctx.reportArtifactWarning(bundleDescriptor.getArtifact().getId(), "Found bundle classpath in : " + cp);
            }
            HashSet<String> packages = new HashSet<String>();
            try (JarInputStream jis = new JarInputStream(bundleDescriptor.getArtifactFile().openStream());){
                JarEntry entry;
                while ((entry = jis.getNextJarEntry()) != null) {
                    if (entry.getName().endsWith(".class")) {
                        int lastPos = entry.getName().lastIndexOf(47);
                        if (lastPos == -1) {
                            ctx.reportArtifactError(bundleDescriptor.getArtifact().getId(), "Bundle contains classes in the default package");
                        } else {
                            packages.add(entry.getName().substring(0, lastPos));
                        }
                    } else if (!entry.isDirectory() && jars != null) {
                        for (String jar : jars) {
                            JarEntry inner;
                            if (!jar.equals(entry.getName())) continue;
                            JarInputStream is = new JarInputStream(jis);
                            while ((inner = is.getNextJarEntry()) != null) {
                                if (inner.getName().endsWith(".class")) {
                                    int lastPos = inner.getName().lastIndexOf(47);
                                    if (lastPos == -1) {
                                        ctx.reportArtifactError(bundleDescriptor.getArtifact().getId(), "Bundle contains (embedded) classes in the default package");
                                    } else {
                                        packages.add(inner.getName().substring(0, lastPos));
                                    }
                                }
                                is.closeEntry();
                            }
                        }
                    }
                    jis.closeEntry();
                }
            }
            catch (IOException ioe) {
                ctx.reportArtifactError(bundleDescriptor.getArtifact().getId(), "Unable to scan bundle: " + ioe.getMessage());
            }
            for (String p : packages) {
                ArrayList<Artifact> list = (ArrayList<Artifact>)packageMap.get(p);
                if (list == null) {
                    list = new ArrayList<Artifact>();
                    packageMap.put(p, list);
                }
                list.add(bundleDescriptor.getArtifact());
            }
        }
        for (Map.Entry entry : packageMap.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            ctx.reportWarning("Duplicate package " + (String)entry.getKey() + " in " + entry.getValue());
        }
    }
}

