/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.spi.metadata;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sling.caconfig.spi.metadata.AbstractMetadata;
import org.apache.sling.caconfig.spi.metadata.PropertyMetadata;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class ConfigurationMetadata
extends AbstractMetadata<ConfigurationMetadata> {
    private final Map<String, PropertyMetadata<?>> propertyMetadata;
    private final boolean collection;

    public ConfigurationMetadata(@NotNull String name, Collection<PropertyMetadata<?>> propertyMetadata, boolean collection) {
        super(name);
        this.propertyMetadata = ConfigurationMetadata.toMap(propertyMetadata);
        this.collection = collection;
    }

    private static Map<String, PropertyMetadata<?>> toMap(Collection<PropertyMetadata<?>> propertyMetadata) {
        LinkedHashMap map = new LinkedHashMap();
        for (PropertyMetadata<?> item : propertyMetadata) {
            if (map.containsKey(item.getName())) {
                throw new IllegalArgumentException("Duplicate property name: " + item.getName());
            }
            map.put(item.getName(), item);
        }
        return map;
    }

    public boolean isSingleton() {
        return !this.collection;
    }

    public boolean isCollection() {
        return this.collection;
    }

    public Map<String, PropertyMetadata<?>> getPropertyMetadata() {
        return this.propertyMetadata;
    }
}

