/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.resource.spi;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class ContextResource {
    private final Resource resource;
    private final String configRef;
    private final String key;

    public ContextResource(@Nonnull Resource resource, String configRef) {
        this.resource = resource;
        this.configRef = configRef;
        this.key = resource.getPath() + "|" + configRef;
    }

    @Nonnull
    public Resource getResource() {
        return this.resource;
    }

    @CheckForNull
    public String getConfigRef() {
        return this.configRef;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ContextResource) {
            return StringUtils.equals((CharSequence)this.key, (CharSequence)((ContextResource)obj).key);
        }
        return false;
    }
}

