/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.mysql;

import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.core.storage.IHistoryDeleteDAO;
import org.apache.skywalking.oap.server.core.storage.IRegisterLockDAO;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.StorageModule;
import org.apache.skywalking.oap.server.core.storage.cache.IEndpointInventoryCacheDAO;
import org.apache.skywalking.oap.server.core.storage.cache.INetworkAddressInventoryCacheDAO;
import org.apache.skywalking.oap.server.core.storage.cache.IServiceInstanceInventoryCacheDAO;
import org.apache.skywalking.oap.server.core.storage.cache.IServiceInventoryCacheDAO;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAlarmQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITopNRecordsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.core.storage.ttl.GeneralStorageTTL;
import org.apache.skywalking.oap.server.core.storage.ttl.StorageTTL;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2BatchDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2EndpointInventoryCacheDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2HistoryDeleteDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2MetadataQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2MetricsQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2NetworkAddressInventoryCacheDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2ProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2ProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2ProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2RegisterLockDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2RegisterLockInstaller;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2ServiceInstanceInventoryCacheDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2ServiceInventoryCacheDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2StorageDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2TopNRecordsQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2TopologyQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.mysql.MySQLAggregationQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.mysql.MySQLAlarmQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.mysql.MySQLLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.mysql.MySQLStorageConfig;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.mysql.MySQLTableInstaller;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.mysql.MySQLTraceQueryDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLStorageProvider
extends ModuleProvider {
    private static final Logger logger = LoggerFactory.getLogger(MySQLStorageProvider.class);
    private MySQLStorageConfig config = new MySQLStorageConfig();
    private JDBCHikariCPClient mysqlClient;
    private H2RegisterLockDAO lockDAO;

    public String name() {
        return "mysql";
    }

    public Class<? extends ModuleDefine> module() {
        return StorageModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException {
        this.mysqlClient = new JDBCHikariCPClient(this.config.getProperties());
        this.registerServiceImplementation(IBatchDAO.class, (Service)new H2BatchDAO(this.mysqlClient));
        this.registerServiceImplementation(StorageDAO.class, (Service)new H2StorageDAO(this.mysqlClient));
        this.lockDAO = new H2RegisterLockDAO(this.mysqlClient);
        this.registerServiceImplementation(IRegisterLockDAO.class, (Service)this.lockDAO);
        this.registerServiceImplementation(IServiceInventoryCacheDAO.class, (Service)new H2ServiceInventoryCacheDAO(this.mysqlClient));
        this.registerServiceImplementation(IServiceInstanceInventoryCacheDAO.class, (Service)new H2ServiceInstanceInventoryCacheDAO(this.mysqlClient));
        this.registerServiceImplementation(IEndpointInventoryCacheDAO.class, (Service)new H2EndpointInventoryCacheDAO(this.mysqlClient));
        this.registerServiceImplementation(INetworkAddressInventoryCacheDAO.class, (Service)new H2NetworkAddressInventoryCacheDAO(this.mysqlClient));
        this.registerServiceImplementation(ITopologyQueryDAO.class, (Service)new H2TopologyQueryDAO(this.mysqlClient));
        this.registerServiceImplementation(IMetricsQueryDAO.class, (Service)new H2MetricsQueryDAO(this.mysqlClient));
        this.registerServiceImplementation(ITraceQueryDAO.class, (Service)new MySQLTraceQueryDAO(this.mysqlClient));
        this.registerServiceImplementation(IMetadataQueryDAO.class, (Service)new H2MetadataQueryDAO(this.mysqlClient, this.config.getMetadataQueryMaxSize()));
        this.registerServiceImplementation(IAggregationQueryDAO.class, (Service)new MySQLAggregationQueryDAO(this.mysqlClient));
        this.registerServiceImplementation(IAlarmQueryDAO.class, (Service)new MySQLAlarmQueryDAO(this.mysqlClient));
        this.registerServiceImplementation(IHistoryDeleteDAO.class, (Service)new H2HistoryDeleteDAO((ModuleDefineHolder)this.getManager(), this.mysqlClient, (StorageTTL)new GeneralStorageTTL()));
        this.registerServiceImplementation(ITopNRecordsQueryDAO.class, (Service)new H2TopNRecordsQueryDAO(this.mysqlClient));
        this.registerServiceImplementation(ILogQueryDAO.class, (Service)new MySQLLogQueryDAO(this.mysqlClient));
        this.registerServiceImplementation(IProfileTaskQueryDAO.class, (Service)new H2ProfileTaskQueryDAO(this.mysqlClient));
        this.registerServiceImplementation(IProfileTaskLogQueryDAO.class, (Service)new H2ProfileTaskLogQueryDAO(this.mysqlClient));
        this.registerServiceImplementation(IProfileThreadSnapshotQueryDAO.class, (Service)new H2ProfileThreadSnapshotQueryDAO(this.mysqlClient));
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        try {
            this.mysqlClient.connect();
            MySQLTableInstaller installer = new MySQLTableInstaller(this.getManager());
            installer.install((Client)this.mysqlClient);
            new H2RegisterLockInstaller().install((Client)this.mysqlClient, this.lockDAO);
        }
        catch (StorageException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException {
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }
}

