/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.mysql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.Downsampling;
import org.apache.skywalking.oap.server.core.query.entity.Order;
import org.apache.skywalking.oap.server.core.query.entity.TopNEntity;
import org.apache.skywalking.oap.server.core.storage.model.ModelName;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2AggregationQueryDAO;

public class MySQLAggregationQueryDAO
extends H2AggregationQueryDAO {
    public MySQLAggregationQueryDAO(JDBCHikariCPClient client) {
        super(client);
    }

    @Override
    public List<TopNEntity> topNQuery(String indName, String valueCName, int topN, Downsampling downsampling, long startTB, long endTB, Order order, H2AggregationQueryDAO.AppendCondition appender) throws IOException {
        String tableName = ModelName.build((Downsampling)downsampling, (String)indName);
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> conditions = new ArrayList<Object>(10);
        sql.append("select avg(").append(valueCName).append(") value,").append("entity_id").append(" from ").append(tableName).append(" where ");
        this.setTimeRangeCondition(sql, conditions, startTB, endTB);
        if (appender != null) {
            appender.append(sql, conditions);
        }
        sql.append(" group by ").append("entity_id");
        sql.append(" order by value ").append(order.equals((Object)Order.ASC) ? "asc" : "desc").append(" limit ").append(topN);
        ArrayList<TopNEntity> topNEntities = new ArrayList<TopNEntity>();
        try (Connection connection = this.getH2Client().getConnection();
             ResultSet resultSet = this.getH2Client().executeQuery(connection, sql.toString(), conditions.toArray(new Object[0]));){
            while (resultSet.next()) {
                TopNEntity topNEntity = new TopNEntity();
                topNEntity.setId(resultSet.getString("entity_id"));
                topNEntity.setValue(resultSet.getLong("value"));
                topNEntities.add(topNEntity);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return topNEntities;
    }
}

