/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import com.google.common.base.Strings;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.profile.ProfileThreadSnapshotRecord;
import org.apache.skywalking.oap.server.core.query.entity.BasicTrace;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.util.BooleanUtils;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.elasticsearch.search.sort.SortOrder;

public class H2ProfileThreadSnapshotQueryDAO
implements IProfileThreadSnapshotQueryDAO {
    private JDBCHikariCPClient h2Client;

    public H2ProfileThreadSnapshotQueryDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
    }

    public List<BasicTrace> queryProfiledSegments(String taskId) throws IOException {
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append("segment_id").append(" from ").append("profile_task_segment_snapshot");
        sql.append(" where ").append("task_id").append(" = ? and ").append("sequence").append(" = 0");
        LinkedList<String> segments = new LinkedList<String>();
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), new Object[]{taskId});){
            while (resultSet.next()) {
                segments.add(resultSet.getString("segment_id"));
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        if (CollectionUtils.isEmpty(segments)) {
            return Collections.emptyList();
        }
        sql = new StringBuilder();
        sql.append("select * from ").append("segment").append(" where ");
        for (int i = 0; i < segments.size(); ++i) {
            sql.append(i > 0 ? " or " : "").append("segment_id").append(" = ? ");
        }
        sql.append(" order by ").append("start_time").append(" ").append(SortOrder.DESC);
        ArrayList<BasicTrace> result = new ArrayList<BasicTrace>(segments.size());
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), (Object[])segments.toArray(new String[segments.size()]));){
            while (resultSet.next()) {
                BasicTrace basicTrace = new BasicTrace();
                basicTrace.setSegmentId(resultSet.getString("segment_id"));
                basicTrace.setStart(resultSet.getString("start_time"));
                basicTrace.getEndpointNames().add(resultSet.getString("endpoint_name"));
                basicTrace.setDuration(resultSet.getInt("latency"));
                basicTrace.setError(BooleanUtils.valueToBoolean((int)resultSet.getInt("is_error")));
                String traceIds = resultSet.getString("trace_id");
                basicTrace.getTraceIds().add(traceIds);
                result.add(basicTrace);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return result;
    }

    public int queryMinSequence(String segmentId, long start, long end) throws IOException {
        return this.querySequenceWithAgg("min", segmentId, start, end);
    }

    public int queryMaxSequence(String segmentId, long start, long end) throws IOException {
        return this.querySequenceWithAgg("max", segmentId, start, end);
    }

    public List<ProfileThreadSnapshotRecord> queryRecords(String segmentId, int minSequence, int maxSequence) throws IOException {
        StringBuilder sql = new StringBuilder();
        sql.append("select * from ").append("profile_task_segment_snapshot").append(" where ");
        sql.append(" 1=1 ");
        sql.append(" and ").append("segment_id").append(" = ? ");
        sql.append(" and ").append("sequence").append(" >= ? ");
        sql.append(" and ").append("sequence").append(" < ? ");
        Object[] params = new Object[]{segmentId, minSequence, maxSequence};
        ArrayList<ProfileThreadSnapshotRecord> result = new ArrayList<ProfileThreadSnapshotRecord>(maxSequence - minSequence);
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), params);){
            while (resultSet.next()) {
                ProfileThreadSnapshotRecord record = new ProfileThreadSnapshotRecord();
                record.setTaskId(resultSet.getString("task_id"));
                record.setSegmentId(resultSet.getString("segment_id"));
                record.setDumpTime(resultSet.getLong("dump_time"));
                record.setSequence(resultSet.getInt("sequence"));
                String dataBinaryBase64 = resultSet.getString("stack_binary");
                if (StringUtil.isNotEmpty((String)dataBinaryBase64)) {
                    record.setStackBinary(Base64.getDecoder().decode(dataBinaryBase64));
                }
                result.add(record);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SegmentRecord getProfiledSegment(String segmentId) throws IOException {
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, "select * from segment where segment_id = ?", new Object[]{segmentId});){
            if (!resultSet.next()) return null;
            SegmentRecord segmentRecord = new SegmentRecord();
            segmentRecord.setSegmentId(resultSet.getString("segment_id"));
            segmentRecord.setTraceId(resultSet.getString("trace_id"));
            segmentRecord.setServiceId(resultSet.getInt("service_id"));
            segmentRecord.setEndpointName(resultSet.getString("endpoint_name"));
            segmentRecord.setStartTime(resultSet.getLong("start_time"));
            segmentRecord.setEndTime(resultSet.getLong("end_time"));
            segmentRecord.setLatency(resultSet.getInt("latency"));
            segmentRecord.setIsError(resultSet.getInt("is_error"));
            String dataBinaryBase64 = resultSet.getString("data_binary");
            if (!Strings.isNullOrEmpty((String)dataBinaryBase64)) {
                segmentRecord.setDataBinary(Base64.getDecoder().decode(dataBinaryBase64));
            }
            segmentRecord.setVersion(resultSet.getInt("version"));
            SegmentRecord segmentRecord2 = segmentRecord;
            return segmentRecord2;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int querySequenceWithAgg(String aggType, String segmentId, long start, long end) throws IOException {
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append(aggType).append("(").append("sequence").append(") from ").append("profile_task_segment_snapshot").append(" where ");
        sql.append(" 1=1 ");
        sql.append(" and ").append("segment_id").append(" = ? ");
        sql.append(" and ").append("dump_time").append(" >= ? ");
        sql.append(" and ").append("dump_time").append(" <= ? ");
        Object[] params = new Object[]{segmentId, start, end};
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), params);){
            if (!resultSet.next()) return -1;
            int n = resultSet.getInt(1);
            return n;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }
}

