/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.storage.IMetricsDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLExecutor;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2SQLExecutor;

public class H2MetricsDAO
extends H2SQLExecutor
implements IMetricsDAO {
    private JDBCHikariCPClient h2Client;
    private StorageBuilder<Metrics> storageBuilder;

    public H2MetricsDAO(JDBCHikariCPClient h2Client, StorageBuilder<Metrics> storageBuilder) {
        this.h2Client = h2Client;
        this.storageBuilder = storageBuilder;
    }

    public List<Metrics> multiGet(Model model, List<String> ids) throws IOException {
        List<StorageData> storageDataList = this.getByIDs(this.h2Client, model.getName(), ids.toArray(new String[0]), this.storageBuilder);
        ArrayList<Metrics> result = new ArrayList<Metrics>(storageDataList.size());
        for (StorageData storageData : storageDataList) {
            result.add((Metrics)storageData);
        }
        return result;
    }

    public SQLExecutor prepareBatchInsert(Model model, Metrics metrics) throws IOException {
        return this.getInsertExecutor(model.getName(), (StorageData)metrics, this.storageBuilder);
    }

    public SQLExecutor prepareBatchUpdate(Model model, Metrics metrics) throws IOException {
        return this.getUpdateExecutor(model.getName(), (StorageData)metrics, this.storageBuilder);
    }
}

