/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.storage.IHistoryDeleteDAO;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.ttl.StorageTTL;
import org.apache.skywalking.oap.server.core.storage.ttl.TTLCalculator;
import org.apache.skywalking.oap.server.library.client.jdbc.JDBCClientException;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLBuilder;
import org.joda.time.DateTime;

public class H2HistoryDeleteDAO
implements IHistoryDeleteDAO {
    private final JDBCHikariCPClient client;
    private final StorageTTL storageTTL;
    private final ModuleDefineHolder moduleDefineHolder;

    public H2HistoryDeleteDAO(ModuleDefineHolder moduleDefineHolder, JDBCHikariCPClient client, StorageTTL storageTTL) {
        this.client = client;
        this.storageTTL = storageTTL;
        this.moduleDefineHolder = moduleDefineHolder;
    }

    public void deleteHistory(Model model, String timeBucketColumnName) throws IOException {
        ConfigService configService = (ConfigService)this.moduleDefineHolder.find("core").provider().getService(ConfigService.class);
        SQLBuilder dataDeleteSQL = new SQLBuilder("delete from " + model.getName() + " where ").append(timeBucketColumnName).append("<= ?");
        try (Connection connection = this.client.getConnection();){
            TTLCalculator ttlCalculator = model.isRecord() ? this.storageTTL.recordCalculator() : this.storageTTL.metricsCalculator(model.getDownsampling());
            long timeBefore = ttlCalculator.timeBefore(new DateTime(), configService.getDataTTLConfig());
            this.client.execute(connection, dataDeleteSQL.toString(), new Object[]{timeBefore});
        }
        catch (SQLException | JDBCClientException e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

