/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.io.IOException;
import org.apache.skywalking.oap.server.core.register.EndpointInventory;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.cache.IEndpointInventoryCacheDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2SQLExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2EndpointInventoryCacheDAO
extends H2SQLExecutor
implements IEndpointInventoryCacheDAO {
    private static final Logger logger = LoggerFactory.getLogger(H2EndpointInventoryCacheDAO.class);
    private JDBCHikariCPClient h2Client;

    public H2EndpointInventoryCacheDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
    }

    public int getEndpointId(int serviceId, String endpointName, int detectPoint) {
        String id = EndpointInventory.buildId((int)serviceId, (String)endpointName, (int)detectPoint);
        return this.getEntityIDByID(this.h2Client, "sequence", "endpoint_inventory", id);
    }

    public EndpointInventory get(int endpointId) {
        try {
            return (EndpointInventory)this.getByColumn(this.h2Client, "endpoint_inventory", "sequence", endpointId, (StorageBuilder)new EndpointInventory.Builder());
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

