/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2;

import java.util.Properties;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.core.storage.IHistoryDeleteDAO;
import org.apache.skywalking.oap.server.core.storage.IRegisterLockDAO;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.StorageModule;
import org.apache.skywalking.oap.server.core.storage.cache.IEndpointInventoryCacheDAO;
import org.apache.skywalking.oap.server.core.storage.cache.INetworkAddressInventoryCacheDAO;
import org.apache.skywalking.oap.server.core.storage.cache.IServiceInstanceInventoryCacheDAO;
import org.apache.skywalking.oap.server.core.storage.cache.IServiceInventoryCacheDAO;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profile.IProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAlarmQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITopNRecordsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.core.storage.ttl.GeneralStorageTTL;
import org.apache.skywalking.oap.server.core.storage.ttl.StorageTTL;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.H2StorageConfig;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2AggregationQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2AlarmQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2BatchDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2EndpointInventoryCacheDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2HistoryDeleteDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2LogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2MetadataQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2MetricsQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2NetworkAddressInventoryCacheDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2ProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2ProfileTaskQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2ProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2RegisterLockDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2RegisterLockInstaller;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2ServiceInstanceInventoryCacheDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2ServiceInventoryCacheDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2StorageDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2TableInstaller;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2TopNRecordsQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2TopologyQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2TraceQueryDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2StorageProvider
extends ModuleProvider {
    private static final Logger logger = LoggerFactory.getLogger(H2StorageProvider.class);
    private H2StorageConfig config = new H2StorageConfig();
    private JDBCHikariCPClient h2Client;
    private H2RegisterLockDAO lockDAO;

    public String name() {
        return "h2";
    }

    public Class<? extends ModuleDefine> module() {
        return StorageModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        Properties settings = new Properties();
        settings.setProperty("dataSourceClassName", this.config.getDriver());
        settings.setProperty("dataSource.url", this.config.getUrl());
        settings.setProperty("dataSource.user", this.config.getUser());
        settings.setProperty("dataSource.password", this.config.getPassword());
        this.h2Client = new JDBCHikariCPClient(settings);
        this.registerServiceImplementation(IBatchDAO.class, (Service)new H2BatchDAO(this.h2Client));
        this.registerServiceImplementation(StorageDAO.class, (Service)new H2StorageDAO(this.h2Client));
        this.lockDAO = new H2RegisterLockDAO(this.h2Client);
        this.registerServiceImplementation(IRegisterLockDAO.class, (Service)this.lockDAO);
        this.registerServiceImplementation(IServiceInventoryCacheDAO.class, (Service)new H2ServiceInventoryCacheDAO(this.h2Client));
        this.registerServiceImplementation(IServiceInstanceInventoryCacheDAO.class, (Service)new H2ServiceInstanceInventoryCacheDAO(this.h2Client));
        this.registerServiceImplementation(IEndpointInventoryCacheDAO.class, (Service)new H2EndpointInventoryCacheDAO(this.h2Client));
        this.registerServiceImplementation(INetworkAddressInventoryCacheDAO.class, (Service)new H2NetworkAddressInventoryCacheDAO(this.h2Client));
        this.registerServiceImplementation(ITopologyQueryDAO.class, (Service)new H2TopologyQueryDAO(this.h2Client));
        this.registerServiceImplementation(IMetricsQueryDAO.class, (Service)new H2MetricsQueryDAO(this.h2Client));
        this.registerServiceImplementation(ITraceQueryDAO.class, (Service)new H2TraceQueryDAO(this.h2Client));
        this.registerServiceImplementation(IMetadataQueryDAO.class, (Service)new H2MetadataQueryDAO(this.h2Client, this.config.getMetadataQueryMaxSize()));
        this.registerServiceImplementation(IAggregationQueryDAO.class, (Service)new H2AggregationQueryDAO(this.h2Client));
        this.registerServiceImplementation(IAlarmQueryDAO.class, (Service)new H2AlarmQueryDAO(this.h2Client));
        this.registerServiceImplementation(IHistoryDeleteDAO.class, (Service)new H2HistoryDeleteDAO((ModuleDefineHolder)this.getManager(), this.h2Client, (StorageTTL)new GeneralStorageTTL()));
        this.registerServiceImplementation(ITopNRecordsQueryDAO.class, (Service)new H2TopNRecordsQueryDAO(this.h2Client));
        this.registerServiceImplementation(ILogQueryDAO.class, (Service)new H2LogQueryDAO(this.h2Client));
        this.registerServiceImplementation(IProfileTaskQueryDAO.class, (Service)new H2ProfileTaskQueryDAO(this.h2Client));
        this.registerServiceImplementation(IProfileTaskLogQueryDAO.class, (Service)new H2ProfileTaskLogQueryDAO(this.h2Client));
        this.registerServiceImplementation(IProfileThreadSnapshotQueryDAO.class, (Service)new H2ProfileThreadSnapshotQueryDAO(this.h2Client));
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        try {
            this.h2Client.connect();
            H2TableInstaller installer = new H2TableInstaller(this.getManager());
            installer.install((Client)this.h2Client);
            new H2RegisterLockInstaller().install((Client)this.h2Client, this.lockDAO);
        }
        catch (StorageException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }
}

