/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.core.query.entity.Order;
import org.apache.skywalking.oap.server.core.query.entity.TopNRecord;
import org.apache.skywalking.oap.server.core.storage.query.ITopNRecordsQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;

public class H2TopNRecordsQueryDAO
implements ITopNRecordsQueryDAO {
    private JDBCHikariCPClient h2Client;

    public H2TopNRecordsQueryDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
    }

    public List<TopNRecord> getTopNRecords(long startSecondTB, long endSecondTB, String metricName, int serviceId, int topN, Order order) throws IOException {
        StringBuilder sql = new StringBuilder("select * from " + metricName + " where ");
        ArrayList<Number> parameters = new ArrayList<Number>(10);
        sql.append(" service_id = ? ");
        parameters.add(serviceId);
        sql.append(" and ").append("time_bucket").append(" >= ?");
        parameters.add(startSecondTB);
        sql.append(" and ").append("time_bucket").append(" <= ?");
        parameters.add(endSecondTB);
        sql.append(" order by ").append("latency");
        if (order.equals((Object)Order.DES)) {
            sql.append(" desc ");
        } else {
            sql.append(" asc ");
        }
        sql.append(" limit ").append(topN);
        ArrayList<TopNRecord> results = new ArrayList<TopNRecord>();
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), parameters.toArray(new Object[0]));){
            while (resultSet.next()) {
                TopNRecord record = new TopNRecord();
                record.setStatement(resultSet.getString("statement"));
                record.setTraceId(resultSet.getString("trace_id"));
                record.setLatency(resultSet.getLong("latency"));
                results.add(record);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return results;
    }
}

