/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntKeyLongValueHashMap;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.model.ColumnName;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.jdbc.JDBCClientException;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLBuilder;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2TableInstaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLTableInstaller
extends H2TableInstaller {
    private static final Logger logger = LoggerFactory.getLogger(MySQLTableInstaller.class);

    public MySQLTableInstaller(ModuleManager moduleManager) {
        super(moduleManager);
        this.overrideColumnName("precision", "cal_precision");
        this.overrideColumnName("match", "match_num");
    }

    @Override
    protected void createTable(Client client, Model model) throws StorageException {
        super.createTable(client, model);
        JDBCHikariCPClient jdbcHikariCPClient = (JDBCHikariCPClient)client;
        this.createIndexes(jdbcHikariCPClient, model);
    }

    @Override
    protected String getColumnType(Model model, ColumnName name, Class<?> type) {
        if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            return "INT";
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return "BIGINT";
        }
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            return "DOUBLE";
        }
        if (String.class.equals(type)) {
            if (12 == model.getScopeId()) {
                if (name.getName().equals("trace_id") || name.getName().equals("segment_id")) {
                    return "VARCHAR(300)";
                }
                if (name.getName().equals("data_binary")) {
                    return "MEDIUMTEXT";
                }
            }
            return "VARCHAR(2000)";
        }
        if (IntKeyLongValueHashMap.class.equals(type)) {
            return "MEDIUMTEXT";
        }
        if (byte[].class.equals(type)) {
            return "MEDIUMTEXT";
        }
        throw new IllegalArgumentException("Unsupported data type: " + type.getName());
    }

    protected void createIndexes(JDBCHikariCPClient client, Model model) throws StorageException {
        switch (model.getScopeId()) {
            case 7: 
            case 14: 
            case 15: 
            case 16: {
                this.createInventoryIndexes(client, model);
                return;
            }
            case 12: {
                this.createSegmentIndexes(client, model);
                return;
            }
            case 13: {
                this.createAlarmIndexes(client, model);
                return;
            }
        }
        this.createIndexesForAllMetrics(client, model);
    }

    private void createIndexesForAllMetrics(JDBCHikariCPClient client, Model model) throws StorageException {
        try (Connection connection = client.getConnection();){
            SQLBuilder tableIndexSQL = new SQLBuilder("CREATE INDEX ");
            tableIndexSQL.append(model.getName().toUpperCase()).append("_TIME_BUCKET ");
            tableIndexSQL.append("ON ").append(model.getName()).append("(").append("time_bucket").append(")");
            this.createIndex(client, connection, model, tableIndexSQL);
        }
        catch (SQLException | JDBCClientException e) {
            throw new StorageException(e.getMessage(), e);
        }
    }

    private void createAlarmIndexes(JDBCHikariCPClient client, Model model) throws StorageException {
        try (Connection connection = client.getConnection();){
            SQLBuilder tableIndexSQL = new SQLBuilder("CREATE INDEX ");
            tableIndexSQL.append(model.getName().toUpperCase()).append("_TIME_BUCKET ");
            tableIndexSQL.append("ON ").append(model.getName()).append("(").append("time_bucket").append(")");
            this.createIndex(client, connection, model, tableIndexSQL);
        }
        catch (SQLException | JDBCClientException e) {
            throw new StorageException(e.getMessage(), e);
        }
    }

    private void createSegmentIndexes(JDBCHikariCPClient client, Model model) throws StorageException {
        try (Connection connection = client.getConnection();){
            SQLBuilder tableIndexSQL = new SQLBuilder("CREATE INDEX ");
            tableIndexSQL.append(model.getName().toUpperCase()).append("_TRACE_ID ");
            tableIndexSQL.append("ON ").append(model.getName()).append("(").append("trace_id").append(")");
            this.createIndex(client, connection, model, tableIndexSQL);
            tableIndexSQL = new SQLBuilder("CREATE INDEX ");
            tableIndexSQL.append(model.getName().toUpperCase()).append("_ENDPOINT_ID ");
            tableIndexSQL.append("ON ").append(model.getName()).append("(").append("endpoint_id").append(")");
            this.createIndex(client, connection, model, tableIndexSQL);
            tableIndexSQL = new SQLBuilder("CREATE INDEX ");
            tableIndexSQL.append(model.getName().toUpperCase()).append("_LATENCY ");
            tableIndexSQL.append("ON ").append(model.getName()).append("(").append("latency").append(")");
            this.createIndex(client, connection, model, tableIndexSQL);
            tableIndexSQL = new SQLBuilder("CREATE INDEX ");
            tableIndexSQL.append(model.getName().toUpperCase()).append("_TIME_BUCKET ");
            tableIndexSQL.append("ON ").append(model.getName()).append("(").append("time_bucket").append(")");
            this.createIndex(client, connection, model, tableIndexSQL);
        }
        catch (SQLException | JDBCClientException e) {
            throw new StorageException(e.getMessage(), e);
        }
    }

    private void createInventoryIndexes(JDBCHikariCPClient client, Model model) throws StorageException {
        try (Connection connection = client.getConnection();){
            SQLBuilder tableIndexSQL = new SQLBuilder("CREATE UNIQUE INDEX ");
            tableIndexSQL.append(model.getName().toUpperCase()).append("_SEQ ");
            tableIndexSQL.append("ON ").append(model.getName()).append("(").append("sequence").append(")");
            this.createIndex(client, connection, model, tableIndexSQL);
            tableIndexSQL = new SQLBuilder("CREATE INDEX ");
            tableIndexSQL.append(model.getName().toUpperCase()).append("_TIME ");
            tableIndexSQL.append("ON ").append(model.getName()).append("(").append("heartbeat_time").append(", ").append("register_time").append(")");
            this.createIndex(client, connection, model, tableIndexSQL);
        }
        catch (SQLException | JDBCClientException e) {
            throw new StorageException(e.getMessage(), e);
        }
    }

    private void createIndex(JDBCHikariCPClient client, Connection connection, Model model, SQLBuilder indexSQL) throws JDBCClientException {
        if (logger.isDebugEnabled()) {
            logger.debug("create index for table {}, sql: {} ", (Object)model.getName(), (Object)indexSQL.toStringInNewLine());
        }
        client.execute(connection, indexSQL.toString());
    }
}

